<?php
/* HTTPS link by venge@lokalsound.com
         expanded by pdontthink@angrynerds.com */



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



function ssl_link_set_session_vars_do() {

   global $https_logoff_count, $plugin_show_ssl_link_cameInUnencrypted,
          $show_ssl_link_orig_url;

   $https_logoff_count = 0;
   compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS, $HTTP_GET_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
      $_GET = $HTTP_GET_VARS;
   }

   if ( isset($_SERVER['HTTPS']) && isset($_GET['do_secure_login'])) 
   {
      $plugin_show_ssl_link_cameInUnencrypted = 'yes';
      compatibility_sqsession_register($plugin_show_ssl_link_cameInUnencrypted, 
                                       'plugin_show_ssl_link_cameInUnencrypted');
      if (isset($_GET['orig_url']))
      {
         $show_ssl_link_orig_url = $_GET['orig_url'];
         compatibility_sqsession_register($show_ssl_link_orig_url,
                                          'show_ssl_link_orig_url');
      }
   }

}



function show_ssl_link_do() {

   global $my_ssl_url, $my_ssl_text, $my_ssl_extra,
          $allVirtualDomainsAreUnderOneSSLHost, $mySecurePort, 
          $https_logoff_count;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/show_ssl_link/config.php');
   else
      include_once ('../plugins/show_ssl_link/config.php');


   if (empty($my_ssl_url)) {

      $requestHost = $_SERVER['HTTP_HOST'];

      if (isset($mySecurePort))
      {
         if (!empty($mySecurePort))
            $mySecurePort = ':' . $mySecurePort;

         list($host, $port) = preg_split('/:/', $requestHost);
         $newRequestHost = $host . $mySecurePort;
      }
      else
         $newRequestHost = $requestHost;


      $my_ssl_url = 'https://'
                . $newRequestHost . $_SERVER['REQUEST_URI'] . '?do_secure_login=yes';

      if (!empty($allVirtualDomainsAreUnderOneSSLHost))
         $my_ssl_url = 'https://' . $allVirtualDomainsAreUnderOneSSLHost
                   . $newRequestHost . $_SERVER['REQUEST_URI'] . '?do_secure_login=yes';

   }

   // if we have a secure URL already defined, need to save the
   // current URL in case we have to come back to it under http
   // after login
   //
   else
   {
      // note that we assume that this URL doesn't 
      // already have any query string on the end
      //
      $my_ssl_url .= '?do_secure_login=yes&orig_url=' 
                   . urlencode($_SERVER['HTTP_HOST']);
   }


   if ( ! isset($_SERVER['HTTPS']) ) {
      $show_secure_login = "<center><br><a href=\"$my_ssl_url\"> "
      . _($my_ssl_text) . " </a><br> "
      . (!empty($my_ssl_extra) ? _($my_ssl_extra) : '') . " </center> \n";
      echo $show_secure_login;
   }
}



function log_out_of_https_do() {

   global $go_back_to_http_after_login, $stay_in_https_if_logged_in_using_https,
          $plugin_show_ssl_link_cameInUnencrypted, $show_ssl_link_orig_url;


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/show_ssl_link/config.php');
   else
      include_once ('../plugins/show_ssl_link/config.php');


   if ($go_back_to_http_after_login == 0) return;


   if (!compatibility_sqsession_is_registered('plugin_show_ssl_link_cameInUnencrypted')
       && $stay_in_https_if_logged_in_using_https)
      return;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4, 1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   global $https_logoff_count;
   compatibility_sqextractGlobalVar('https_logoff_count');
   if (!isset($https_logoff_count))
   {
      $https_logoff_count = 0;
      compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');
   }


   // need to fix the sq_base_url session varible, since
   // it is put in the session in redirect.php with
   // the https protocol before we get here 
   //
   global $sq_base_url;
   compatibility_sqextractGlobalVar('sq_base_url');
   $sq_base_url = str_replace('https://', 'http://', $sq_base_url);
   compatibility_sqsession_register($sq_base_url, 'sq_base_url');

  
   if ( ! isset($_SERVER['HTTP']) && $https_logoff_count == 0)
   {

      global $show_ssl_link_orig_url;
      compatibility_sqextractGlobalVar('show_ssl_link_orig_url');
      if (isset($show_ssl_link_orig_url))
         $originalHost = urldecode($show_ssl_link_orig_url);
      else
         $originalHost = $_SERVER['HTTP_HOST'];


      $https_logoff_count++;
      compatibility_sqsession_register($https_logoff_count, 'https_logoff_count');
      $location = 'http://' . $originalHost
         . $_SERVER['PHP_SELF'];

      displayHtmlHeader('',
         "\n<META HTTP-EQUIV=\"REFRESH\" CONTENT=\"0;URL=$location\">\n");

      // note that this causes a pop-up in some browsers
      // that notifies you you are leaving a secure site
      //
      //header("Location: $location");

      exit();

   }

}

?>
