<?PHP

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

function main_menu($color) {
    print "<br><br><center>\n".
        "<form action=\"admin_options.php\" method=post>\n".
        "<table width=\"80%\" bgcolor=\"$color[9]\"><tr><td align=center>\n".
        "<b>Shared Todo List Setup</b></td></tr><tr><td>\n".
        "<table width=\"100%\" bgcolor=\"$color[9]\" cellpadding=3>\n".
        "<tr bgcolor=\"$color[12]\"><td>\n".
        "Here you can create shared access todo lists for select users \n".
        " or public todo lists for all users.\n".
        "</td><td>\n".
        "Here you can give users rights to read and/or\n".
        "write to the available shared access todo lists.\n".
        "</td></tr><tr><td align=center>\n".
        "<input type=submit name=\"submit\" value=\"Todo Lists\">\n".
        "</td><td align=center>\n".
        "<input type=submit name=\"submit\" value=\"Users\">\n".
        "</td></tr></table>".
        "</td></tr></table>\n".
        "</form>\n".
        "</center>\n";
}

function read_todo_list($data_dir, $result_type) {
    $shared_todos = array();
    $pub_todos = array();
    $todo_data_name = 'SharedTodoList';
    if (file_exists("$data_dir$todo_data_name")) {
        $fp = fopen ("$data_dir$todo_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            if (preg_match("/^\{(\d+)\}/", $line, $match)) {
                $todo_name = substr($line, (strpos($line, '}')+2), $match[1]);
                array_push($shared_todos, $todo_name);
            }
            if (preg_match("/^P\{(\d+)\}/", $line, $match)) {
                $todo_name = substr($line, (strpos($line, '}')+2), $match[1]);
                array_push($pub_todos, $todo_name);
            }
        }
        fclose($fp);
    }
    if ($result_type == 'public') {
        return $pub_todos;
    }
    elseif ($result_type == 'shared') {
        return $shared_todos;
    }
}

function save_todo_list($data_dir, $update_list, $save_type) {
    $todo_data_name = 'SharedTodoList';
    if ($save_type == 'shared') {
        $known_type = 'public';
    }
    elseif ($save_type == 'public') {
        $known_type = 'shared';
    }

    $known_list = read_todo_list($data_dir, $known_type);

    if ($known_type == 'public') {
        $public_list = $known_list;
        $shared_list = $update_list;
    }
    elseif ($known_type == 'shared') {
        $public_list = $update_list;
        $shared_list = $known_list;
    }

    $fp = fopen ("$data_dir$todo_data_name", "w");
    if ($fp) {
        $count = count($shared_list);
        for ($x=0;$x<$count;$x++) {
            $line = '';
            $length = strlen($shared_list[$x]);
            $line .= "{".$length."}"." ".$shared_list[$x];
            fwrite($fp, $line."\n", 1024);
        }
        $count = count($public_list);
        for ($x=0;$x<$count;$x++) {
            $line = '';
            $line .= 'P';
            $length = strlen($public_list[$x]);
            $line .= "{".$length."}"." ".$public_list[$x];
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
    else {
        print "Could not save data for shared todo plugin";
    }
}

function get_user_codes ($data_dir) {
    $results = array();
    $user_data_name = 'SharedTodoUserList';
    if (file_exists("$data_dir$user_data_name")) {
        if (filesize("$data_dir$user_data_name") != '0') {
            $fp = fopen("$data_dir$user_data_name", "r");
            $x=0;
            while (!feof ($fp)) {
                $line = fgets($fp,1024);
                    $line = trim($line);
                    if (!empty($line)) {
                        $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
			$narr = split(";",$line_parts[0]);
                        $results[$x]['name'] = $narr[0];
                        $results[$x]['nick'] = $narr[1];
                        $results[$x]['code'] = $line_parts[1];
                        $x++;
                    }
            }
            fclose($fp);
        }
    }
    return $results;
    clearstatcache;
}

function get_user_code ($data_dir, $username) {
    $result = '';
    $user_data_name = 'SharedTodoUserList';
    if (file_exists("$data_dir$user_data_name")) {
        $fp = fopen("$data_dir$user_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
            if (isset($line_parts[0])) {
		$narr = split(";",$line_parts[0]);
                if (preg_match("/^$username$/", $narr[0])) {
                    $line = trim($line);
                    $result = $line_parts[1];
                    break;
                }
            }
        }
        fclose($fp);
    }
    return $result;    
}

function get_user_nick ($data_dir, $username) {
    $result = '';
    $user_data_name = 'SharedTodoUserList';
    if (file_exists("$data_dir$user_data_name")) {
        $fp = fopen("$data_dir$user_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
            if (isset($line_parts[0])) {
		$narr = split(";",$line_parts[0]);
                if (preg_match("/^$username$/", $narr[0])) {
                    $result = $narr[1];
                    break;
                }
            }
        }
        fclose($fp);
    }
    return $result;    
}

function save_user_codes ($data_dir, $userdata) {
   $user_data_name = 'SharedTodoUserList';
   $fp = fopen("$data_dir$user_data_name", "w");
   if ($fp) {
       $count = count($userdata);
       for ($x=0;$x<$count;$x++) {
            $line = $userdata[$x]['name'].";".$userdata[$x]['nick']." = ".$userdata[$x]['code'];
            fwrite($fp, $line."\n", 1024);
       }
       fclose($fp);
   }
   else {
       print "Could not save data for the shared todo list plugin";
   }
   return $userdata;
}

function addto_user_codes ($data_dir) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedTodoUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        $count = count($userdata);
            for ($x=0;$x<$count;$x++) {
            $line = $userdata[$x]['name'].";".$userdata[$x]['nick']." = ".$userdata[$x]['code']."0";
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
    else {
        print "Could not save data for the shared todo list plugin";
    }
}

function delall_user_codes ($data_dir) {
    $user_data_name = 'SharedTodoUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        fclose($fp);
    }
    else {
        print "Could not save data for the shared todo list plugin";
    }
}

function delfrom_user_codes ($data_dir, $index) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedTodoUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        $count = count($userdata);
        for ($x=0;$x<$count;$x++) {
            $new_code = substr_replace($userdata[$x]['code'], '', $index, 1);
            $line = $userdata[$x]['name'].";".$userdata[$x]['nick']." = ".$new_code;
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
}

function remove_user ($data_dir, $name) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedTodoUserList';
    $count = count($userdata);
    for ($x=0;$x<$count;$x++) {
        if (preg_match("/^$name$/", $userdata[$x]['name'])) {
                array_splice($userdata, $x, 1);
                break;
        }
    }    
    save_user_codes ($data_dir, $userdata);
}

function check_me($data_dir, $name, $todo) {
    $ccode = get_user_code($data_dir, $name);
    $public_list = read_todo_list($data_dir, 'public');
    $shared_list = read_todo_list($data_dir, 'shared');

    if ($todo == 'Personal') {
        return 'write';
    }
    foreach ($public_list as $public_todo) {
        if ($todo == $public_todo) {
            return 'write';
        }
    }
    $code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
    $count = count($shared_list);
    for ($x=0;$x<$count;$x++) {
        if ($shared_list[$x] == $todo) {
            switch ($code[$x]) {
                case 0:
                    $access = 'no';
                    break;
                case 1:
                    $access = 'read';
                    break;
                case 2:
                    $access = 'write';
                    break;
                default:
                    break;
             }
            break;
        }
    }
    return $access;
}

function add_user ($data_dir, $name, $nick, $todo_list) {
    $userdata = get_user_codes($data_dir);
    $user_number = count($userdata);
    $count = count($todo_list);
    $val = str_repeat("1", $count);
    $userdata[$user_number]['name'] = $name;
    $userdata[$user_number]['nick'] = $nick;
    $userdata[$user_number]['code'] = $val;
    $userdata = save_user_codes($data_dir, $userdata);
    return $userdata;
}

?>
