<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

require_once('todo_data.php');
require_once('functions.php');
require_once('shared_functions.php');
chdir('..');

define('SM_PATH','../');
include_once('../include/validate.php');
include_once('../functions/strings.php');
include_once('../config/config.php');
include_once('../functions/page_header.php');
include_once('../include/load_prefs.php');

/* get globals */

extract($_POST);

if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
}
if (isset($_GET['todo'])) {
    $todo = $_GET['todo'];
}
if (isset($_GET['idx'])) {
    $idx = $_GET['idx'];
}
if (isset($_GET['fromtoday'])) {
    $fromtoday = $_GET['fromtoday'];
}

/* got 'em */


global $username, $data_dir;
$checkup = check_me($data_dir, $username, $todo);
if ($checkup == 'no'|| $checkup == 'read') {
            print "<center><font color=\"red\"><br><br><big><b>You do not have write access to this todo list</b></big></font></center>\n";
                        exit();
}

// update event info
function show_event_form() {
    global $color, $editor_size, $idx, $tododata, $todo, $username, $data_dir, $checkup, $fromtoday;

    $t = $tododata[$idx];
    $y = substr($t[startdate],0,4);
    $m = substr($t[startdate],4,2);
    $d = substr($t[startdate],6,2);

    $desc = eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $t[description]);

    echo "\n<FORM name=eventupdate action=\"event_edit.php\" METHOD=POST >\n".
         "      <INPUT TYPE=hidden NAME=\"todo\" VALUE=\"$todo\">\n".
         "      <INPUT TYPE=hidden NAME=\"idx\" VALUE=\"$idx\">\n".
         "      <INPUT TYPE=hidden NAME=\"updated\" VALUE=\"yes\">\n".
         "      <INPUT TYPE=hidden NAME=\"fromtoday\" VALUE=\"$fromtoday\">\n";

    echo "\n<TABLE align=center WIDTH=$editor_size BORDER=0 CELLPADDING=2 CELLSPACING=1 BGCOLOR=\"$color[0]\">".
	 "	<TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("List:")."</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>$todo</TD></TR>\n".
         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Start date:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"event_year\">\n";
	select_option_year($y);
	echo "      </SELECT>\n" .
         "      &nbsp;&nbsp;\n" .
         "      <SELECT NAME=\"event_month\">\n";
	select_option_month($m);
	echo "      </SELECT>\n".
         "      &nbsp;&nbsp;\n".
         "      <SELECT NAME=\"event_day\">\n";
	select_option_day($d);
	echo "      </SELECT>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Duration:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <INPUT type=text NAME=\"event_duration\" value=\"$t[duration]\" size=4> hours.\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Who:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"event_nick\">\n";
	select_option_nick($data_dir, $t[nick]);
        echo  "      </SELECT>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Priority:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"event_priority\">\n";
    select_option_priority($t[priority]);
    echo "      </SELECT>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Title:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <INPUT TYPE=text NAME=\"event_title\" VALUE=\"$t[title]\" SIZE=30 MAXLENGTH=50><BR>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT COLSPAN=2>\n".
         "      <TEXTAREA NAME=\"event_description\" ROWS=5 COLS=\"$editor_size\" WRAP=HARD>$desc</TEXTAREA>\n".
         "      </TD></TR>\n";

	if ($checkup == 'write') {
		echo "      <TR><TD ALIGN=LEFT BGCOLOR=\"$color[4]\" COLSPAN=2><INPUT TYPE=SUBMIT NAME=send VALUE=\"" . _("Update Event") . "\">&nbsp;&nbsp<INPUT TYPE=SUBMIT NAME=delete VALUE=\"" . _("Delete Event") . "\"></TD></TR>\n";
	}
    echo "</TABLE></FORM>\n";
}

$todoself=basename($PHP_SELF);

if (!isset($updated))
{
	displayPageHeader($color, 'None');
	todo_header();
	readtododata();
	show_event_form();
} else
{
	if (isset($delete))
	{
		delete_event($idx);
	} else
	{
		readtododata();

    		$event_description=nl2br($event_description);
    		$event_description=ereg_replace ("\n", "", $event_description);
    		$event_description=ereg_replace ("\r", "", $event_description);

		$event_startdate = $event_year . $event_month . $event_day;
		$tododata[$idx] = array( 	'idx' => $idx,
						'startdate' => $event_startdate,
						'title' => $event_title,
						'duration' => $event_duration,
						'description' => $event_description,
						'nick' => $event_nick,
						'priority' => $event_priority);
		writetododata();
	}

	if ($fromtoday == 1)
		header("Location: todo_check.php");
	else
		header("Location: todo.php?todo=".urlencode($todo));
}

?>
</table></td></tr></table>
</body></html>
