<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

require_once('todo_data.php');
require_once('functions.php');
require_once('shared_functions.php');
chdir('..');

define('SM_PATH','../');
include_once('../include/validate.php');
include_once('../functions/strings.php');
include_once('../functions/date.php');
include_once('../config/config.php');
include_once('../functions/page_header.php');
include_once('../include/load_prefs.php');

extract($_POST);

if (isset($_GET['todo'])) {
    $todo = $_GET['todo'];
}
if (isset($_GET['showall'])) {
    $showall = $_GET['showall'];
}
if (isset($_GET['sby'])) {
    $sby = $_GET['sby'];
}
if (isset($_GET['delsel'])) {
    $delsel = $_GET['delsel'];
}

if (!isset($sby))
	$sby = "dp";

$checkup = check_me($data_dir, $_SESSION['username'], $todo);
if ($checkup == 'no') {
    print "<center><font color=\"red\"><br><br><big><b>You do not have access to this todo list</b></big></font></center>\n";
    exit();
}

/* got 'em */

$acc = array();

//display title for todo list.

function starttodo() {
    global $color, $todo, $showall, $sby;

    echo "<form name=listcmd action=\"todo.php?delsel\" method=post>";
    echo "<input type=hidden name=todo value=\"$todo\">";
    echo "<input type=hidden name=showall value=\"$showall\">";
    echo "<input type=hidden name=sby value=\"$sby\">";

	$tname = urldecode($todo);
	print "<table width=\"60%\" bgcolor=\"$color[9]\"align=center>\n";
	print "<tr><td align=center><b>$tname</b></td></tr><tr><td>\n";

    echo "<TABLE BGCOLOR=\"$color[4]\" align=center BORDER=0 CELLSPACING=0 CELLPADDING=2><tr>".
         "<td vallign=top width=\"100px\"><h4>Start date</h4></td>" .
         "<td vallign=top width=\"350px\"><h4>Title</h4></td>" .
         "<td vallign=top align=right width=\"50px\"><h4>Priority</h4></td>" .
         "<td vallign=top align=right width=\"50px\"><h4>Hours</h4></td>" .
         "<td vallign=top align=right width=\"50px\"><h4>Who</h4></td>" .
         "</tr>";
}

//main logic for month view of calendar
function drawoverview() {
	global $color, $tododata, $todo, $showall, $sby, $acc;

	// Sort in ascending date order and then priority.

	if ($sby == "dp")
		usort($tododata,sortbydatepri);
	else
		usort($tododata,sortbyuserdatepri);

	// Display the todo entries.

	$today_dstr = date( 'Y' ) .  date( 'm' ) . date( 'd' );
	foreach ($tododata as $t)
	{
		if (($t[startdate] <= $today_dstr) || $showall)
		{
			$dstr = substr($t[startdate],0,4) . "/" . substr($t[startdate],4,2) . "/" . substr($t[startdate],6,2);

			if ($curcol == $color[0])
				$curcol = $color[4];
			else
				$curcol = $color[0];
			printf( "<tr bgcolor=\"$curcol\">".
				"<td valign=top><input type=\"checkbox\" name=\"cb$t[idx]\"><a href=\"event_edit.php?todo=".urlencode($todo)."&fromtoday=0&idx=$t[idx]\">$dstr</a></td>" .
				"<td valign=top>$t[title]</td>" .
				"<td valign=top align=right>");
			switch ($t[priority])
			{
				case 0: printf("Low"); break;
				case 1: printf("Normal"); break;
				case 2: printf("High"); break;
			}
			printf("<td valign=top align=right>$t[duration]</td>");
			printf("<td valign=top align=right>$t[nick]</td>");
			printf("</td>");

			// Count hours.

			$acc[$t[nick]][nick] = $t[nick];
			$acc[$t[nick]][cnt] += $t[duration];
		}
	}

}

//end of monthly view and form to jump to any month and year
function endtodo() {
	global $color, $acc, $checkup;

	// Show counters for each nick.

	echo "<tr><td></td><td><br></td><td></td></tr>";
	if (count($acc) > 0)
	{
		$gt = 0;
		$mcnt = 0;
		$maxcnt = count($acc);
		foreach ($acc as $a)
		{
			if ($maxcnt > 1)
			{
				$mcnt++;
				if ($mcnt == $maxcnt)
					echo "<tr bgcolor=\"$color[9]\"><td></td><td><u>Total work hours, $a[nick]:</u></td><td></td><td align=right><u>$a[cnt]</u></td><td></td></tr>";
				else
					echo "<tr bgcolor=\"$color[9]\"><td></td><td>Total work hours, $a[nick]:</td><td></td><td align=right>$a[cnt]</td><td></td></tr>";
			}
			$gt += $a[cnt];
		}
		if ($gt > 0)
			echo "<tr bgcolor=\"$color[9]\"><td></td><td><u>Grand total work hours:</u></td><td></td><td align=right><u>$gt</u></td><td></td></tr>";
	}

	// Show command buttons.

	if ($checkup == 'write') {
		$today_dstr = date( 'Y' ) ."/".  date( 'm' ) ."/". date( 'd' );
		echo "<tr><td><br></td></tr>";
		echo "<tr><td></td><td align=left colspan=4><input type=submit value=\"Add new\" name=addnew style=\"width=80; height=22; background-color:$color[9]\">&nbsp;&nbsp;";
		echo "<input type=submit name=delsel value=\"Delete\" style=\"width=80; height=22; background-color:$color[9]\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
		echo "New start date:&nbsp;<input type=text value=\"$today_dstr\" name=newdate size=10 style=\"background-color:$color[4]\">&nbsp;&nbsp;<input type=submit value=\"Change\" name=chgsel style=\"width=80; height=22; background-color:$color[9]\"></td></td></tr>";
		echo "<tr><td></td><td><br></td><td></td></tr>";
	}
	echo "</form>";
	echo "</table>";
	echo "</td></tr></table>";
}

if (isset($addnew))
{
	Header("Location:event_create.php?todo=".urlencode($todo));
	exit();
}

if (isset($chgsel) || isset($delsel))
{
	// Change selected items.


	if (isset($chgsel))
	{
        	$darr = split("/",$newdate);
        	if (checkdate($darr[1],$darr[2],$darr[0]))
                	$newdate = date("Ymd", mktime(0,0,0,$darr[1],$darr[2],($darr[0] > 100) ? $darr[0] : $darr[0]+1900));
		else
			$addon = "?dateerr";
	}

	if (!isset($addon))
	{
		readtododata();
		foreach ($tododata as $t)
		{
			if (isset(${"cb$t[idx]"}))
				if (isset($chgsel))
					$tododata[$t[idx]][startdate] = $newdate;
				else
					$tododata[$t[idx]][idx] = -1;
		}
		writetododata();
	}
	header("Location:todo.php?todo=".urlencode($todo)."&showall=$showall&sby=$sby".$addon);
	exit();
}

$todoself=basename($PHP_SELF);

displayPageHeader($color, 'None');
todo_header();
readtododata();
starttodo();
drawoverview();
endtodo();

?>
</body></html>
