<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

require_once('todo_data.php');
require_once('functions.php');
require_once('shared_functions.php');
chdir('..');
require_once('../src/validate.php');
require_once('../functions/strings.php');
require_once('../functions/date.php');
require_once('../config/config.php');
require_once('../functions/page_header.php');
require_once('../src/load_prefs.php');

/* get globals */

extract($_POST);

if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
}
if (isset($_GET['todo'])) {
    $todo = $_GET['todo'];
}
if (isset($_GET['fromtoday'])) {
    $fromtoday = $_GET['fromtoday'];
}

/* got 'em */

if ($todo != "")
{
	$checkup = check_me($data_dir, $username, $todo);
	if ($checkup == 'no' || $checkup == 'read') {
            print "<center><font color=\"red\"><br><br><big><b>You do not have write access to this todo list !</b></big></font></center>\n";
            exit();
	}
}


//main form to gather event info
function show_event_form() {
    global $color, $editor_size, $year, $day, $month, $todo, $username, $data_dir, $fromtoday;

    $mynick = get_user_nick($data_dir, $username);

    echo "\n<FORM name=eventscreate action=\"event_create.php\" METHOD=POST >\n".
         "      <INPUT TYPE=hidden NAME=\"todo\" VALUE=\"$todo\">".
         "      <INPUT TYPE=hidden NAME=\"fromtoday\" VALUE=\"$fromtoday\">\n";

    echo "\n<TABLE align=center WIDTH=$editor_size BORDER=0 CELLPADDING=2 CELLSPACING=1 BGCOLOR=\"$color[0]\">".
         "      <INPUT TYPE=hidden NAME=\"todo\" VALUE=\"$todo\">\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("List:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"todo\">\n";
	select_option_list($data_dir,$username,$todo);
	echo "      </SELECT>\n" .
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Start date:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"event_year\">\n";
	select_option_year($year);
	echo "      </SELECT>\n" .
         "      &nbsp;&nbsp;\n" .
         "      <SELECT NAME=\"event_month\">\n";
	select_option_month($month);
	echo "      </SELECT>\n".
         "      &nbsp;&nbsp;\n".
         "      <SELECT NAME=\"event_day\">\n";
	select_option_day($day);
	echo "      </SELECT>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Duration:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <INPUT type=text NAME=\"event_duration\" size=4> hours.\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Who:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"event_nick\">\n";
	select_option_nick($data_dir, $mynick);
        echo  "      </SELECT>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Priority:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <SELECT NAME=\"event_priority\">\n";
    select_option_priority("0");
    echo "      </SELECT>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>" . _("Title:") . "</TD>\n".
         "      <TD BGCOLOR=\"$color[4]\" ALIGN=LEFT>\n".
         "      <INPUT TYPE=text NAME=\"event_title\" VALUE=\"\" SIZE=30 MAXLENGTH=50><BR>\n".
         "      </TD></TR>\n".

         "      <TR><TD BGCOLOR=\"$color[4]\" ALIGN=LEFT COLSPAN=2>\n".
         "      <TEXTAREA NAME=\"event_description\" ROWS=5 COLS=\"$editor_size\" WRAP=HARD></TEXTAREA>\n".
         "      </TD></TR>\n".

         "      <TR><TD ALIGN=LEFT BGCOLOR=\"$color[4]\" COLSPAN=2><INPUT TYPE=SUBMIT NAME=send VALUE=\"" .
         _("Set Event") . "\"></TD></TR>\n";
    echo "</TABLE></FORM>\n";
}


if ( !isset($month) || $month <= 0){
    $month = date( 'm' );
}
if ( !isset($year) || $year <= 0){
    $year = date( 'Y' );
}
if (!isset($day) || $day <= 0){
    $day = date( 'd' );
}

$todoself=basename($PHP_SELF);


//if form has not been filled in
if(strlen($event_title)<2 || !isset($event_year) || !isset($event_month) || !isset($event_day)){

    displayPageHeader($color, 'None');
    todo_header();
    show_event_form();
} else {
    $l = readtododata()+1;
    //make sure that event text is fittting in one line
    $event_description=nl2br($event_description);
    $event_description=ereg_replace ("\n", "", $event_description);
    $event_description=ereg_replace ("\r", "", $event_description);

    $event_startdate = $event_year . $event_month . $event_day;


    $tododata[$l] = array( 	'idx' => $l,
           			'startdate' => $event_startdate,
           			'title' => $event_title,
           			'duration' => $event_duration,
           			'description' => $event_description,
           			'priority' => $event_priority,
           			'nick' => $event_nick);
    //save
    writetododata();
    if ($fromtoday == 1)
    	header("Location: todo_check.php");
    else
    	header("Location: todo.php?todo=".urlencode($todo));
}

?>
</table></td></tr></table>
</body></html>
