<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

require_once('shared_functions.php');
chdir ('..');
require_once('../src/validate.php');
require_once('../functions/page_header.php');

extract($_POST);

displayPageHeader($color, 'None');
main_menu($color);
$indent = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
if (isset($submit)) {
     if ($submit == 'Todo Lists') {
        if (isset($add_action) && $add_action == 'Add') {
            if (!empty($new_todo) && !preg_match("/^(\s){1,}$/", $new_todo)) {
                if (isset($public) && $public == 'yes') {
                    $type = 'public';
                    $todo_list = read_todo_list($data_dir, 'public');
                    array_push($todo_list, $new_todo);
                    save_todo_list($data_dir, $todo_list, $type);
                }
                else {
                    $type = 'shared';
                    $todo_list = read_todo_list($data_dir, 'shared');
                    array_push($todo_list, $new_todo);
                    save_todo_list($data_dir, $todo_list, $type);
                    addto_user_codes($data_dir);
                }
            }
        }
        elseif (isset($del_action) && $del_action == 'Delete' &&
               (isset($selected_shared_todo) || isset($selected_public_todo))) {
            if (isset($selected_shared_todo)) {
                $type = 'shared';
                $selected_todo = $selected_shared_todo;
            }
            elseif (isset($selected_public_todo)) {
                $type = 'public';
                $selected_todo = $selected_public_todo;
            }
            $todo_list = read_todo_list($data_dir, $type);
            array_splice($todo_list, $selected_todo, 1); 
            save_todo_list($data_dir, $todo_list, $type);
            if (isset($selected_shared_todo)) {
                if (empty($todo_list)) {
                    delall_user_codes($data_dir);
                }
                else {
                    delfrom_user_codes($data_dir, $selected_todo);
                }
            }
        }
         $shared_list = read_todo_list($data_dir, 'shared');
         print "<br><table align=center width=\"80%\"><tr><td align=left><b>Shared</b>\n".
               " todo lists can be assigned to users with read only\n".
               " or read/write access. To enable users to access defined\n".
               " todo lists use the \"Users\" button.</td></tr><tr><td align=left>";
        print "<br><b>Public</b> todo lists are available to all SquirrelMail users\n".
              " in addition to their private personal todo list.</td></tr></table><br>\n".
              "<table align=center width=\"80%\" bgcolor=\"$color[9]\">\n".
              "<tr bgcolor=\"$color[4]\"><td align=center>\n";
         if (!empty($shared_list)) {
            print "<form action=\"admin_options.php\" method=post>\n".
                  "<br><table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                  "<tr bgcolor=\"$color[10]\"><td align=center></td><td align=center>\n".
                  "<b>Shared todo lists</b>\n".
                  "</td></tr>\n";
            $r=0;
            foreach ($shared_list as $todo) {
                print "<tr><td align=center>\n".
                      "<input type=radio name=\"selected_shared_todo\" value=\"$r\">\n".
                      "</td><td align=center>$todo</td></tr>\n";
                $r++;
            }
         }
         else {
             print "<form action=\"admin_options.php\" method=post>\n".
                   "<table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                   "<tr bgcolor=\"$color[10]\"><td align=center>\n".
                   "<b>Shared todo lists</b>\n".
                   "</td></tr><tr><td align=center>\n".
                   "<b>No Shared Todo Lists Defined</b></td></tr>\n";
         }
        print "</table><br>\n";
        $public_list = read_todo_list($data_dir, 'public');
        if (!empty($public_list)) {
            print "<table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                  "<tr bgcolor=\"$color[10]\"><td align=center></td><td align=center>\n".
                  "<b>Public Todo Lists</b>\n".
                  "</td></tr>\n";
            $p=0;
            foreach ($public_list as $todo) {
                print "<tr><td align=center>\n".
                      "<input type=radio name=\"selected_public_todo\" value=\"$p\">\n".
                      "</td><td align=center>$todo</td></tr>\n";
                $p++;
            }
        }
        else {
            print "<table align=center width=\"100%\" bgcolor=\"$color[12]\">\n".
                  "<tr bgcolor=\"$color[10]\"><td align=center>\n".
                  "<b>Public todo lists</b>\n".
                  "</td></tr><tr><td align=center>\n".
                  "<b>No Public Todo Lists Defined</b></td></tr>\n";
        }
        print "</table><br>\n".
               "</td></tr></table>\n";

         print "<br><table width=\"80%\" align=center><tr><td>\n".
               "<b>Delete selected todo list</b></td></tr><tr><td align=center>\n".
               "<input type=submit name=del_action value=\"Delete\">\n".
               "</tr></td><tr><td><b>Add a new todo list</b></td></tr><tr><td align=center>\n".
               "Name:&nbsp;<input type=text name=new_todo size=\"50\">\n".
               "</td></tr><tr><td align=center>\n".
               "<input type=hidden name=submit value=\"Todo Lists\">\n".
               "<input type=checkbox name=public value=\"yes\">\n".
               "&nbsp;&nbsp;make <b>PUBLIC</b> (read/write for all users)\n".
               "</tr></td><tr><td align=center><input type=submit name=add_action value=\"Add\">\n".
               "</td></tr></table><br><br></form>\n";
              
     }

     elseif ($submit == 'Users') {
         $todo_list = read_todo_list($data_dir, 'shared');
         print "<form action=\"admin_options.php\" method=post>\n";
         print "<table align=center width=\"80%\"><tr><td>\n";
         print "Here you can manage user access to shared todo lists.\n";
         print " First create the shared todo lists with the \"Todo Lists\" button.\n";
         print " Then you can add users to the access table below. Select that user\n";
         print " to modify his/her access to each individual shared todo lists\n";
         print " or to remove them from the shared todo list access table.\n";
         print "</td></tr></table>\n";
             
         if (isset($commit_modify) && $commit_modify == 'Submit') {
         //   $todo_list = read_todo_list($data_dir);
            $count = count($todo_list);
            $val = '';
            for ($j=0;$j<$count;$j++) {
                $var = "todo".$j;
                $val .= $$var; 
            }
            $userdata = get_user_codes($data_dir);
            $usercount = count($userdata);
            for ($j=0;$j<$usercount;$j++) {
                if (preg_match("/^$Name$/", $userdata[$j]['name'])) {
                   $userdata[$j]['nick'] = $user_nick;
                   $userdata[$j]['code'] = $val;
                }
            }
            save_user_codes($data_dir, $userdata);
         }
             
         elseif (isset($add_user) && $add_user == 'Add') {
             if (!empty($user_input) && !preg_match("/^(\s){1,}$/", $user_input)) {
         //       $todo_list = read_todo_list($data_dir);
                if (empty($todo_list)) {
                    print "<br><center><b><font color=red> You must define a shared todo list before ".
                          "you can assign user access.<br>Click on the Todo Lists button ".
                          "to manage shared todo lists</font></b></center><br>\n";
                }
                else {
                    $userdata = add_user($data_dir, $user_input, $user_nick, $todo_list);
                }
             }
         }
         elseif (isset($mod_user) && $mod_user == 'Modify' && isset($user_select)) {
             print "<form action\"admin_options.php\" method=post>\n".
                   "<center><table bgcolor=\"$color[10]\" width=50%>\n".
                   "<tr><td align=center><b>$user_select</b>\n".
                   "</tr></td></table></center>\n";
             $ccode = get_user_code($data_dir, $user_select);
             $unick = get_user_nick($data_dir, $user_select);
             $code_array = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
             print "<table width=50% bgcolor=\"$color[9]\" align=center>";
             $l=0;
             foreach ($todo_list as $todo) {
                print "<tr><td align=center>$todo</td><td align=center> <select name=\"todo" . $l ."\">\n";
                print "<option value=\"0\"";
                if ($code_array[$l] == 0) {
                    print "SELECTED>none\n";
                }
                else {
                    print ">none\n";
                }
                print "<option value=\"1\"";
                if ($code_array[$l] == 1) {
                    print "SELECTED>read\n";
                }
                else {
                    print ">read\n";
                }
                print "<option value=\"2\"";
                if ($code_array[$l] == 2) {
                    print "SELECTED>write\n";
                }
                else {
                    print ">write\n";
                }
                $l++;
             }
             print "</select></td></tr>\n".
                   "</table><br>\n".
                   "<center>New nick:<input type=text name=\"user_nick\" value=\"$unick\"><br>Note: changes will not be made in existing tasks!</center>".
                   "<center><input type=submit name=commit_modify value=\"Submit\">\n".
                   "</center><input type=hidden name=submit value=\"Users\">\n".
                   "</center><input type=hidden name=\"Name\" value=\"$user_select\">\n".
                   "</form>\n";
             exit();
         }
         elseif (isset($mod_user) && $mod_user == 'Delete' && isset($user_select)) {
             remove_user($data_dir, $user_select);
         }
         if (!isset($userdata)) {
            $userdata = get_user_codes($data_dir);
         }
         print "<br><table align=center><tr><td align=center>\n".
               "<b>Add user to shared todo list setup</b>\n".
               "</td></tr><tr><td align=center>\n".
               "Name:&nbsp;&nbsp;<input type=text name=user_input size=40>\n".
               "</td></tr><tr><td align=center>\n".
               "Nick..:&nbsp;&nbsp;<input type=text name=user_nick size=10>\n".
               "</td></tr><tr><td align=center>\n".
               "<input type=submit name=add_user value=\"Add\"\n".
               "</td></tr></table>\n".
               "<br><center><table  bgcolor=\"$color[9]\"><tr><td>\n".
               "<center><b>Shared Todo List Access Table</b></td></tr><tr><td>\n".
               "<table  bgcolor=\"$color[4]\">\n".
               "<tr bgcolor=\"$color[5]\"><td></td><td width=\"100\" nowrap><b>User</b></td><td><b>Nick</b></td>\n";
         foreach ($todo_list as $todo) {
             print "<td width=\"150\" align=center nowrap><b>$todo</b></td>";
         }
         print "</tr>\n";
         $count = count($userdata);
         if ($count == 0) {
             print "</table><br><center>No users defined for shared todo list </center><br><table>\n";
         }
         else {
         for ($x=0;$x<$count;$x++) {
            $name = $userdata[$x]['name'];
            $nick = $userdata[$x]['nick'];
            print "<tr bgcolor=\"$color[12]\"><td align=center><input type=radio name=user_select ".
                  "value=\"$name\"></td><td>\n".
                  "$name\n</td><td>$nick</td>";
            $code = preg_split('//', trim($userdata[$x]['code']), -1, PREG_SPLIT_NO_EMPTY);
            for ($n=0;$n<count($code);$n++) {
                switch ($code[$n]) {
                    case 0:
                        $setting = 'No';
                        break;
                    case 1:
                        $setting = 'Read';
                        break;
                    case 2:
                        $setting = 'Write';
                        break;
                    default;
                        $setting = '';
                        break;
                }
                if (!empty($setting)) {
                    print "<td align=center>$setting</td>\n";
                }
            }
         }
         }
         print "</tr></table></td></tr></table></center>\n".       
               "<input type=hidden name=submit value=\"Users\">\n".
               "<br><table align=center><tr><td>\n".
               "<input type=submit name=mod_user value=\"Modify\">$indent\n".
               "</td><td><b>Modify the currently selected user's todo list access</b>\n".
               "</td></tr><tr><td><input type=submit name=mod_user value=\"Delete\">$indent\n".
               "</td><td><b>Remove the currently selected user from shared todo list access</b>\n".
               "</td></tr></table><br></form>";
    }        
}
print "</body></html>\n";

?>
