<?php

//
//  Todo List Module Plugin
//
//  Copyright (c) 2003 Bjarne Maschoreck <bjarne.maschoreck@satconsulting.dk>
//  Licensed under the GNU GPL. For full terms see the file COPYING.
//

function todo_header() {
    //Add Second layer of todo links to upper menu
    global $color,$todo, $showall, $sby;

    displayInternalLink("plugins/todo/todo_check.php",_("Today"),"right");
    echo "&nbsp;&nbsp\n";
    displayInternalLink("plugins/todo/todo.php?todo=".urlencode($todo)."&showall=1&sby=$sby",_("Show all"),"right");
    echo "&nbsp;&nbsp\n";
    displayInternalLink("plugins/todo/todo.php?todo=".urlencode($todo)."&showall=0&sby=$sby",_("Show active"),"right");
    echo "&nbsp;&nbsp\n";
    displayInternalLink("plugins/todo/todo.php?todo=".urlencode($todo)."&showall=$showall&sby=dp",_("Sort date/pri"),"right");
    echo "&nbsp;&nbsp\n";
    displayInternalLink("plugins/todo/todo.php?todo=".urlencode($todo)."&showall=$showall&sby=udp",_("Sort who/date/pri"),"right");
    echo "&nbsp;&nbsp\n";

}


function select_option_priority($selected) {
    $eventpriority = array(
        "0" => _("Low"),
        "1" => _("Normal"),
        "2" => _("High"),
    );

    while( $bar = each($eventpriority)) {
        if($selected==$bar[key]){
                echo "        <OPTION VALUE=\"".$bar[key]."\" SELECTED>".$bar[value]."</OPTION>\n";
        } else {
                echo "        <OPTION VALUE=\"".$bar[key]."\">".$bar[value]."</OPTION>\n";
        }
    }
}

function select_option_year($selected) {

    for ($i=1902;$i<2038;$i++){
        if ($i==$selected){
            echo "            <OPTION VALUE=\"$i\" SELECTED>$i</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$i\">$i</OPTION>\n";
        }
    }
}

function select_option_month($selected) {

    for ($i=1;$i<13;$i++){
        $im=date('m',mktime(0,0,0,$i,1,1));
        $is = substr( _( date('F',mktime(0,0,0,$i,1,1)) ), 0, 3 );
        if ($im==$selected){
            echo "            <OPTION VALUE=\"$im\" SELECTED>$is</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$im\">$is</OPTION>\n";
        }
    }
}

function select_option_day($selected) {

    for ($i=1;$i<32;$i++){
        ($i<10)? $ih="0".$i : $ih=$i;
        if ($i==$selected){
            echo "            <OPTION VALUE=\"$ih\" SELECTED>$i</OPTION>\n";
        } else {
            echo "            <OPTION VALUE=\"$ih\">$i</OPTION>\n";
        }
    }
}

function select_option_nick($data_dir, $selected) {

	$narr = get_user_codes($data_dir);

	if (count($narr) == 0)
	{
		echo "<OPTION VALUE=\"(none)\" SELECTED>(none)</OPTION>\n";
		return;
	}

	$used = array();
	foreach ($narr as $n)
	{
		if ($used[$n[nick]] != 1)
		{
			if ($n[nick] == $selected)
				echo "<OPTION VALUE=\"$n[nick]\" SELECTED>$n[nick]</OPTION>\n";
			else
				echo "<OPTION VALUE=\"$n[nick]\">$n[nick]</OPTION>\n";
			$used[$n[nick]] = 1;
		} 
	}
}

function select_option_list($data_dir,$username,$selected)
{
	$shared_list = read_todo_list($data_dir, 'shared');
	$public_list = read_todo_list($data_dir, 'public');

	foreach ($shared_list as $sl)
	{
		if (check_me($data_dir,$username,$sl) == "write")
		{
			if ($sl == $selected)
				echo "<OPTION VALUE=\"$sl\" SELECTED>$sl</OPTION>\n";
			else
				echo "<OPTION VALUE=\"$sl\">$sl</OPTION>\n";
		}
	}
	foreach ($public_list as $pl)
	{
		if (check_me($data_dir,$username,$pl) == "write")
		{
			if ($pl == $selected)
				echo "<OPTION VALUE=\"$pl\" SELECTED>$pl</OPTION>\n";
			else
				echo "<OPTION VALUE=\"$pl\">$pl</OPTION>\n";
		}
	}
	if ($selected == "Personal")
		echo "<OPTION VALUE=\"Personal\" SELECTED>Personal</OPTION>\n";
	else
		echo "<OPTION VALUE=\"Personal\">Personal</OPTION>\n";

}

function sortbydatepri($a,$b)
{
	if ($a[startdate] == $b[startdate])
	{
		if ($a[priority] > $b[priority])
			return(-1);
		else
			if ($a[priority] < $b[priority])
				return(1);
			else
				return(0);
	} else
		return( ($a[startdate] < $b[startdate]) ? -1 : 1);
}

function sortbyuserdatepri($a,$b)
{
	if (strcmp($a[nick],$b[nick]) == 0)
	{
		if ($a[startdate] == $b[startdate])
		{
			if ($a[priority] == $b[priority])
				return(0);
			else
				return( ($a[priority] > $b[priority]) ? -1 : 1);
		} else
			return( ($a[startdate] < $b[startdate]) ? -1 : 1);
	} else
		return(strcmp($a[nick],$b[nick]));
}

?>
