<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Presents the user with a list of calendars to which 
  * they have read/write access to
  *
  * @param array $color Standard SquirrelMail colors array
  * @param array $calList A list of all the calendars that
  *                       the current user has read/write
  *                       access to (array of Calendar objects)
  * @param array $error_messages An array of any errors found with
  *                              previously submitted preferences data
  * @param array $messages An array of any non-error messages to be
  *                        displayed to the user
  *
  */
function display_calendar_list($color, $calList, $error_messages, $messages)
{

   global $username;

   if (!isset($color[12])) $color[12] = '';


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   if (!empty($error_messages))
   {
      echo '<center><strong style="color:' . $color[2] . '">' . _("Error:");
      foreach ($error_messages as $msg)
         echo $msg . '<br />';
      echo '</strong>';
   }


   if (!empty($messages))
   {
      if (!empty($error_messages)) echo '<br />';
      echo '<center><strong style="color:' . $color[2] . '">';
      foreach ($messages as $msg)
         echo $msg . '<br />';
      echo '</strong>';
   }


   echo "<table width=\"100%\" height=\"85%\" align=\"center\"><tr><td>\n"
      . "<table width=\"80%\" bgcolor=\"$color[9]\" align=\"center\">\n"
      . "<tr><td align=\"center\"><b>" . _("Available Calendars") . "</b> "
      . "<a href='list_calendars.php?startAddPersonalCalendar=YES'>"
      . "<img src=\"images/new.png\" border=\"0\"></a></td></tr><tr><td align='center'>\n"
      . "<table width=\"100%\" align=\"center\" bgcolor=\"$color[4]\">\n";

   foreach ($calList as $calendar)
   {

//TODO:
//LEFT OFF HERE -- nowrap is not HTML4.0 -- fix using CSS (many places in this plugin...)
      echo "<tr><td align=\"left\" nowrap><a href=\"month.php?calID=" . $calendar->getID() 
         . "\">" . $calendar->getName() . "</a>";

      if ($calendar->isExternal() || $calendar->getCalendarType() == SM_CAL_TYPE_PERSONAL)
         echo "<small>&nbsp;&nbsp;(<a href='list_calendars.php?removeCalID="
            . $calendar->getID() . "'>" . _("remove") . "</a>)</small>";

      echo "</td><td align='right'><small>("
         . ($calendar->isOwner($username) || $calendar->canWrite($username) || $calendar->isExternal()
         ? "<a href='list_calendars.php?startEditCalID=" . $calendar->getID() 
         . "'>" . _("edit") . "</a> | \n"
         : '') 
/* Apparently this does not fix Outlook problems
         . (cal_use_javascript() 
         ? '<a href="#" onclick="if (document.useMSform.MSicalLineDelim.checked) useMS=1; else useMS=0; window.location.href=\'list_calendars.php?exportCalID=' . $calendar->getID() . '&MSicalLineDelim=\' + useMS;">' 
         : '<a href="list_calendars.php?exportCalID=' . $calendar->getID() . '">')
*/
         . '<a href="list_calendars.php?exportCalID=' . $calendar->getID() . '">'
         . _("export") . '</a>)'
         . "</small></td></tr>\n";

   }

   echo "<tr><td nowrap align=\"left\"><a href=\"month.php?calID=personal\">"
      . _("Personal") . "</a></td><td align='right'><small>(" 
//      . "<a href='list_calendars.php?startEditCalID=personal'>" . _("edit") . "</a> | \n"
/* Apparently this does not fix Outlook problems
      . (cal_use_javascript()
      ? '<a href="#" onclick="if (document.useMSform.MSicalLineDelim.checked) useMS=1; else useMS=0; window.location.href=\'list_calendars.php?exportCalID=personal&MSicalLineDelim=\' + useMS;">'
      : '<a href="list_calendars.php?exportCalID=personal">')
*/
      . '<a href="list_calendars.php?exportCalID=personal">'
      . _("export") . '</a>)'
      . "</small></td></tr>"
      . "</table><a href='list_calendars.php?startAddPersonalCalendar=YES'>" 
      . _("Add Personal Calendar") . "</a></td></tr></table>\n";

/* Apparently this does not fix Outlook problems
   if (cal_use_javascript())
      echo '</td></tr><tr><td align="center"><form name="useMSform">'
         . '<input type="checkbox" name="MSicalLineDelim" id="MSicalLineDelimId" value="1">'
         . '<label for="MSicalLineDelimId"><small>' 
         . _("Export In Microsoft-compatible Format") . '</small></label></form>';
*/


/* first attempt w/out name field for external cals
   echo "</td></tr><tr><td height='100%' valign='bottom'>\n"
      . "<table align='center' border='0' bgcolor='$color[9]'><tr><td align='right'>" 
      . _("Add External Calendar:") . "</td>\n"
      . '<td align="left"><form style="margin:0" method="POST" action="list_calendars.php">'
      . '<input name="externalCalURI" type="text">'
      . "&nbsp;<input type='submit' value='" . _("Go") . "'></form></td></tr>\n"
      . '<tr><td align="right">' . _("Import Calendar:") . "</td>\n"
      . '<td align="left"><form style="margin:0" method="POST" action="list_calendars.php" enctype="multipart/form-data">'
      . '<input name="uploadCalFile" type="file">'
      . "&nbsp;<input type='submit' value='" . _("Go") . "'></form></td></tr>\n"
      . "</table>\n"
      . "</td></td></table>\n";
*/


   echo "</td></tr><tr><td height='100%' valign='bottom'>\n"
      . '<form style="margin:0" method="POST" action="list_calendars.php">'
      . "<table align='center' border='0' bgcolor='$color[9]'><tr><td colspan='2' align='center'>\n"
      . _("Add External Calendar") . "</td></tr><tr><td align='right'>" 
      . _("Address:") . "</td>\n"
      . '<td align="left"><input name="externalCalURI" type="text"></td></tr><tr><td align="right">'
      . _("Override Name:") . "</td>\n"
      . '<td align="left"><input name="externalCalName" type="text">'
      . "&nbsp;<input type='submit' value='" . _("Go") . "'></td></tr>\n"
      . "</table></form><br />\n"
      . "<form method='POST' action='list_calendars.php' enctype='multipart/form-data' style='margin:0'>\n"
      . "<input type='hidden' name='uploadCal' value='yes'>\n"
// hidden input is necessary to prevent buggy IE behavior where it ignores all form input!  yikes!
      . "<table align='center' border='0' bgcolor='$color[9]'>\n"
      . '<tr><td align="right">' . _("Import Calendar") . ":</td>\n"
      . '<td align="left">'
      . '<input name="uploadCalFile" type="file">'
      . "&nbsp;<input type='submit' value='" . _("Go") . "'></td></tr>\n"
      . "<tr><td align='right'>\n"
      . "<input type='checkbox' id='synchCal' name='synchCal' value='YES' CHECKED>"
      . '<label for="synchCal">' . _("Synch/Merge With") 
      . "</label>:</td><td align='left'><select name=\"calID\">\n"
      . "<option value=\"auto\" SELECTED>" . _("Auto-detect") . "</option>\n"
      . "<option value=\"personal\">" . _("Personal") . "</option>\n";


   foreach ($calList as $cal)
   {
      if ($cal->isOwner($username) || $cal->canWrite($username))
      {
         $calID = urlencode($cal->getID());
         echo "<option value=\"$calID\""
            . ">" . $cal->getName() . "</option>\n";
      }
   }


   echo "          </select>\n"
      . "</td></tr>\n"
      . "</table></form>\n"
      . "</td></td></table>\n";


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


}


?>
