<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


define('SM_PATH','../../');



if (file_exists(SM_PATH . 'include/validate.php')) 
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');
include_once(SM_PATH . 'functions/date.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/interface/helper_month.php');



global $username, $week_start_day;



// get calendar...
//
sqgetGlobalVar('calID', $calID, SQ_FORM);
$calID = urldecode($calID);
$calendar = get_calendar($calID);



// check that user has access rights
//
if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
   exit;



sqgetGlobalVar('year', $year, SQ_FORM);
sqgetGlobalVar('month', $month, SQ_FORM);
$now = time();
$dateArray = getdate($now);
$todaysYear = $dateArray['year'];
$todaysMonth = $dateArray['mon'];



// make sure we have viewing month
//
if (empty($year) || empty($month))
{
   $year = $todaysYear;
   $month = $todaysMonth;
}



// show the calendar
//
showHelperMonth($year, $month, $week_start_day, $calendar);



?>
