<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



// load prefs (can't use loading_prefs hook due to a chicken-and-egg
// problems with i18n'd strings in constants file (that is needed by
// config file)
//
// could just do this, but why load a bunch of extra needless code?
// include_once(SM_PATH . 'plugins/calendar/functions.php');
//
include_once(SM_PATH . 'plugins/calendar/constants.php');
include_once(SM_PATH . 'plugins/calendar/data/config.php');
include_once(SM_PATH . 'plugins/calendar/load_prefs.php');
cal_load_prefs_do();



/**
  * Inserts small calendar CSS style attributes
  *
  */
function small_calendar_style_do()
{

   global $PHP_SELF, $show_small_calendar, $small_calendar_size,
          $small_calendar_header_color, $small_calendar_today_color,
          $small_calendar_event_italic_style, $small_calendar_event_color,
          $small_calendar_day_color, $allow_small_calendar;


   if (!$allow_small_calendar || !$show_small_calendar)
      return;


   if (strpos($PHP_SELF, 'left_main.php') !== FALSE)
   {
      echo '<style type="text/css">';
      echo "\n<!-- .calendarHeader { font-size: $small_calendar_size; font-weight: bolder; color: $small_calendar_header_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendarToday { font-size: $small_calendar_size; font-weight: bolder; color: $small_calendar_today_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendarEventToday { font-size: $small_calendar_size; font-style: $small_calendar_event_italic_style; font-weight: bolder; color: $small_calendar_event_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendarEvent { font-size: $small_calendar_size; font-style: $small_calendar_event_italic_style; color: $small_calendar_event_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendar { font-size: $small_calendar_size; color: $small_calendar_day_color ; } -->\n</style>\n";
   }

}



/**
  * Renders miniature calendar
  *
  */
function render_small_calendar_do()
{

   global $username, $domain, $show_small_calendar,
          $small_calendar_calID, $week_start_day, $allow_small_calendar;
   include_once(SM_PATH . 'plugins/calendar/functions.php');

   if (!$allow_small_calendar || !$show_small_calendar)
      return;


   sqgetGlobalVar('year', $year, SQ_FORM);
   sqgetGlobalVar('month', $month, SQ_FORM);
   list($todaysYear, $todaysMonth, $todaysDay) = explode('-', date('Y-n-j'));



   // make sure we have default day
   // to use for clicking into day view
   //
   if (empty($year) || empty($month) || ($year == $todaysYear && $month == $todaysMonth))
      $day = $todaysDay;
   else
      $day = 1;



   // make sure we have viewing month
   //
   if (empty($year) || empty($month))
   {
      $year = $todaysYear;
      $month = $todaysMonth;
   }


   // get calendar...
   //
   $calendar = get_calendar($small_calendar_calID);
   
   
   // check that user has access rights
   //
   if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
      return;

   
   
   // show the calendar
   //
   $calendar->showMonth($year, $month, $week_start_day, $username, SM_CAL_VIEW_MODE_MONTH_MINIATURE);


   
}



?>
