#!/bin/sh

# Fixes the (incompatible with JavaScript) use of dashes
# in calendar IDs
#
# Usage: fix_calIDs [calendar data directory]
#
# If no calendar data directory is given, it assumes 
# the current working directory 
#

while test -z "$REPLY"; do

clear
echo "WARNING!"
echo "--------"
echo "Please back up your calendar data directory before using this script!"
echo ""
echo "Usage: run this script from your calendar data directory"
echo "       or give the path to the calendar data directory on"
echo "       the command line"
echo "       BEWARE that this script will assume you are in the"
echo "       calendar data directory and will start modifying files" 
echo "       in the current directory if you do not provide any"
echo "       arguments to this script!"
echo ""
echo -n "Continue? (y/[n]): "
read REPLY
if test -z $REPLY; then
   REPLY="n"
fi
if test $REPLY = "n"; then
   echo ""
   echo ""
   exit 0
fi
if test $REPLY = "y"; then
   echo ""
   echo ""
   break
fi
REPLY=""
done


echo "Fixing calendar IDs"
echo


DIRNAME=$1
shift
if test -z "$DIRNAME" -o ! -d "$DIRNAME"; then
   
   DIRNAME=`pwd`

fi



#==================================================================================

function fixcalids
{


local MYDIR=$1
shift

pushd $MYDIR > /dev/null


#for FILENAME in *     # Traverse all files in directory.
for FILENAME in `ls`     # Traverse all files in directory.

do

#echo -n "FILE IS "
#echo $FILENAME
#continue


   # recurse
   #
   if test -d "$FILENAME"; then

      local DIRNAME="$FILENAME"

      fixcalids "$FILENAME"

      # now fix dir name
      if test `echo "$DIRNAME" | grep -ce "-"` -gt 0; then

         echo -n "Fixing directory name $DIRNAME..."
         CORRECTED_DIRNAME=`echo "$DIRNAME" | sed s/-/__/g`
         rm -rf "$CORRECTED_DIRNAME"
         mv -f "$DIRNAME" "$CORRECTED_DIRNAME"
         echo "done"

      fi

      continue

   fi


#  - replace dashes in any lines that start with:
#
# X-WR-RELCALID:sm_cal
# X-SQ-CALID:sm_cal
# X-SQ-EVTPARENTCALENDARS:sm_cal
#
# X-WR-RELCALID:sm_uploaded_cal
# X-SQ-EVTPARENTCALENDARS:sm_uploaded_cal
#
#  - replace dashes with underscores in actual file names and dir names
#    (rm -rf old one first)
#
# two possible problems here: line wrapped, so dash is on following line
#                             inserting extra _ char pushes line length 
#                             over what it should be (75 I think)
SEARCH=`grep -iE "^X-WR-RELCALID:sm_.*-" "$FILENAME"`

# fix if needed
#
if test ! -z "$SEARCH"; then

   echo -n "  Fixing X-WR-RELCALID for file $FILENAME..."

   sed 's/^\(X-WR-RELCALID:sm_.*\)-/\1__/' "$FILENAME" > /tmp/temp_sed_stuff_delete_me.$$

   # twice cuz sometimes we have two dashes
   sed 's/^\(X-WR-RELCALID:sm_.*\)-/\1__/' /tmp/temp_sed_stuff_delete_me.$$ > /tmp/temp_sed_stuff_delete_me_2.$$

   rm -f /tmp/temp_sed_stuff_delete_me.$$

   mv -f /tmp/temp_sed_stuff_delete_me_2.$$ "$FILENAME"

   echo "done"

fi


SEARCH2=`grep -iE "^X-SQ-CALID:sm_.*-" "$FILENAME"`

# fix if needed
#
if test ! -z "$SEARCH2"; then

   echo -n "  Fixing X-SQ-CALID for file $FILENAME..."

   sed 's/^\(X-SQ-CALID:sm_.*\)-/\1__/' "$FILENAME" > /tmp/temp_sed_stuff_delete_me.$$

   # twice cuz sometimes we have two dashes
   sed 's/^\(X-SQ-CALID:sm_.*\)-/\1__/' /tmp/temp_sed_stuff_delete_me.$$ > /tmp/temp_sed_stuff_delete_me_2.$$

   rm -f /tmp/temp_sed_stuff_delete_me.$$

   mv -f /tmp/temp_sed_stuff_delete_me_2.$$ "$FILENAME"

   echo "done"

fi


SEARCH3=`grep -iE "^X-SQ-EVTPARENTCALENDARS:sm_.*-" "$FILENAME"`

# fix if needed
#
if test ! -z "$SEARCH3"; then

   echo -n "  Fixing X-SQ-EVTPARENTCALENDARS for file $FILENAME..."

   sed 's/^\(X-SQ-EVTPARENTCALENDARS:sm_.*\)-/\1__/' "$FILENAME" > /tmp/temp_sed_stuff_delete_me.$$

   # twice cuz sometimes we have two dashes
   sed 's/^\(X-SQ-EVTPARENTCALENDARS:sm_.*\)-/\1__/' /tmp/temp_sed_stuff_delete_me.$$ > /tmp/temp_sed_stuff_delete_me_2.$$

   rm -f /tmp/temp_sed_stuff_delete_me.$$

   mv -f /tmp/temp_sed_stuff_delete_me_2.$$ "$FILENAME"

   echo "done"

fi


# now fix file name
if test `echo "$FILENAME" | grep -ce "-"` -gt 0; then

   echo -n " Fixing file name $FILENAME..."
   CORRECTED_FILENAME=`echo "$FILENAME" | sed s/-/__/g`
   mv -f "$FILENAME" "$CORRECTED_FILENAME"
   echo "done"

fi


done

popd > /dev/null

}

fixcalids $DIRNAME

