#!/usr/bin/perl -w
use Date::ICal;


# change this if needed
#
$newCalDir="/tmp";



if (!$ARGV[0])
{
   print "Usage: $0 <old_squirrelmail_calendar_file>\n";
   print "\n";
   exit;
}


$newCalFile="$newCalDir/tempCalFile.ics";
$oldCalFile=$ARGV[0];

$junk=""; # avoids perl warning

# remove path from calendar name
if ($oldCalFile =~ /\//)
{
   ($junk, $calName)=split /.*\//, $oldCalFile;
}
else
{
   $calName = $oldCalFile;
}

# remove any file extension from calendar name
($calName, $junk)=split /\.\w+$/, $calName;

#print "$oldCalFile\n$newCalFile\n$calName\n";
#exit;

# Open the file handles and read the stuff from the squirrelmail calendar
open (SQCAL,"<$oldCalFile") || die "could not open squirrelmail calendar $!\n";
my @events=<SQCAL>;
open (MYCAL,">$newCalFile") || die "could not create calendar file $!\n";

# Start printing the icalendar

print MYCAL "BEGIN:VCALENDAR\nCALSCALE:GREGORIAN\nPRODID:-//SquirrelMail//NONSGML SquirrelMail Calendar Plugin\n V2.0 (conversion script)//EN\nVERSION:2.0\n";
print MYCAL "X-WR-CALNAME:$calName\n";
foreach (@events){
  my @elements=split(/\|/,$_);
  if ($elements[0]=~/(\d{4})(\d{4})/){
    $elements[0]="$2$1";
  }

  my $startstring="$elements[0]T$elements[1]";
  my $icalstart=Date::ICal->new(ical=>"$startstring",offset=>"");
  my $hourduration=int($elements[2]/60);
  my $minuteduration=int($elements[2]%60);
  my $durationstring="P0DT".$hourduration."H".$minuteduration."M";

  # apparently we assume that no duration = full day event
  if ($durationstring eq "P0DT0H0M"){$durationstring="P1DT0H0M";}

  my $icalend=$icalstart + $durationstring;
  my $icalendhour=$icalend->hour;
  my $icalendyear=$icalend->year;
  my $icalendmonth=$icalend->month;
  if (length($icalendmonth)==1){
    $icalendmonth="0$icalendmonth";
  }
  my $icalendday=$icalend->day;
  if (length($icalendday)==1){
    $icalendday="0$icalendday";
  }
# padding with leading zeroes is fun

  if (length($icalendhour)==1){
    $icalendhour="0$icalendhour";
  }

# again, leading zeros are fun

  my $icalendminute=$icalend->minute;
  if (length($icalendminute)==1){
    $icalendminute="0$icalendminute";
  }

# this is for all day events

  if ($durationstring eq "P1DT0H0M"){
    $startstring=$elements[0];
    print MYCAL "BEGIN:VEVENT\nSUMMARY:$elements[4]\nDTSTART\;VALUE=DATE:$elements[0]"."\nDTEND\;VALUE=DATE:".$icalendyear.$icalendmonth.$icalendday."\nDESCRIPTION:$elements[5]\nEND:VEVENT\n";
  }
  else{
    print MYCAL "BEGIN:VEVENT\nSUMMARY:$elements[4]\nDTSTART\;VALUE=DATE:$startstring"."00\nDTEND\;VALUE=DATE:$elements[0]T".$icalendhour.$icalendminute."00\nDESCRIPTION:$elements[5]\nEND:VEVENT\n";
  }
}
print MYCAL "END:VCALENDAR\n";
close MYCAL;
close SQCAL;


# dump conversion to screen
#
open (SQCAL,"<$newCalFile") || die "could not open new converted calendar $!\n";
@events=<SQCAL>;
foreach (@events)
{
   print "$_";
}

unlink "$newCalFile"

