<?php


/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



define('SM_PATH','../../');



include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/url_validator.php');
include_once(SM_PATH . 'plugins/calendar/interface/list_calendars.php');
include_once(SM_PATH . 'plugins/calendar/interface/edit_calendar.php');
include_once(SM_PATH . 'plugins/calendar/interface/add_new_personal_calendar.php');



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



global $username, $domain, $data_dir, $color, $migrateOldCalendarData;
$errorMessages = array();
$messages = array();



// export calendar if needed
//
sqgetGlobalVar('exportCalID', $exportCalID, SQ_FORM);
if (!empty($exportCalID))
{

   if (!sqgetGlobalVar('MSicalLineDelim', $MSicalLineDelim, SQ_FORM))
      $MSicalLineDelim = 0;
   $icalLineDelim = '';
   if ($MSicalLineDelim) $icalLineDelim = MICROSOFT_ICAL_LINE_DELIM;
   include_once(SM_PATH . 'plugins/calendar/download.php');
   download_calendar($exportCalID, FALSE, $icalLineDelim);

}



bindtextdomain('calendar', SM_PATH . 'locale');
textdomain('calendar');



// get external calendar links if given
//
sqgetGlobalVar('externalCalURI', $externalCalURI, SQ_FORM);
if (!empty($externalCalURI))
{

   sqgetGlobalVar('externalCalName', $externalCalName, SQ_FORM);


   // validate URI
   //
   $result = _ValURL($externalCalURI, array('Require'=>array('Server'=>TRUE, 'TLD'=>TRUE), 'Forbid'=>array(), 'AssumeProtocol' => 'http', 'AllowBracks' => true));
   if ($result['Result'] == 'OK')
   {
      $externalCalURI = $result['Value'];
      $cal = loadExternalCalendar($externalCalURI);
      if ($cal === FALSE)
         $errorMessages[] = _("Could not load external calendar") . ': ' . $externalCalURI;
      else
      {
         $externalCalName = trim($externalCalName);
         if (!empty($externalCalName))
         {
            $externalName = $externalCalName;
            $cal->setName($externalCalName);

            // need to correct the cached version to use overridden name
            //
            global $externalCalendars;
            sqgetGlobalVar('externalCalendars', $externalCalendars, SQ_SESSION);
            $externalCalendars[$cal->getID()] = serialize($cal);
            sqsession_register($externalCalendars, 'externalCalendars');

         }
         else
            $externalName = $cal->getName();
         $externalID = $cal->getID();
         $external_calendars = getPref($data_dir, $username, 'external_calendars', '');


         // make sure we don't already have this calendar in user prefs
         //
         if (loadExternalCalendarFromUserPrefs($cal->getID()) === FALSE)
         {
            if (!empty($external_calendars)) $external_calendars .= '||||';
            $external_calendars .= $externalID . '^^^^' . $externalName . '^^^^' . $externalCalURI;
            setPref($data_dir, $username, 'external_calendars', $external_calendars);
         }
      }
   }
   else
      $errorMessages[] = _("Could not load external calendar; bad address") . ': ' . $externalCalURI;

}



// remove calendar (external or personal) if needed
//
sqgetGlobalVar('removeCalID', $removeCalID, SQ_FORM);
if (!empty($removeCalID))
{

   $cal = get_calendar($removeCalID);
   if ($cal->isExternal())
      removeExternalCalendarFromUserPrefs($removeCalID);
   else if ($cal->getCalendarType() == SM_CAL_TYPE_PERSONAL)
//TODO: don't we want to confirm first?
      delete_calendar($removeCalID);

}



// prepare to migrate old calendar data
//
if ($migrateOldCalendarData)
{
   $todaysYear = date('Y');
   $oldFilename = getHashedFile($username, $data_dir, "$username.$todaysYear.cal");
}


// get uploaded calendar if given
//
// get global variables for versions of PHP < 4.1
//
if (!compatibility_check_php_version(4, 1)) 
{
   global $HTTP_POST_FILES;
   $_FILES = $HTTP_POST_FILES;
}

$calContentArray = array();

if (!empty($_FILES['uploadCalFile']))
{

   // if possible, remove any path info from beginning of 
   // file name and a file extension too, if present
   //
   preg_match('/.*[\/\\\](.+)/', $_FILES['uploadCalFile']['name'], $matches);
   if (!empty($matches[1]))
      $fileName = $matches[1];
   else
      $fileName = $_FILES['uploadCalFile']['name'];
   preg_match('/(.+)\.\w+/', $fileName, $matches);
   if (!empty($matches[1]))
      $fileName = $matches[1];


   $calContentArray = file($_FILES['uploadCalFile']['tmp_name']);
   $cal = Calendar::getCalendarFromICal($calContentArray, $fileName, $fileName);
}


// migrate old calendar data if necessary
//
else if ($migrateOldCalendarData && file_exists($oldFilename))
{

   $script = SM_PATH . 'plugins/calendar/scripts/convert_cal_to_ical.pl';
   if (file_exists($script)) 
   {

      if(is_executable($script)) 
      {

         $messages[] = _("Converting old calendar. . .");
         //$calContent = `$script $oldFilename 2>&1`;
         //$calContentArray = explode("\n", $calContent);
         $cmd = "$script $oldFilename 2>&1";
         $lastOutputLine = exec($cmd, $calContentArray, $retVal);

         if ($retVal)
         {
            $messages[] = sprintf(_("Problem converting old calendar; please contact your administrator (%s)"), $retVal);
            $calContentArray = array();

            global $cal_debug;
            if ($cal_debug)
               sm_print_r($cmd, $lastOutputLine, $calContentArray);
         }
         else
         {

            $cal = Calendar::getCalendarFromICal($calContentArray);


            // Rename the file so that we don't convert it more than once
            //
            $newFilename = $oldFilename . '.bak';
            if (!rename($oldFilename, $newFilename))
               $messages[] = sprintf(_("Can't rename %s to %s"), $oldFilename, $newFilename);

            // now we need to set some of the variables that 
            // would come through on a calendar upload
            //
            if (!check_php_version(4,1)) 
            {
               global $HTTP_POST_VARS;
               $_POST = &$HTTP_POST_VARS;
            }
            $_POST['synchCal'] = 'YES';
               $_POST['calID'] = 'personal';

         }

      }
      else 
         $messages[] = sprintf(_("Problem converting old calendar; please contact your administrator (cannot execute %s)"), $script);

   }
   else 
      $messages[] = sprintf(_("Can't find old personal calendar: %s"), $script);

}


// now store the uploaded or converted calendar
//
if (!empty($calContentArray)) 
{

   $cal->setType(SM_CAL_TYPE_PERSONAL);
   $cal->remove_user($username);
   $cal->add_user($username, SM_CAL_ACCESS_LEVEL_OWNER);


   // synch/merge events in uploaded calendar with another cal
   //
   sqgetGlobalVar('synchCal', $synchCal, SQ_FORM);
   sqgetGlobalVar('calID', $synchCalID, SQ_FORM);
   if (!empty($synchCal) && $synchCal == 'YES' && !empty($synchCalID))
   {
      if ($synchCalID == 'auto') 
      {
         $external_list = get_all_external_calendars();
         $shared_list = get_all_accessible_calendars($username, $domain);
         $public_list = get_all_public_calendars();
         $calList = array_merge($shared_list, $public_list, $external_list);

         foreach ($calList as $c)
         {

            if (($c->isOwner($username) || $c->canWrite($username))
             && $c->getID() == $cal->getID())
            {
               $synchCalID = $cal->getID();
               break;
            }
         }
      }
      $personalCalID = get_personal_cal_id($username, $domain);
      if ($synchCalID == 'personal' 
       || ($synchCalID == 'auto' 
        && $cal->getID() == $personalCalID)) 
         $synchCalID = $personalCalID;


      // if no match was found for auto-detect, just add new cal
      //
      if ($synchCalID == 'auto') 
      {
         create_calendar($cal);
         $cal->saveEvents(TRUE);
      }


      // otherwise, synch!
      //
      else
      {
         $synchCal = get_calendar($synchCalID);
         $synchCal->addEvents($cal->getEvents(), $cal->getID());
//LEFT OFF HERE - test merge/synch some more
         $messages[] = sprintf(_("Successfully merged calendar into \"%s\""), $synchCal->getName());
      }

   }


   // create additional personal calendar
   //
   else
   {

      // check if there is already a calendar with the same ID
      //
      if (get_calendar($cal->getID(), TRUE) !== FALSE)
         $errorMessages[] = _("You already have a calendar with the same ID.  Are you sure you don't want to merge/synch the calendar you are uploading?");


      // no?  it's OK to add the new calendar
      //
      else
      {
         create_calendar($cal);
         $cal->saveEvents(TRUE);
      }

   }

//LEFT OFF HERE: upload a file that already has an ID field (for the cal... but heck, actually, try events too) in it and make sure ours doesn't ignore it and use one of its own auto-generated IDs!  if that works ok, the following line can be deleted
   /////////if (!empty($correctID)) $cal->setID($correctID);

//LEFT OFF HERE: need a "remove" link for these imported calendars!(done)  does it mean that we can get rid of the delete functionality on the admin page?  is the admin page becoming obsolete?(although delete links for shared cals currently aren't displayed on cal list page even for admin)  maybe so.  then the users page is the only admin page you need

}
// in case we allow URI imports:
//sqgetGlobalVar('uploadCalURI', $uploadCalURI, SQ_FORM);



// add new personal calendar
//
$addNewPersonalError = FALSE;
sqgetGlobalVar('addPersonalCalendar', $addPersonalCalendar, SQ_FORM);
if (!empty($addPersonalCalendar) && $addPersonalCalendar == 'YES')
{

   sqgetGlobalVar('calName', $calName, SQ_FORM);
   $calName = trim($calName);
   if (!empty($calName))
   {

      // create new empty calendar
      //
      $cal = new Calendar('', 0, '', '', SM_CAL_TYPE_PERSONAL, $calName, 
                          $username, gmdate('Ymd\THis\Z'), '', '', 
                          array($username));
      create_calendar($cal);


      // problems?
      //
      if (FALSE)
      {
         $errorMessages[] = 'Problem creating new calendar';
         $addNewPersonalError = TRUE;
      }

   }

}



// edit calendar
//
sqgetGlobalVar('editCalID', $editCalID, SQ_FORM);
if (!empty($editCalID))
{

   $cal = get_calendar($editCalID);
   if ($cal->isOwner($username) || $cal->canWrite($username) || $cal->isExternal())
   {

      sqgetGlobalVar('calName', $calName, SQ_FORM);
      $calName = trim($calName);
      if (!empty($calName))
         $cal->setName($calName);


      if ($cal->isExternal())
      {

         // just need to recache with new name and change user prefs
         //
         global $externalCalendars;
         sqgetGlobalVar('externalCalendars', $externalCalendars, SQ_SESSION);
         $externalCalendars[$cal->getID()] = serialize($cal);
         sqsession_register($externalCalendars, 'externalCalendars');


         $external_calendars = getPref($data_dir, $username, 'external_calendars', '');
         $new_external_list = '';
         $first = TRUE;

         $externalCals = explode('||||', $external_calendars);
         foreach ($externalCals as $externalCal)
         {
            if (empty($externalCal)) continue;
      
            list($id, $name, $uri) = explode('^^^^', $externalCal);
      
            if ($id == $cal->getID())
            {
               $name = $cal->getName();
            }

            if (!$first) $new_external_list .= '||||';

            $new_external_list .= "$id^^^^$name^^^^$uri";

            $first = FALSE;
         }

         setPref($data_dir, $username, 'external_calendars', $new_external_list);

      }


      else
      {
//TODO: if we edit other parts of the calendar here, be sure only to allow
//      editing of most other fields when this is NOT an external calendar!!
//  (do other editing here)

         // now increment calendar sequence and re-save calendar
         //
         $cal->incrementSequence();
         $cal->setLastUpdator($username);
         $cal->setLastUpdateDate(gmdate('Ymd\THis\Z'));
         update_calendar($cal);

      }

   }

}



bindtextdomain('squirrelmail', SM_PATH . 'locale');
textdomain('squirrelmail');


displayPageHeader($color, "None");



sqgetGlobalVar('startEditCalID', $startEditCalID, SQ_FORM);
sqgetGlobalVar('startAddPersonalCalendar', $startAddPersonalCalendar, SQ_FORM);



// go add new personal calendar
//
if ($addNewPersonalError || 
 (!empty($startAddPersonalCalendar) && $startAddPersonalCalendar == 'YES'))
{

   add_new_personal_calendar($color, $errorMessages);

}



// go rename calendar
//
else if (!empty($startEditCalID))
{

   edit_calendar($color, get_calendar($startEditCalID), $errorMessages);

}



// show regular list calendars page
else
{

   $external_list = get_all_external_calendars();
   $shared_list = get_all_accessible_calendars($username, $domain);
   $public_list = get_all_public_calendars();
   $calList = array_merge($shared_list, $public_list, $external_list);
   usort($calList, 'calendar_sort');

   display_calendar_list($color, $calList, $errorMessages, $messages);

}


?>
