<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Displays page header for helper month view calendar
  *
  * @param int $yesr The year of the month to be shown
  * @param int $month The month to be shown
  * @param object $calendar The calendar for which the helper is 
  *                         being used 
  *
  */
function showHelperClockHeader($hour, $minute)
{

   global $color, $calendar_theme;
   if (!isset($color[12])) $color[12] = '';


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   displayHtmlHeader(_("Time Helper"), '', FALSE);
   echo "<body text=\"$color[8]\" bgcolor=\"$color[4]\" link=\"$color[7]\" vlink=\"$color[7]\" alink=\"$color[7]\">";


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


//LEFT OFF HERE -- this whole file is just a copy of the helper calendar and needs to be rewritten!
//LEFT OFF HERE -- this whole file is just a copy of the helper calendar and needs to be rewritten!
//LEFT OFF HERE -- this whole file is just a copy of the helper calendar and needs to be rewritten!
//LEFT OFF HERE -- this whole file is just a copy of the helper calendar and needs to be rewritten!
exit;
   $prev_date = mktime(0, 0, 0, $month - 1, 1, $year);
   $act_date  = mktime(0, 0, 0, $month, 1, $year);
   $next_date = mktime(0, 0, 0, $month + 1, 1, $year);
   $prev_month = date('n', $prev_date );
   $next_month = date('n', $next_date);
   $prev_year = date('Y', $prev_date);
   $next_year = date('Y', $next_date );


   $self = 'helper_month.php';

   echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
      . html_tag('tr', "\n"
      . html_tag('th', "<small><a href=\"$self?calID=" . urlencode($calendar->getID()) 
      . "&year=" . ($year - 1) . "&month=$month\">&lt;&lt;&nbsp;" . ($year - 1) . "</a></small>") . "\n"
      . html_tag('th', "<small><a href=\"$self?calID=" . urlencode($calendar->getID()) 
      . "&year=$prev_year&month=$prev_month\">&lt;&nbsp;"
      . date_intl('M', $prev_date) . "</a></small>") . "\n"
      . html_tag('th', '<small>' . date_intl( 'F Y', $act_date ) . '</small>',
        '', $calendar_theme['month_view_title_background'], '')
      . html_tag('th', "<small><a href=\"$self?calID=" . urlencode($calendar->getID()) 
      . "&year=$next_year&month=$next_month\">"
      . date_intl('M', $next_date) . "&nbsp;&gt;</a></small>") . "\n"
      . html_tag( 'th', "<small><a href=\"$self?calID=" . urlencode($calendar->getID()) . "&year=" 
      . ($year + 1) . "&month=$month\">" . ($year + 1) . "&nbsp;&gt;&gt;</a></small>")) . "\n"
      . '</table>';


}


/**
  * Displays one month view for the small (popup) helper calendar
  *
  * @param int $yesr The year of the month to be shown
  * @param int $month The month to be shown
  *
  */
function showHelperClock($hour, $minute)
{

   global $color, $calendar_theme, $show_week_numbers_in_month_view_override;
   if (!isset($color[12])) $color[12] = '';
   $show_week_numbers_in_month_view = $show_week_numbers_in_month_view_override;


   showHelperClockHeader($hour, $minute);


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   $tuitachi = mktime(0, 0, 0, $month, 1, $year);
   $aDay = 1 - date('w', $tuitachi);
   $daysInMonth = date('t', $tuitachi);
   $today = getdate(time());
   $today = mktime(0, 0, 0, $today['mon'], $today['mday'], $today['year']);


   echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 
                 'width="100%" border="0" cellpadding="2" cellspacing="1"')
      . html_tag( 'tr', ($show_week_numbers_in_month_view
      ? html_tag( 'th', '&nbsp;', '', $calendar_theme['month_view_title_background'], '') 
      : '')
      . html_tag( 'th', '<small>' . _("Sun") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
      . html_tag( 'th', '<small>' . _("Mon") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
      . html_tag( 'th', '<small>' . _("Tue") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
      . html_tag( 'th', '<small>' . _("Wed") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
      . html_tag( 'th', '<small>' . _("Thu") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
      . html_tag( 'th', '<small>' . _("Fri") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
      . html_tag( 'th', '<small>' . _("Sat") . '</small>', 
        '', $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n");


   while ($aDay <= $daysInMonth) 
   {

      $theDay = mktime(0, 0, 0, $month, $aDay, $year);

      // switch back to SM domain for date_intl
      //
      bindtextdomain ('squirrelmail', SM_PATH . 'locale');
      textdomain ('squirrelmail');

      echo html_tag('tr')
         . ($show_week_numbers_in_month_view 
         ? html_tag('td', '<small>W' . date_intl('W', $theDay) . '</small>', '', $calendar_theme['month_view_day_background'], '')
         : '');

      bindtextdomain ('calendar', SM_PATH . 'locale');
      textdomain ('calendar');


      // iterate on a weekly basis
      //
      for ($dayOfWeek = 1; $dayOfWeek <= 7; $dayOfWeek++) 
      {

         $theDay = mktime(0, 0, 0, $month, $aDay, $year);


         // is this a day that is in this month?
         //
         if ($aDay <= $daysInMonth && $aDay > 0)
         {

            $holiday = $calendar->getHolidayForDay($year, $month, $aDay);
            if (!empty($holiday))
               $dayColor = $calendar_theme['month_view_holiday_background'];
            else if ($dayOfWeek == 1 || $dayOfWeek == 7)
               $dayColor = $calendar_theme['month_view_weekend_background'];
            else if ($theDay == $today) 
               $dayColor = $calendar_theme['helper_month_view_today_background'];
            else
               $dayColor = $calendar_theme['month_view_day_background'];


            echo html_tag('td', '', 'right', $dayColor, 'height="5" valign="top"'); 


            $title = '';


            if ($theDay == $today) 
               $title = _("TODAY");


            if (!empty($holiday))
               if ($theDay == $today)
                  $title .= ', ' . cal_encode_output($holiday->getName(), FALSE);
               else
                  $title = cal_encode_output($holiday->getName(), FALSE);


            echo "<a href=\"#\" " . (!empty($title) ? "title=\"$title\"" : '') 
               . "style=\"text-decoration:none;\"><small>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$aDay</small></a>";

         } 



         // days that are not in this month (before/after first/last day of month)
         //
         else 
         {

            // show events before/after this month 
            //
            $holiday = $calendar->getHolidayForDay($year, $month, $aDay);
            if (!empty($holiday))
               $dayColor = $calendar_theme['month_view_non_month_holiday_background'];
            else if ($dayOfWeek == 1 || $dayOfWeek == 7)
               $dayColor = $calendar_theme['month_view_non_month_weekend_background'];
            else if ($theDay == $today) 
               $dayColor = $calendar_theme['helper_month_view_today_background'];
            else
               $dayColor = $calendar_theme['month_view_non_month_day_background'];


            $otherMonthDayInfo = getdate($theDay);
            echo html_tag( 'td', '', 'left', $color[4], 'height="5" valign="top"') 
               . html_tag('table', '', '', $dayColor, 'height="100%" width="100%" border="0" cellpadding="1" cellspacing="1"')
               . html_tag('tr') . "\n" 
               . html_tag('td', '', 'right', '', 'valign="top"');


            $title = '';


            if ($theDay == $today) 
               $title = _("TODAY");


            if (!empty($holiday))
               if ($theDay == $today)
                  $title .= ', ' . cal_encode_output($holiday->getName(), FALSE);
               else
                  $title = cal_encode_output($holiday->getName(), FALSE);


            echo "<a href=\"#\" " . (!empty($title) ? "title=\"$title\"" : '')
               . "style=\"text-decoration:none;\"><small>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
               . $otherMonthDayInfo['mday'] . '</small></a>';

         }


         // close extra table when showing events before/after this month
         //
         if (!($aDay <= $daysInMonth && $aDay > 0))
            echo "</td></tr></table>";


         echo "\n</td>\n";
         $aDay++;

      }

      echo '</tr>';

   }

   echo '</table>';


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


   showHelperClockFooter($hour, $minute);

}



/**
  * Displays page footer for helper month view calendar
  *
  * @param int $yesr The year of the month to be shown
  * @param int $month The month to be shown
  *
  */
function showHelperClockFooter($hour, $minute)
{

   echo '</body></html>';

}



?>
