<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Presents the user with an interface to create a new personal calendar
  *
  * @param array $color Standard SquirrelMail colors array
  * @param array $error_messages An array of any errors found with
  *                              previously submitted preferences data
  *
  *
  */
function add_new_personal_calendar($color, $error_messages) 
{

   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   if (!isset($color[12])) $color[12] = '';


   if (!empty($error_messages))
   {
      echo '<center><strong style="color:' . $color[2] . '">' . _("Error:");
      foreach ($error_messages as $msg)
         echo $msg . '<br />';
      echo '</strong>';
   }


   sqgetGlobalVar('calName', $calName, SQ_FORM);


   echo '<form style="margin:0" method="POST" action="list_calendars.php">'
      . '<input type="hidden" name="addPersonalCalendar" value="YES">'
      . "<table width=\"100%\" height=\"85%\" align=\"center\"><tr><td>\n"
      . "<br><br><table width=\"60%\" bgcolor=\"$color[9]\" align=\"center\">\n"
      . "<tr><td align=\"center\"><b>" . _("Create New Calendar") . "</b></td></tr><tr><td>\n"
      . "<table width=\"100%\" align=\"center\" bgcolor=\"$color[4]\">\n"

      . "<tr><td align=\"right\">" . _("Name") . ':</td><td align="left"><input type="text" name="calName" value="' . $calName . '">'
      . "</td></tr>"

      . "<tr><td></td><td align='right'><input type='submit' value='" . _("Create") . "'></td></tr>"

      . "</table></td></tr></table>"
      . "</td></tr><tr><td height='100%' valign='bottom'>\n"
      . "</td></td></table></form>\n";


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}


?>
