<?php


/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



define('SM_PATH','../../');



include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'plugins/calendar/functions.php');
include_once(SM_PATH . 'plugins/calendar/url_validator.php');
include_once(SM_PATH . 'plugins/calendar/interface/list_calendars.php');
include_once(SM_PATH . 'plugins/calendar/interface/edit_calendar.php');



   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



global $username, $domain, $data_dir, $color;
$errorMessages = array();
$messages = array();



// export calendar if needed
//
sqgetGlobalVar('exportCalID', $exportCalID, SQ_FORM);
if (!empty($exportCalID))
{

   include_once(SM_PATH . 'plugins/calendar/download.php');
   download_calendar($exportCalID, FALSE);

}



// get external calendar links if given
//
sqgetGlobalVar('externalCalURI', $externalCalURI, SQ_FORM);
if (!empty($externalCalURI))
{

   sqgetGlobalVar('externalCalName', $externalCalName, SQ_FORM);


   // validate URI
   //
   $result = _ValURL($externalCalURI, array('Require'=>array('Server'=>TRUE, 'TLD'=>TRUE), 'Forbid'=>array(), 'AssumeProtocol' => 'http', 'AllowBracks' => true));
   if ($result['Result'] == 'OK')
   {
      $externalCalURI = $result['Value'];
      $cal = loadExternalCalendar($externalCalURI);
      if ($cal === FALSE)
         $errorMessages[] = _("Could not load external calendar") . ': ' . $externalCalURI;
      else
      {
         $externalCalName = trim($externalCalName);
         if (!empty($externalCalName))
         {
            $externalName = $externalCalName;
            $cal->setName($externalCalName);

            // need to correct the cached version to use overridden name
            //
            global $externalCalendars;
            sqgetGlobalVar('externalCalendars', $externalCalendars, SQ_SESSION);
            $externalCalendars[$cal->getID()] = serialize($cal);
            sqsession_register($externalCalendars, 'externalCalendars');

         }
         else
            $externalName = $cal->getName();
         $externalID = $cal->getID();
         $external_calendars = getPref($data_dir, $username, 'external_calendars', '');


         // make sure we don't already have this calendar in user prefs
         //
         if (loadExternalCalendarFromUserPrefs($cal->getID()) === FALSE)
         {
            if (!empty($external_calendars)) $external_calendars .= '||||';
            $external_calendars .= $externalID . '^^^^' . $externalName . '^^^^' . $externalCalURI;
            setPref($data_dir, $username, 'external_calendars', $external_calendars);
         }
      }
   }
   else
      $errorMessages[] = _("Could not load external calendar; bad address") . ': ' . $externalCalURI;

}



// remove calendar (external or personal) if needed
//
sqgetGlobalVar('removeCalID', $removeCalID, SQ_FORM);
if (!empty($removeCalID))
{

   $cal = get_calendar($removeCalID);
   if ($cal->isExternal())
      removeExternalCalendarFromUserPrefs($removeCalID);
   else if ($cal->getCalendarType() == SM_CAL_TYPE_PERSONAL)
//TODO: don't we want to confirm first?
      delete_calendar($removeCalID);

}



// get uploaded calendar if given
//
// get global variables for versions of PHP < 4.1
//
if (!compatibility_check_php_version(4, 1)) 
{
   global $HTTP_POST_FILES;
   $_FILES = $HTTP_POST_FILES;
}
if (!empty($_FILES['uploadCalFile']))
{

   $calContentArray = file($_FILES['uploadCalFile']['tmp_name']);
   $cal = Calendar::getCalendarFromICal($calContentArray, $_FILES['uploadCalFile']['name'], $_FILES['uploadCalFile']['name']);
//TODO: try to strip off the file extension from the filename used above?

   $cal->setType(SM_CAL_TYPE_PERSONAL);
   $cal->remove_user($username);
   $cal->add_user($username, SM_CAL_ACCESS_LEVEL_OWNER);


   // synch/merge events in uploaded calendar with another cal
   //
   sqgetGlobalVar('synchCal', $synchCal, SQ_FORM);
   sqgetGlobalVar('calID', $synchCalID, SQ_FORM);
   if (!empty($synchCal) && $synchCal == 'YES' && !empty($synchCalID))
   {
      if ($synchCalID == 'auto') 
      {
         $external_list = get_all_external_calendars();
         $shared_list = get_all_accessible_calendars($username, $domain);
         $public_list = get_all_public_calendars();
         $calList = array_merge($shared_list, $public_list, $external_list);

         foreach ($calList as $c)
         {

            if (($c->isOwner($username) || $c->canWrite($username))
             && $c->getID() == $cal->getID())
            {
               $synchCalID = $cal->getID();
               break;
            }
         }
      }
      $personalCalID = get_personal_cal_id($username, $domain);
      if ($synchCalID == 'personal' 
       || ($synchCalID == 'auto' 
        && $cal->getID() == $personalCalID)) 
         $synchCalID = $personalCalID;


      // if no match was found for auto-detect, just add new cal
      //
      if ($synchCalID == 'auto') 
      {
         create_calendar($cal);
         $cal->saveEvents(TRUE);
      }


      // otherwise, synch!
      //
      else
      {
         $synchCal = get_calendar($synchCalID);
         $synchCal->addEvents($cal->getEvents(), $cal->getID());
//LEFT OFF HERE - test merge/synch some more
         $messages[] = sprintf(_("Successfully merged calendar into \"%s\""), $synchCal->getName());
      }

   }


   // create additional personal calendar
   //
   else
   {
      create_calendar($cal);
      $cal->saveEvents(TRUE);
   }

//LEFT OFF HERE: upload a file that already has an ID field (for the cal... but heck, actually, try events too) in it and make sure ours doesn't ignore it and use one of its own auto-generated IDs!  if that works ok, the following line can be deleted
   /////////if (!empty($correctID)) $cal->setID($correctID);

//LEFT OFF HERE: need a "remove" link for these imported calendars!(done)  does it mean that we can get rid of the delete functionality on the admin page?  is the admin page becoming obsolete?(although delete links for shared cals currently aren't displayed on cal list page even for admin)  maybe so.  then the users page is the only admin page you need

}
// in case we allow URI imports:
//sqgetGlobalVar('uploadCalURI', $uploadCalURI, SQ_FORM);



// edit calendar
//
sqgetGlobalVar('editCalID', $editCalID, SQ_FORM);
if (!empty($editCalID))
{

   $cal = get_calendar($editCalID);
   if ($cal->isOwner($username) || $cal->canWrite($username) || $cal->isExternal())
   {

      sqgetGlobalVar('calName', $calName, SQ_FORM);
      $calName = trim($calName);
      if (!empty($calName))
         $cal->setName($calName);


      if ($cal->isExternal())
      {

         // just need to recache with new name and change user prefs
         //
         global $externalCalendars;
         sqgetGlobalVar('externalCalendars', $externalCalendars, SQ_SESSION);
         $externalCalendars[$cal->getID()] = serialize($cal);
         sqsession_register($externalCalendars, 'externalCalendars');


         $external_calendars = getPref($data_dir, $username, 'external_calendars', '');
         $new_external_list = '';
         $first = TRUE;

         $externalCals = explode('||||', $external_calendars);
         foreach ($externalCals as $externalCal)
         {
            if (empty($externalCal)) continue;
      
            list($id, $name, $uri) = explode('^^^^', $externalCal);
      
            if ($id == $cal->getID())
            {
               $name = $cal->getName();
            }

            if (!$first) $new_external_list .= '||||';

            $new_external_list .= "$id^^^^$name^^^^$uri";

            $first = FALSE;
         }

         setPref($data_dir, $username, 'external_calendars', $new_external_list);

      }


      else
      {
//TODO: if we edit other parts of the calendar here, be sure only to allow
//      editing of most other fields when this is NOT an external calendar!!
//  (do other editing here)

         // now increment calendar sequence and re-save calendar
         //
         $cal->incrementSequence();
         $cal->setLastUpdator($username);
         $cal->setLastUpdateDate(gmdate('Ymd\THis\Z'));
         update_calendar($cal);

      }

   }

}



displayPageHeader($color, "None");



// go rename calendar
//
sqgetGlobalVar('startEditCalID', $startEditCalID, SQ_FORM);
if (!empty($startEditCalID))
{

   edit_calendar($color, get_calendar($startEditCalID), $errorMessages);

}



else
{

   $external_list = get_all_external_calendars();
   $shared_list = get_all_accessible_calendars($username, $domain);
   $public_list = get_all_public_calendars();
   $calList = array_merge($shared_list, $public_list, $external_list);
   usort($calList, 'calendar_sort');

   display_calendar_list($color, $calList, $errorMessages, $messages);

}


?>
