<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



/**
  * Shows calendar display options page
  *
  * @param array $error_messages An array of any errors found with
  *                              previously submitted preferences data
  */
function display_calendar_options($error_messages) 
{

   global $username, $domain, $color, $cal_user_can_override_defaults,
          $twentyfourHourTime, 
          $month_view_show_event_start_time,
          $month_view_show_daily_add_buttons, 
          $day_view_short_time, 
          $day_view_show_hourly_add_buttons, 
          $highlight_threshold,
          $day_view_start_time,
          $external_calendar_clock_skew,
          $day_view_end_time, 
          $show_small_calendar,
          $small_calendar_size,
          $small_calendar_calID,
          $week_start_day,
          $small_calendar_header_color,
          $small_calendar_today_color,
          $small_calendar_event_italic_style,
          $small_calendar_event_color, 
          $small_calendar_day_color, 
          $small_calendar_separator,
          $small_calendar_show_year,
          $small_calendar_show_today_link,
          $small_calendar_show_day_titles,
          $small_calendar_inherit_day_background_colors,
          $max_events_per_day_on_month_view,
          $show_week_numbers_in_month_view_override;

   // should never get this far... but just in case...
   //
   if (!$cal_user_can_override_defaults) exit;

   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

?>

<table bgcolor="<?php echo $color[0]; ?>" align="center" width="95%" cellpadding="1" cellspacing="0" border="0">
  <tr>
    <td align="center"><strong><?php echo _("Calendar Preferences"); ?></strong><br />
      <table width="100%" cellpadding="5" cellspacing="0" border="0">
      <tr>
        <td bgcolor="<?php echo $color[4]; ?>" align="center">
          <form action="" method="POST" name="calendarOptionsForm">
            <input type="hidden" name="changeCalendarOptions" value="1" />
            <table width="100%" cellpadding="2" cellspacing="0" border="0">
              <tr>
                <td colspan="2" align="left">
                </td>
              </tr>
<?php

   if (!empty($error_messages))
   {
      echo '<tr><td align="center" valign="middle" colspan="2" nowrap><strong style="color:'
         . $color[2] . '">' . _("Error:") . '<br />';
      foreach ($error_messages as $msg)
         echo $msg . '<br />';
      echo '<br /></strong></td></td>';
   }

?>
              <tr>
                <td align="center" valign="middle" colspan="2" nowrap><strong><?php echo _("General Calendar Options"); ?></strong>
                </td>
              </tr>

<?php


//example of checkbox
//
//   echo '<tr><td align="right" nowrap>' . _("Twenty-four hour-based times:") . "</td>\n"
//      . '<td><input name="twentyfourHourTime" type="checkbox"'
//      . ($twentyfourHourTime ? ' CHECKED' : '')
//      . ' /> ' . _("Show all times in 24 hour format") . "</td></tr>\n";


   echo '<tr><td align="right" valign="middle">' . _("Show Times in 24-hour Format:") 
      . '</td><td align="left"><input type="radio" id="twentyfourHourTimeYes" '
      . 'name="twentyfourHourTime" value="1"'
      . ($twentyfourHourTime ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="twentyfourHourTimeYes">' . _("Yes") 
      . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" id="twentyfourHourTimeNo"'
      . 'name="twentyfourHourTime" value="0"'
      . ($twentyfourHourTime ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="twentyfourHourTimeNo">' . _("No") . '</label></td></tr>';
//LEFT OFF HERE -- make sure all yes/no selectors below have text labels as the above on does
//LEFT OFF HERE -- make sure all yes/no selectors below have text labels as the above on does
//LEFT OFF HERE -- make sure all yes/no selectors below have text labels as the above on does


   echo '<tr><td align="right" nowrap>' . _("First Day of Week:") 
      . ' </td><td><select name="week_start_day">'
      . select_option_day_of_week($week_start_day)
      . '</select></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Priority at which Events Are Highlighted:") 
      . ' </td><td><select name="highlight_threshold">' 
      . select_option_priority($highlight_threshold)
      . '</select></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Daily Add Event Buttons in Month View:") 
      . '</td><td align="left"><input type="radio" name="month_view_show_daily_add_buttons" id="month_view_show_daily_add_buttonsYes" value="1"'
      . ($month_view_show_daily_add_buttons ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="month_view_show_daily_add_buttonsYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="month_view_show_daily_add_buttons" id="month_view_show_daily_add_buttonsNo" value="0"'
      . ($month_view_show_daily_add_buttons ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="month_view_show_daily_add_buttonsNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Week Numbers in Month View:") 
      . '</td><td align="left"><input type="radio" name="show_week_numbers_in_month_view_override" id="show_week_numbers_in_month_view_overrideYes" value="1"'
      . ($show_week_numbers_in_month_view_override ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="show_week_numbers_in_month_view_overrideYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="show_week_numbers_in_month_view_override" id="show_week_numbers_in_month_view_overrideNo" value="0"'
      . ($show_week_numbers_in_month_view_override ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="show_week_numbers_in_month_view_overrideNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Event Start Times in Month View:") 
      . '</td><td align="left"><input type="radio" name="month_view_show_event_start_time" id="month_view_show_event_start_timeYes" value="1"'
      . ($month_view_show_event_start_time ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="month_view_show_event_start_timeYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="month_view_show_event_start_time" id="month_view_show_event_start_timeNo" value="0"'
      . ($month_view_show_event_start_time ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="month_view_show_event_start_timeNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Maximum Number Events Shown Per Day in Month View:") 
      . ' </td><td><select name="max_events_per_day_on_month_view">'
      . select_option_integer(1, 10, $max_events_per_day_on_month_view)
      . '</select></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Compacted Time of Day in Day View:") 
      . '</td><td align="left"><input type="radio" name="day_view_short_time" id="day_view_short_timeYes" value="1"'
      . ($day_view_short_time ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="day_view_short_timeYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="day_view_short_time" id="day_view_short_timeNo" value="0"'
      . ($day_view_short_time ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="day_view_short_timeNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Hourly Add Event Buttons in Day View:") 
      . '</td><td align="left"><input type="radio" name="day_view_show_hourly_add_buttons" id="day_view_show_hourly_add_buttonsYes" value="1"'
      . ($day_view_show_hourly_add_buttons ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="day_view_show_hourly_add_buttonsYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="day_view_show_hourly_add_buttons" id="day_view_show_hourly_add_buttonsNo" value="0"'
      . ($day_view_show_hourly_add_buttons ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="day_view_show_hourly_add_buttonsNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Day View Start Time:") 
      . ' </td><td><select name="day_view_start_time">'
      . '<option value="0" ' 
      . (empty($day_view_start_time) ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '00' : sprintf(_("%sam"), '12')) . '</option>'
      . '<option value="1" ' 
      . ($day_view_start_time == 1 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '01' : sprintf(_("%sam"), '1')) . '</option>'
      . '<option value="2" ' 
      . ($day_view_start_time == 2 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '02' : sprintf(_("%sam"), '2')) . '</option>'
      . '<option value="3" ' 
      . ($day_view_start_time == 3 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '03' : sprintf(_("%sam"), '3')) . '</option>'
      . '<option value="4" ' 
      . ($day_view_start_time == 4 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '04' : sprintf(_("%sam"), '4')) . '</option>'
      . '<option value="5" ' 
      . ($day_view_start_time == 5 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '05' : sprintf(_("%sam"), '5')) . '</option>'
      . '<option value="6" ' 
      . ($day_view_start_time == 6 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '06' : sprintf(_("%sam"), '6')) . '</option>'
      . '<option value="7" ' 
      . ($day_view_start_time == 7 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '07' : sprintf(_("%sam"), '7')) . '</option>'
      . '<option value="8" ' 
      . ($day_view_start_time == 8 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '08' : sprintf(_("%sam"), '8')) . '</option>'
      . '<option value="9" ' 
      . ($day_view_start_time == 9 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '09' : sprintf(_("%sam"), '9')) . '</option>'
      . '<option value="10" ' 
      . ($day_view_start_time == 10 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '10' : sprintf(_("%sam"), '10')) . '</option>'
      . '<option value="11" ' 
      . ($day_view_start_time == 11 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '11' : sprintf(_("%sam"), '11')) . '</option>'
      . '<option value="12" ' 
      . ($day_view_start_time == 12 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '12' : sprintf(_("%spm"), '12')) . '</option>'
      . '<option value="13" ' 
      . ($day_view_start_time == 13 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '13' : sprintf(_("%spm"), '1')) . '</option>'
      . '<option value="14" ' 
      . ($day_view_start_time == 14 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '14' : sprintf(_("%spm"), '2')) . '</option>'
      . '<option value="15" ' 
      . ($day_view_start_time == 15 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '15' : sprintf(_("%spm"), '3')) . '</option>'
      . '<option value="16" ' 
      . ($day_view_start_time == 16 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '16' : sprintf(_("%spm"), '4')) . '</option>'
      . '<option value="17" ' 
      . ($day_view_start_time == 17 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '17' : sprintf(_("%spm"), '5')) . '</option>'
      . '<option value="18" ' 
      . ($day_view_start_time == 18 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '18' : sprintf(_("%spm"), '6')) . '</option>'
      . '<option value="19" ' 
      . ($day_view_start_time == 19 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '19' : sprintf(_("%spm"), '7')) . '</option>'
      . '<option value="20" ' 
      . ($day_view_start_time == 20 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '20' : sprintf(_("%spm"), '8')) . '</option>'
      . '<option value="21" ' 
      . ($day_view_start_time == 21 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '21' : sprintf(_("%spm"), '9')) . '</option>'
      . '<option value="22" ' 
      . ($day_view_start_time == 22 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '22' : sprintf(_("%spm"), '10')) . '</option>'
      . '<option value="23" ' 
      . ($day_view_start_time == 23 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '23' : sprintf(_("%spm"), '11')) . '</option>'
      . '</select></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Day View Start Time:") 
      . ' </td><td><select name="day_view_end_time">'
      . '<option value="0" ' 
      . (empty($day_view_end_time) ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '00' : sprintf(_("%sam"), '12')) . '</option>'
      . '<option value="1" ' 
      . ($day_view_end_time == 1 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '01' : sprintf(_("%sam"), '1')) . '</option>'
      . '<option value="2" ' 
      . ($day_view_end_time == 2 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '02' : sprintf(_("%sam"), '2')) . '</option>'
      . '<option value="3" ' 
      . ($day_view_end_time == 3 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '03' : sprintf(_("%sam"), '3')) . '</option>'
      . '<option value="4" ' 
      . ($day_view_end_time == 4 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '04' : sprintf(_("%sam"), '4')) . '</option>'
      . '<option value="5" ' 
      . ($day_view_end_time == 5 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '05' : sprintf(_("%sam"), '5')) . '</option>'
      . '<option value="6" ' 
      . ($day_view_end_time == 6 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '06' : sprintf(_("%sam"), '6')) . '</option>'
      . '<option value="7" ' 
      . ($day_view_end_time == 7 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '07' : sprintf(_("%sam"), '7')) . '</option>'
      . '<option value="8" ' 
      . ($day_view_end_time == 8 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '08' : sprintf(_("%sam"), '8')) . '</option>'
      . '<option value="9" ' 
      . ($day_view_end_time == 9 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '09' : sprintf(_("%sam"), '9')) . '</option>'
      . '<option value="10" ' 
      . ($day_view_end_time == 10 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '10' : sprintf(_("%sam"), '10')) . '</option>'
      . '<option value="11" ' 
      . ($day_view_end_time == 11 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '11' : sprintf(_("%sam"), '11')) . '</option>'
      . '<option value="12" ' 
      . ($day_view_end_time == 12 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '12' : sprintf(_("%spm"), '12')) . '</option>'
      . '<option value="13" ' 
      . ($day_view_end_time == 13 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '13' : sprintf(_("%spm"), '1')) . '</option>'
      . '<option value="14" ' 
      . ($day_view_end_time == 14 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '14' : sprintf(_("%spm"), '2')) . '</option>'
      . '<option value="15" ' 
      . ($day_view_end_time == 15 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '15' : sprintf(_("%spm"), '3')) . '</option>'
      . '<option value="16" ' 
      . ($day_view_end_time == 16 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '16' : sprintf(_("%spm"), '4')) . '</option>'
      . '<option value="17" ' 
      . ($day_view_end_time == 17 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '17' : sprintf(_("%spm"), '5')) . '</option>'
      . '<option value="18" ' 
      . ($day_view_end_time == 18 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '18' : sprintf(_("%spm"), '6')) . '</option>'
      . '<option value="19" ' 
      . ($day_view_end_time == 19 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '19' : sprintf(_("%spm"), '7')) . '</option>'
      . '<option value="20" ' 
      . ($day_view_end_time == 20 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '20' : sprintf(_("%spm"), '8')) . '</option>'
      . '<option value="21" ' 
      . ($day_view_end_time == 21 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '21' : sprintf(_("%spm"), '9')) . '</option>'
      . '<option value="22" ' 
      . ($day_view_end_time == 22 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '22' : sprintf(_("%spm"), '10')) . '</option>'
      . '<option value="23" ' 
      . ($day_view_end_time == 23 ? ' SELECTED' : '')
      . '>' . ($twentyfourHourTime ? '23' : sprintf(_("%spm"), '11')) . '</option>'
      . '</select></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Clock Skew To Remotely Hosted Calendars:") 
      . ' </td><td><select name="external_calendar_clock_skew">'
      . select_option_integer(1, 120, $external_calendar_clock_skew)
      . '</select> Minutes</td></tr>';


   echo '<tr><td align="center" valign="middle" colspan="2" nowrap><br /><strong>'
      . _("Small Calendar") . '</strong></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Small Calendar Under Folder List:") 
      . '</td><td align="left"><input type="radio" name="show_small_calendar" id="show_small_calendarYes" value="1"'
      . ($show_small_calendar ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="show_small_calendarYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="show_small_calendar" id="show_small_calendarNo" value="0"'
      . ($show_small_calendar ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="show_small_calendarNo">' . _("No") . '</label></td></tr>';


   $shared_list = get_all_accessible_calendars($username, $domain);
   $public_list = get_all_public_calendars();
   $external_list = get_all_external_calendars();
   $calList = array_merge($shared_list, $public_list, $external_list);
   usort($calList, 'calendar_sort');
   echo '<tr><td align="right" nowrap>' . _("Small Calendar Source:")
      . ' </td><td><select name="small_calendar_calID">';
   foreach ($calList as $cal)
   {
      $calID = urlencode($cal->getID());
      echo "<option value=\"$calID\""
         . ($calID == $small_calendar_calID ? ' SELECTED' : '')
         . ">" . $cal->getName() . "</option>\n";
   }
   echo '<option value="personal"'
      . ($small_calendar_calID == 'personal' ? ' SELECTED' : '')
      . ">" . _("Personal") . "</option>\n"
      . '</select></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Small Calendar Size:") 
      . ' </td><td><select name="small_calendar_size">'
      . '<option value="" ' 
      . (empty($small_calendar_size) ? ' SELECTED' : '')
      . '>' . _("Default") . '</option>'
      . '<option value="10px" ' 
      . ($small_calendar_size == '10px' ? ' SELECTED' : '')
      . '>' . _("10px") . '</option>'
      . '<option value="12px" ' 
      . ($small_calendar_size == '12px' ? ' SELECTED' : '')
      . '>' . _("12px") . '</option>'
      . '<option value="14px" ' 
      . ($small_calendar_size == '14px' ? ' SELECTED' : '')
      . '>' . _("14px") . '</option>'
      . '<option value="16px" ' 
      . ($small_calendar_size == '16px' ? ' SELECTED' : '')
      . '>' . _("16px") . '</option>'
      . '</select></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Small Calendar Separator:") 
      . ' </td><td><select name="small_calendar_separator">'
      . '<option value="0" ' 
      . (empty($small_calendar_separator) ? ' SELECTED' : '')
      . '>' . _("None") . '</option>'
      . '<option value="1" ' 
      . ($small_calendar_separator == 1 ? ' SELECTED' : '')
      . '>' . _("Horizontal rule") . '</option>'
      . '<option value="2" ' 
      . ($small_calendar_separator == 2 ? ' SELECTED' : '')
      . '>' . _("Box") . '</option>'
      . '</select></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Year Title Above Small Calendar:") 
      . '</td><td align="left"><input type="radio" name="small_calendar_show_year" id="small_calendar_show_yearYes" value="1"'
      . ($small_calendar_show_year ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="small_calendar_show_yearYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="small_calendar_show_year" id="small_calendar_show_yearNo" value="0"'
      . ($small_calendar_show_year ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="small_calendar_show_yearNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Today Link Above Small Calendar:") 
      . '</td><td align="left"><input type="radio" name="small_calendar_show_today_link" id="small_calendar_show_today_linkYes"value="1"'
      . ($small_calendar_show_today_link ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="small_calendar_show_today_linkYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="small_calendar_show_today_link" id="small_calendar_show_today_linkNo" value="0"'
      . ($small_calendar_show_today_link ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="small_calendar_show_today_linkNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Show Day Headers Above Small Calendar:") 
      . '</td><td align="left"><input type="radio" name="small_calendar_show_day_titles" id="small_calendar_show_day_titlesYes" value="1"'
      . ($small_calendar_show_day_titles ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="small_calendar_show_day_titlesYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="small_calendar_show_day_titles" id="small_calendar_show_day_titlesNo" value="0"'
      . ($small_calendar_show_day_titles ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="small_calendar_show_day_titlesNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" valign="middle">' . _("Use Same Background Colors for Days as Regular Calendar:") 
      . '</td><td align="left"><input type="radio" name="small_calendar_inherit_day_background_colors" id="small_calendar_inherit_day_background_colorsYes" value="1"'
      . ($small_calendar_inherit_day_background_colors ? ' CHECKED' : '') 
      . ' />&nbsp;<label for="small_calendar_inherit_day_background_colorsYes">' . _("Yes") . '</label>&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" '
      . 'name="small_calendar_inherit_day_background_colors" id="small_calendar_inherit_day_background_colorsNo" value="0"'
      . ($small_calendar_inherit_day_background_colors ? '' : ' CHECKED') 
      . ' />&nbsp;<label for="small_calendar_inherit_day_background_colorsNo">' . _("No") . '</label></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Header Color:") 
      . ' </td><td><input type="text" name="small_calendar_header_color" size="10" value="'
      . $small_calendar_header_color . '" /></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Today Color:") 
      . ' </td><td><input type="text" name="small_calendar_today_color" size="10" value="'
      . $small_calendar_today_color . '" /></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Event Color:") 
      . ' </td><td><input type="text" name="small_calendar_event_color" size="10" value="'
      . $small_calendar_event_color . '" /></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Day Color:") 
      . ' </td><td><input type="text" name="small_calendar_day_color" size="10" value="'
      . $small_calendar_day_color . '" /></td></tr>';


   echo '<tr><td align="right" nowrap>' . _("Event Text Style:") 
      . ' </td><td><select name="small_calendar_event_italic_style">'
      . '<option value="normal" ' 
      . ($small_calendar_event_italic_style == 'normal' ? ' SELECTED' : '')
      . '>' . _("normal") . '</option>'
      . '<option value="italic" ' 
      . ($small_calendar_event_italic_style == 'italic' ? ' SELECTED' : '')
      . '>' . _("italic") . '</option>'
      . '</select></td></tr>';



   // Color Picker
   //
   //echo '<tr><td colspan="2">&nbsp;</td></tr>';
   echo '<tr><td></td><td width="50%">';

   include_once(SM_PATH . 'plugins/calendar/interface/color.php');

   echo '</td></tr>';
   echo '<tr><td colspan="2">&nbsp;</td></tr>';


?>

              <tr>
                <td align="right" colspan="2">
                  <input type="submit" value="Submit" name="submit_calendar_options" />
                  &nbsp;&nbsp;&nbsp;&nbsp;
                </td>
              </tr>
            </table>
          </form>
        </td>
      </tr>
    </table>
  </td>
</tr>
</table>
</body></html>


<?php


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


}



?>
