<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



/**
  * Inserts small calendar CSS style attributes
  *
  */
function small_calendar_style_do()
{

   global $PHP_SELF, $show_small_calendar, $small_calendar_size,
          $small_calendar_header_color, $small_calendar_today_color,
          $small_calendar_event_italic_style, $small_calendar_event_color,
          $small_calendar_day_color;


   if (!$show_small_calendar)
      return;


   if (strpos($PHP_SELF, 'left_main.php') !== FALSE)
   {
      echo '<style type="text/css">';
      echo "\n<!-- .calendarHeader { font-size: $small_calendar_size; font-weight: bolder; color: $small_calendar_header_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendarToday { font-size: $small_calendar_size; font-weight: bolder; color: $small_calendar_today_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendarEventToday { font-size: $small_calendar_size; font-style: $small_calendar_event_italic_style; font-weight: bolder; color: $small_calendar_event_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendarEvent { font-size: $small_calendar_size; font-style: $small_calendar_event_italic_style; color: $small_calendar_event_color ; } -->\n</style>\n";
      echo '<style type="text/css">';
      echo "\n<!-- .calendar { font-size: $small_calendar_size; color: $small_calendar_day_color ; } -->\n</style>\n";
   }

}



/**
  * Renders miniature calendar
  *
  */
function render_small_calendar_do()
{

   global $username, $domain, $show_small_calendar,
          $small_calendar_calID, $week_start_day;
   include_once(SM_PATH . 'plugins/calendar/functions.php');

   if (!$show_small_calendar)
      return;


   sqgetGlobalVar('year', $year, SQ_FORM);
   sqgetGlobalVar('month', $month, SQ_FORM);
   $now = time();
   $dateArray = getdate($now);
   $todaysYear = $dateArray['year'];
   $todaysMonth = $dateArray['mon'];
   $todaysDay = $dateArray['mday'];



   // make sure we have default day
   // to use for clicking into day view
   //
   if (empty($year) || empty($month) || ($year == $todaysYear && $month == $todaysMonth))
      $day = $todaysDay;
   else
      $day = 1;



   // make sure we have viewing month
   //
   if (empty($year) || empty($month))
   {
      $year = $todaysYear;
      $month = $todaysMonth;
   }


   //
   // get calendar...
   //


   // personal calendar: get ID from backend, then get calendar
   //
   if ($small_calendar_calID == 'personal') 
   {
      $small_calendar_calID = get_personal_cal_id($username, $domain);
      $calendar = get_calendar($small_calendar_calID);
   }
   
   
   // for any other type of calendar, we should check 
   // that user has access rights 
   // 
   else
   {
      $calendar = get_calendar($small_calendar_calID);
      if (!$calendar->canRead($username) && !$calendar->canWrite($username) && !$calendar->isOwner($username))
         return;
   }

   
   
   // show the calendar
   //
   $calendar->showMonth($year, $month, $week_start_day, $username, SM_CAL_VIEW_MODE_MONTH_MINIATURE);


   
}



?>
