<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (c) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage calendar
  *
  */


/**
  * Register this plugin with SquirrelMail 
  *
  */
function squirrelmail_plugin_init_calendar() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['menuline']['calendar']               = 'cal_menu_link';
   $squirrelmail_plugin_hooks['optpage_register_block']['calendar'] = 'cal_options_block';
   $squirrelmail_plugin_hooks['loading_prefs']['calendar']          = 'cal_load_prefs';
   $squirrelmail_plugin_hooks['generic_header']['calendar']         = 'small_calendar_style';
   $squirrelmail_plugin_hooks['left_main_after']['calendar']        = 'render_small_calendar';

}



if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function calendar_version() 
{

   return '2.0';

}



/**
  * Inserts link to calendar module in main menu bar
  *
  */
function cal_menu_link() 
{

   include_once(SM_PATH . 'plugins/calendar/functions.php');
   cal_menu_link_do();

}



/**
  * Inserts link to calendar admin module and user settings 
  * page in options page
  *
  */
function cal_options_block() 
{

   include_once(SM_PATH . 'plugins/calendar/functions.php');
   cal_options_block_do();

}



/**
  * Loads all calendar user preferences
  *
  */
function cal_load_prefs() 
{

   include_once(SM_PATH . 'plugins/calendar/functions.php');
   cal_load_prefs_do();

}



/**
  * Renders miniature calendar
  *
  */
function render_small_calendar() 
{

   include_once(SM_PATH . 'plugins/calendar/small_calendar.php');
   render_small_calendar_do();

}



/**
  * Inserts small calendar CSS style attributes
  *
  */
function small_calendar_style() 
{

   include_once(SM_PATH . 'plugins/calendar/small_calendar.php');
   small_calendar_style_do();

}



?>
