<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Displays page header for calendar month view
  *
  * @param object $calendar The calendar being viewed
  * @param int $yesr The year of the month to be shown
  * @param int $month The month to be shown
  * @param int $startDay The day of the week for first display column (0=Sunday, 6=Saturday)
  * @param string $viewType The type of month view to be shown, which
  *                         should correspond to the MONTH view mode
  *                         constants defined in {@link constants.php}
  *                         (optional; default is normal month view mode)
  *
  */
function showMonthViewHeader($calendar, $year, $month, $startDay=0, $viewType=SM_CAL_VIEW_MODE_MONTH)
{

   global $color, $data_dir, $username, $calendar_theme;

   $prev_date = mktime(0, 0, 0, $month - 1, 1, $year);
   $act_date  = mktime(0, 0, 0, $month, 1, $year);
   $next_date = mktime(0, 0, 0, $month + 1, 1, $year);
   $prev_month = date('n', $prev_date );
   $next_month = date('n', $next_date);
   $prev_year = date('Y', $prev_date);
   $next_year = date('Y', $next_date );


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   // normal (month view) header...
   //
   if ($viewType == SM_CAL_VIEW_MODE_MONTH)
   {

      $self = 'month.php';

      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag('tr', "\n"
         . html_tag('th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) . "&year=" . ($year - 1) . "&month=$month\">&lt;&lt;&nbsp;" . ($year - 1) . "</a>") . "\n"
         . html_tag('th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) . "&year=$prev_year&month=$prev_month\">&lt;&nbsp;"
         . date_intl('M', $prev_date) . "</a>") . "\n"
         . html_tag('th', '<a name="month' . $month . '">' . date_intl( 'F Y', $act_date ) 
         . ($calendar->isOwner($username) || $calendar->canWrite($username)
         ? '</a> <a href="event_manage.php?calID=' . urlencode($calendar->getID()) 
         . "&year=$year&month=$month&calAction=" . SM_CAL_EVENT_ACTION_ADD 
         . "\"><img src=\"images/new.png\" border=\"0\"></a>" : ''),
           '', $calendar_theme['month_view_title_background'], '')
         . html_tag('th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) 
         . "&year=$next_year&month=$next_month\">"
         . date_intl('M', $next_date) . "&nbsp;&gt;</a>") . "\n"
         . html_tag( 'th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) . "&year=" 
         . ($year + 1) . "&month=$month\">" . ($year + 1) . "&nbsp;&gt;&gt;</a>")) . "\n"
         . '</table>';

   }



   // year view header
   //
   else if ($viewType == SM_CAL_VIEW_MODE_ALL_MONTHS && $month == 1)
   {

      $self = 'year.php';

      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag('tr', "\n"
         . html_tag('th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) . "&year=" . ($year - 1) . "&month=$month\">&lt;&lt;&nbsp;" . ($year - 1) . "</a>") . "\n"
         . html_tag('th', '<a name="month' . $month . '"><a href="month.php?calID='
         . urlencode($calendar->getID()) . "&year=$year&month=$month\">" 
         . date_intl( 'F Y', $act_date ) . '</a></a>'
         . ($calendar->isOwner($username) || $calendar->canWrite($username)
         ? '<a href="event_manage.php?calID=' 
         . urlencode($calendar->getID()) 
         . "&year=$year&month=$month&calAction=" . SM_CAL_EVENT_ACTION_ADD 
         . "\"><img src=\"images/new.png\" border=\"0\"></a>" : ''), 
           '', $calendar_theme['month_view_title_background'], '')
         . html_tag( 'th', "<a href=\"$self?calID=" . urlencode($calendar->getID()) . "&year=" . ($year + 1) . "&month=$month\">" . ($year + 1) . "&nbsp;&gt;&gt;</a>")) . "\n"
         . '</table>';

   }


   // abbreviated header...
   //
   else if ($viewType == SM_CAL_VIEW_MODE_ALL_MONTHS)
   {

      $self = 'year.php';

      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag('tr', "\n"
         . html_tag('th', '<a name="month' . $month . '"><a href="month.php?calID='
         . urlencode($calendar->getID()) . "&year=$year&month=$month\">" 
         . date_intl( 'F Y', $act_date ) . '</a></a>'
         . ($calendar->isOwner($username) || $calendar->canWrite($username)
         ? ' <a href="event_manage.php?calID=' 
         . urlencode($calendar->getID()) 
         . "&year=$year&month=$month&calAction=" . SM_CAL_EVENT_ACTION_ADD 
         . "\"><img src=\"images/new.png\" border=\"0\"></a>" : ''), 
           '', $calendar_theme['month_view_title_background'], ''))
         . '</table>';

   }


   // miniature header...
   //
   else if ($viewType == SM_CAL_VIEW_MODE_MONTH_MINIATURE)
   {

      global $small_calendar_separator, $small_calendar_show_year, 
             $small_calendar_show_today_link;

      if ($small_calendar_show_year)
         $header = date_intl('F Y', $act_date);
      else
         $header = date_intl('F', $act_date);


      // separator types
      //
      if ($small_calendar_separator == 1)
      {
         echo "<br /><hr width='100%' />\n"
            . "<table class=\"calendar\">\n";
      }
      else if ($small_calendar_separator == 2)
      {

         echo "<br /><table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" bgcolor=\"" 
            . $color[9] . "\">\n<tr>\n<td>\n"
            . "<table class=\"calendar\" width=\"100%\" cellpadding=\"2\" cellspacing=\"1\" border=\"0\" bgcolor=\"" 
            . $color[4] . "\">\n";

      }
      else
      {
         echo "<br /><table class=\"calendar\">\n";
      }


      global $PHP_SELF;
      $php_self = substr($PHP_SELF, 0, strpos($PHP_SELF, '.php') + 4);
      $prevMonth = $php_self . "?month=$prev_month&year=$prev_year";
      $nextMonth = $php_self . "?month=$next_month&year=$next_year";
      $monthLink = SM_PATH . "plugins/calendar/month.php?month=$month&year=$year&calID=" 
                 . urlencode($calendar->getID());
      $now = time();
      $dateInfo = getdate($now);
      $todaysDay = $dateInfo['mday'];


      // now the actual header
      //
      echo ($small_calendar_show_today_link ? "<tr><td align=\"center\" valign=\"top\" class=\"calendarHeader\" colspan=\"7\"><a style=\"text-decoration:none\" target=\"right\" href=\"$monthLink&day=$todaysDay\">" . _("Today") . "</a></td></tr>\n" : '')
         . "<tr>\n"
         . "<td align=\"center\" valign=\"top\"><a href=\"$prevMonth\">&lt;&lt;</a></td>\n"
         . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\" colspan=\"5\"><a style=\"text-decoration:none\" target=\"right\" class=\"calendarHeader\" href=\"$monthLink\">$header</a></td>\n"
         . "<td align=\"center\" valign=\"top\"><a href=\"$nextMonth\">&gt;&gt;</a></td>\n"
         . "</tr>\n";
 
   }


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


}


/**
  * Displays one month view of the given calendar
  *
  * @param object $calendar The calendar being viewed
  * @param int $yesr The year of the month to be shown
  * @param int $month The month to be shown
  * @param int $startDay The day of the week for first display column (0=Sunday, 6=Saturday)
  * @param string $user The user for which the calendar is being displayed
  * @param string $viewType The type of month view to be shown, which
  *                         should correspond to the MONTH view mode
  *                         constants defined in {@link constants.php}
  *                         (optional; default is normal month view mode)
  *
  */
function showCalendarMonth(&$calendar, $year, $month, $startDay=0, $user, $viewType=SM_CAL_VIEW_MODE_MONTH)
{

   $forYearView = ($viewType == SM_CAL_VIEW_MODE_ALL_MONTHS);

   showMonthViewHeader($calendar, $year, $month, $startDay, $viewType);


   global $username, $data_dir, $color, $max_events_per_day_on_month_view, 
          $calendar_theme, $show_week_numbers_in_month_view_override, 
          $twentyfourHourTime, $highlight_threshold, $month_view_show_event_start_time,
          $month_view_show_daily_add_buttons;


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   if ($show_week_numbers_in_month_view_override == 1)
      $show_week_numbers_in_month_view = 1;
   else if ($show_week_numbers_in_month_view_override == -1)
      $show_week_numbers_in_month_view = 0;
   else if ($show_week_numbers_in_month_view_override == 0)
      $show_week_numbers_in_month_view = 0;


   $tuitachi = mktime(0, 0, 0, $month, 1, $year);
   $aDay = 1 - date('w', $tuitachi) + $startDay;
   while ($aDay > 1) $aDay -= 7;
   $daysInMonth = date('t', $tuitachi);
   $today = getdate(time());
   $today = mktime(0, 0, 0, $today['mon'], $today['mday'], $today['year']);


   $shortDayNames = explode(' ', _("S M T W T F S"));
   $longDayNames = array(_("Sunday"), _("Monday"), _("Tuesday"), _("Wednesday"), 
                         _("Thursday"), _("Friday"), _("Saturday"));


   if ($viewType == SM_CAL_VIEW_MODE_MONTH_MINIATURE) 
   {

      global $small_calendar_show_day_titles;

      if ($small_calendar_show_day_titles)
         echo "<tr>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[$startDay % 7] . "</td>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[($startDay + 1) % 7] . "</td>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[($startDay + 2) % 7] . "</td>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[($startDay + 3) % 7] . "</td>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[($startDay + 4) % 7] . "</td>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[($startDay + 5) % 7] . "</td>\n"
            . "<td align=\"center\" valign=\"top\" class=\"calendarHeader\">" 
            . $shortDayNames[($startDay + 6) % 7] . "</td>\n"
            . "</tr>\n";
   }

   else
   {
      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 
           'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag( 'tr', ($show_week_numbers_in_month_view
         ? html_tag( 'th', '&nbsp;', '', $calendar_theme['month_view_title_background'], '') 
         : '')
         . html_tag( 'th', $longDayNames[$startDay % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
         . html_tag( 'th', $longDayNames[($startDay + 1) % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
         . html_tag( 'th', $longDayNames[($startDay + 2) % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
         . html_tag( 'th', $longDayNames[($startDay + 3) % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
         . html_tag( 'th', $longDayNames[($startDay + 4) % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
         . html_tag( 'th', $longDayNames[($startDay + 5) % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n" 
         . html_tag( 'th', $longDayNames[($startDay + 6) % 7], '', 
           $calendar_theme['month_view_day_header'], 'width="14%"' ) . "\n");
   }


   while ($aDay <= $daysInMonth) 
   {

      $theDay = mktime(0, 0, 0, $month, $aDay, $year);

      echo html_tag('tr')
         . ($show_week_numbers_in_month_view && $viewType != SM_CAL_VIEW_MODE_MONTH_MINIATURE
         ? html_tag('td', '<small>W' . date_intl('W', $theDay) . '</small>', '', $calendar_theme['month_view_day_background'], '')
         : '');


      // iterate on a weekly basis
      //
      for ($dayOfWeek = 1; $dayOfWeek <= 7; $dayOfWeek++) 
      {

         $theDay = mktime(0, 0, 0, $month, $aDay, $year);


         // is this a day that is in this month?
         //
         if ($aDay <= $daysInMonth && $aDay > 0)
         {

//TODO: some day maybe we want to support more than one holiday falling on the same day...
            $holiday = '';
            $holidays = $calendar->getHolidaysForDay($year, $month, $aDay, $user);
            if (!empty($holidays))
            {
               $holiday = $holidays[0];
               $dayColor = $calendar_theme['month_view_holiday_background'];
            }
            else if (($dayOfWeek + $startDay) % 7 == 1 || ($dayOfWeek + $startDay) % 7 == 0)
               $dayColor = $calendar_theme['month_view_weekend_background'];
            else
               $dayColor = $calendar_theme['month_view_day_background'];


            if ($viewType != SM_CAL_VIEW_MODE_MONTH_MINIATURE)
            {
               echo html_tag('td', '', 'left', $dayColor, 'height="50" valign="top"') ."\n"
                  . html_tag('div', '', 'right')
                  . "<small>";

               if (!empty($holiday))
                  echo "<a href=\"#month" . $month . "\" style=\"text-decoration:none; color: "
                     . $calendar_theme['month_view_holiday_text'] . "\" title=\"" 
                     . cal_encode_output($holiday->getDescription(), FALSE) 
                     . "\">[ " . cal_encode_output($holiday->getTitle(), FALSE) . " ]</a> ";

               if ($theDay == $today) 
                  echo "<span style=\"color:" . $calendar_theme['month_view_today_text'] 
                     . "\">[ " . _("TODAY") . " ]</span> ";

               echo "<a href=\"day.php?calID=" . urlencode($calendar->getID()) . "&year=$year&month=$month&day="
                  . "$aDay\">$aDay</a></small>"
                  . ($month_view_show_daily_add_buttons
                  ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
                  . "&year=$year&month=$month&day=$aDay&calAction=" . SM_CAL_EVENT_ACTION_ADD
                  . '"><img src="images/new.png" border="0"></a>' : '')
                  .'</div>';
// uncomment for help debugging:
//echo mktime(0, 0, 0, $month, $aDay, $year);
            }



            // get events for today, which are displayed below
            //
            $events = $calendar->getEventsForDay($year, $month, $aDay, $user);
            $eventLink = "<a href=\"day.php?calID=" . urlencode($calendar->getID()) 
                       . "&year=$year&month=$month&day=" . $aDay;



            // miniature calendar view -- just show day number 
            // and jump to next loop iteration
            //
            if ($viewType == SM_CAL_VIEW_MODE_MONTH_MINIATURE)
            {
               if (!empty($events) && $theDay == $today)
                  $class = 'calendarEventToday';
               else if (!empty($events))
                  $class = 'calendarEvent';
               else if ($theDay == $today) 
                  $class = 'calendarToday';
               else
                  $class = 'calendar';

               global $small_calendar_inherit_day_background_colors;
               echo html_tag('td', '', 'right', ($small_calendar_inherit_day_background_colors ? $dayColor : ''), "class=\"$class\" valign=\"top\"")
                  . "<a href=\"" . SM_PATH . "plugins/calendar/day.php?calID=" 
                  . urlencode($calendar->getID()) 
                  . "&year=$year&month=$month&day=$aDay\" target=\"right\" class=\"$class\">$aDay</a>"
                  . "\n</td>\n";
               $aDay++;
               continue;
            }

         } 



         // days that are not in this month (before/after first/last day of month)
         //
         else 
         {

            // show events before/after this month in some cases
            //
            if ($viewType != SM_CAL_VIEW_MODE_MONTH_MINIATURE 
             && (!$forYearView || ($month == 1 && $aDay < 1) 
             || ($month == 12 && $aDay > $daysInMonth)))
            {

//TODO: some day maybe we want to support more than one holiday falling on the same day...
               $holiday = '';
               $holidays = $calendar->getHolidaysForDay($year, $month, $aDay, $user);
               if (!empty($holidays))
               {
                  $holiday = $holidays[0];
                  $dayColor = $calendar_theme['month_view_non_month_holiday_background'];
               }
               else if (($dayOfWeek + $startDay) % 7 == 1 || ($dayOfWeek + $startDay) % 7 == 0)
                  $dayColor = $calendar_theme['month_view_non_month_weekend_background'];
               else
                  $dayColor = $calendar_theme['month_view_non_month_day_background'];


               $otherMonthDayInfo = getdate($theDay);

               echo html_tag( 'td', '', 'left', $color[4], 'height="50" valign="top"') 
                  . html_tag('table', '', '', $dayColor, 'height="100%" width="100%" border="0" cellpadding="1" cellspacing="1"')
                  . html_tag('tr') . "\n" 
                  . html_tag('td', '', '', '', 'valign="top"') . "\n" 
                  . html_tag('div', '', 'right')
                  . "<small>";


               if (!empty($holiday))
                  echo "<a href=\"#month" . $month . "\" style=\"text-decoration:none; color: "
                     . $calendar_theme['month_view_holiday_text'] . "\" title=\"" 
                     . cal_encode_output($holiday->getDescription(), FALSE) 
                     . "\">[ " . cal_encode_output($holiday->getTitle()) . " ]</a> ";


               echo "<a href=\"day.php?calID=" . urlencode($calendar->getID()) . '&year='
                  . $otherMonthDayInfo['year'] . "&month=" . $otherMonthDayInfo['mon'] . '&day='
                  . $otherMonthDayInfo['mday'] . "\">"
                  . (($dayOfWeek == 1 || $otherMonthDayInfo['mday'] == 1) 
                  ? _($otherMonthDayInfo['month']) . ' ' : '')
                  . $otherMonthDayInfo['mday']
                  . '</a></small>'
                  . ($month_view_show_daily_add_buttons
                  ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
                  . '&year=' . $otherMonthDayInfo['year'] 
                  . '&month=' . $otherMonthDayInfo['mon'] 
                  . '&day=' . $otherMonthDayInfo['mday'] 
                  . '&calAction=' . SM_CAL_EVENT_ACTION_ADD
                  . '"><img src="images/new.png" border="0"></a>' : '')
                  .'</div>';



               // get events for today, which are displayed below
               //
               $events = $calendar->getEventsForDay($otherMonthDayInfo['year'], 
                                                    $otherMonthDayInfo['mon'], 
                                                    $otherMonthDayInfo['mday'], $user);
               $eventLink = "<a href=\"day.php?calID=" . urlencode($calendar->getID()) 
                          . "&year=" . $otherMonthDayInfo['year'] . "&month="
                          . $otherMonthDayInfo['mon'] . "&day=" . $otherMonthDayInfo['mday'];
   
            }


            // don't show events, just blank space
            //
            else
            {

               if ($viewType == SM_CAL_VIEW_MODE_MONTH_MINIATURE)
               {
                  echo html_tag('td', '&nbsp;');
                  $aDay++;
                  continue;
               }

               echo html_tag('td', '', '', $calendar_theme['month_view_title_background'], '') . '&nbsp;';
               $events = array();

            }

         }


         // show any events for the current day
         //
         $count = 0;
         foreach ($events as $event)
         {
            
//LEFT OFF HERE -- perhaps we need some indication that there are more events if we go over this max #
            if (++$count > $max_events_per_day_on_month_view)
               break;

            $title = cal_encode_output($event->getTitle()) . ' ' 
                   . buildEventTimeDisplayText($event, $year, $month, $aDay) . "\n" 
                   . cal_encode_output($event->getDescription(), FALSE);

//            echo '&middot;<small>' . $eventLink . '#' . $event->getID() . '" '
            echo '<small>' . $eventLink . '#' . $event->getID() . '" '

               . (($event->getPriority() <= $highlight_threshold) 
               ? "style=\"text-decoration:none; color: " 
               . $calendar_theme['month_view_event_text_urgent'] . "\" title=\"" . $title . "\""
               : "style=\"text-decoration:none; color: " 
               . $calendar_theme['month_view_event_text_normal'] . "\" title=\"" . $title . "\"")

               . '>' . ($month_view_show_event_start_time && !$event->isAllDay() 
               ? $event->formattedStartTime($twentyfourHourTime ? 'H:i' : 'g:ia') . ': ' 
               : '&middot;') . $event->getTitle() . "</a><br></small>\n";
//               : '&ordm;') . $event->getTitle() . "</a><br></small>\n";
//               : '&raquo;') . $event->getTitle() . "</a><br></small>\n";
//               : '&times;') . $event->getTitle() . "</a><br></small>\n";
//               : '') . $event->getTitle() . "</a><br></small>\n";

         }


         // close extra table when showing events before/after this month
         //
         if ((!$forYearView && !($aDay <= $daysInMonth && $aDay > 0))
          || ($forYearView && (($month == 1 && $aDay < 1) || ($month == 12 && $aDay > $daysInMonth))))
            echo "</td></tr></table>";


         echo "\n</td>\n";
         $aDay++;

      }

      echo '</tr>';

   }

   echo '</table>';


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');


   showMonthViewFooter($calendar, $year, $month, $viewType);

}



/**
  * Displays page footer for calendar month view
  *
  * @param object $calendar The calendar being viewed
  * @param int $yesr The year of the month to be shown
  * @param int $month The month to be shown
  * @param string $viewType The type of month view to be shown, which
  *                         should correspond to the MONTH view mode
  *                         constants defined in {@link constants.php}
  *                         (optional; default is normal month view mode)
  *
  */
function showMonthViewFooter($calendar, $year, $month, $viewType=SM_CAL_VIEW_MODE_MONTH)
{

   global $color, $username, $domain, $data_dir, $calendar_theme;


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');


   $external_list = get_all_external_calendars();
   $shared_list = get_all_accessible_calendars($username, $domain);
   $public_list = get_all_public_calendars();
   $calList = array_merge($shared_list, $public_list, $external_list);
   usort($calList, 'calendar_sort');


   // normal (month view) footer
   //
   if ($viewType == SM_CAL_VIEW_MODE_MONTH)
   {

      echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
         . html_tag('tr') ."\n" 
         . html_tag('td', '', 'left', '', '') ."\n" 
         . "<form name=\"caljump\" action=\"month.php\" method=\"POST\">\n"
         . "<select name=\"year\">\n"
         . select_option_year($year)
         . "          </select>\n"
         . "          <select name=\"month\">\n"
         . select_option_month($month)
         . "          </select>\n"
         . '         <input type="submit" value="' . _("Go") . "\">\n"
         . "         <input type=\"hidden\" name=\"calID\" value=\"" . urlencode($calendar->getID()) . "\">\n"
         . "          </form>\n"
         . "          </td>\n"
         . html_tag('td', '', 'center', '', 'valign="top"')
         . ($calendar->isOwner($username) || $calendar->canWrite($username)
         ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
         . "&year=$year&month=$month&calAction=" . SM_CAL_EVENT_ACTION_ADD . '">'
         . _("Add Event") . '</a>' : '') . '</td>'
         . html_tag('td', '', 'right', '', '')
         . "\n<form name=\"calswitch\"><select name=\"calselect\">\n";


      foreach ($calList as $cal)
      {
         $calID = urlencode($cal->getID());
         echo "<option value=\"month.php?year=$year&month=$month&calID=$calID\""
            . ($cal->getID() == $calendar->getID() ? ' SELECTED' : '')
            . ">" . $cal->getName() . "</option>\n";
      }


      echo "<option value=\"month.php?year=$year&month=$month&calID=personal\""
         . ($calendar->getID() == get_personal_cal_id($username, $domain) ? ' SELECTED' : '')
         . ">" . _("Personal") . "</option>\n"
         . "          </select>\n"
         . '          <input type="button" value="' . _("Go") . '" onClick="' 
         . 'for (i=0;i<document.calswitch.calselect.length;i++){ ' 
         . 'if (document.calswitch.calselect.options[i].selected) ' 
         . 'dest=document.calswitch.calselect.options[i].value;} ' 
         . 'location.href=dest;">' . "\n";
      echo "          </form></td></tr>\n".
           "</table>\n";

   }


   // year view footer
   //
   else if ($viewType == SM_CAL_VIEW_MODE_ALL_MONTHS)
   {

      if ($month == 12)
      {

         echo html_tag('table', '', '', $calendar_theme['month_view_title_background'], 'width="100%" border="0" cellpadding="2" cellspacing="1"')
            . html_tag('tr') ."\n"
            . html_tag('td', '', 'left', '', '') ."\n"
            . "<form name=\"caljump\" action=\"year.php\" method=\"POST\">\n"
            . "<select name=\"year\">\n"
            . select_option_year($year)
            . "          </select>\n"
            . '         <input type="submit" value="' . _("Go") . "\">\n"
            . "         <input type=\"hidden\" name=\"calID\" value=\"" . urlencode($calendar->getID()) . "\">\n"
            . "          </form>\n"
            . "          </td>\n"
            . html_tag('td', '', 'center', '', 'valign="top"')
            . ($calendar->isOwner($username) || $calendar->canWrite($username)
            ? '<a href="event_manage.php?calID=' . urlencode($calendar->getID())
            . "&year=$year&month=$month&calAction=" . SM_CAL_EVENT_ACTION_ADD . '">'
            . _("Add Event") . '</a>' : '') . '</td>'
            . html_tag('td', '', 'right', '', '')
            . "\n<form name=\"calswitch\"><select name=\"calselect\">\n";


         foreach ($calList as $cal)
         {
            $calID = urlencode($cal->getID());
            echo "<option value=\"year.php?year=$year&calID=$calID\""
               . ($cal->getID() == $calendar->getID() ? ' SELECTED' : '')
               . ">" . $cal->getName() . "</option>\n";
         }
   
   
         echo "<option value=\"year.php?year=$year&calID=personal\""
            . ($calendar->getID() == get_personal_cal_id($username, $domain) ? ' SELECTED' : '')
            . ">" . _("Personal") . "</option>\n"
            . "          </select>\n"
            . '          <input type="button" value="' . _("Go") . '" onClick="'
            . 'for (i=0;i<document.calswitch.calselect.length;i++){ '
            . 'if (document.calswitch.calselect.options[i].selected) '
            . 'dest=document.calswitch.calselect.options[i].value;} '
            . 'location.href=dest;">' . "\n";
         echo "          </form></td></tr>\n".
              "</table>\n";

      }

      else
      {

         echo '<br />';

      }

   }


   // miniature cal... not much of a footer...
   //
   if ($viewType == SM_CAL_VIEW_MODE_MONTH_MINIATURE) 
   {

      global $small_calendar_separator;

      if ($small_calendar_separator == 2)
         echo "</td></tr>\n</table>\n";

   }


   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



?>
