<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Calendar constants: user types
  *
  */
define('SM_CAL_SUPERUSER',     'superuser');
define('SM_CAL_LIMITED_ADMIN', 'limitedadmin');
define('SM_CAL_REGULAR_USER',  'regularuser');



/**
  * Calendar constants: administrative options
  *
  */
define('SM_CAL_EDIT_USERS',     'editusers');
define('SM_CAL_EDIT_CALENDARS', 'editcalendars');
define('SM_CAL_EDIT_HOLIDAYS',  'editholidays');



/**
  * Calendar constants: calendar types
  *
  */
define('SM_CAL_TYPE_PERSONAL', 'personalcalendar');
define('SM_CAL_TYPE_SHARED',   'sharedcalendar');
define('SM_CAL_TYPE_PUBLIC',   'publiccalendar');



/**
  * Calendar constants: user access levels
  *
  */
define('SM_CAL_ACCESS_LEVEL_OWNER', 'owner');
define('SM_CAL_ACCESS_LEVEL_READ',  'read');
define('SM_CAL_ACCESS_LEVEL_WRITE', 'write');



/**
  * Calendar constants: view modes
  *
  */
define('SM_CAL_VIEW_MODE_YEAR',            'year');
define('SM_CAL_VIEW_MODE_ALL_MONTHS',      'allmonths');
define('SM_CAL_VIEW_MODE_MONTH',           'month');
define('SM_CAL_VIEW_MODE_MONTH_MINIATURE', 'miniaturemonth');
define('SM_CAL_VIEW_MODE_MONTH_HELPER',    'minimonth');
define('SM_CAL_VIEW_MODE_WEEK',            'week');
define('SM_CAL_VIEW_MODE_WORK_WEEK',       'workweek');
define('SM_CAL_VIEW_MODE_DAY',             'day');
define('SM_CAL_VIEW_MODE_TODO',            'todo');



/**
  * Calendar constants: event management actions
  *
  */
define('SM_CAL_EVENT_ACTION_ADD',            'addevent');
define('SM_CAL_EVENT_ACTION_CREATE',         'createevent');
define('SM_CAL_EVENT_ACTION_EDIT',           'editevent');
define('SM_CAL_EVENT_ACTION_UPDATE',         'updateevent');
define('SM_CAL_EVENT_ACTION_DELETE',         'deleteevent');
define('SM_CAL_EVENT_ACTION_DELETE_CONFIRM', 'confirmdeleteevent');
define('SM_CAL_EVENT_ACTION_REMOVE',         'removeevent');



/**
  * Calendar constants: event types
  *
  */
define('SM_EVENT_TYPE_EVENT', 'VEVENT');
define('SM_EVENT_TYPE_TODO', 'VTODO');



/**
  * Calendar constants: event statuses
  *
  */
define('SM_EVENT_STATUS_TENTATIVE', 'TENTATIVE');
define('SM_EVENT_STATUS_CONFIRMED', 'CONFIRMED');
define('SM_EVENT_STATUS_CANCELLED', 'CANCELLED');



/**
  * Calendar constants: todo statuses
  *
  */
define('SM_TODO_STATUS_NEEDS_ACTION', 'NEEDS-ACTION');
define('SM_TODO_STATUS_COMPLETED', 'COMPLETED');
define('SM_TODO_STATUS_IN_PROCESS', 'IN-PROCESS');
define('SM_TODO_STATUS_CANCELLED', 'CANCELLED');



/**
  * Calendar constants: date past which recurring events
  * should not recur, in case we get any runaway events
  *
  * Timestamp for January 1, 2038: 2145945600
  *
  */
define('MAX_RECURRENCE_DATE', 2145945600);



/**
  * Calendar constants: weekday constants
  *
  */
global $WEEKDAYS;
define('SU', 0);
define('MO', 1);
define('TU', 2);
define('WE', 3);
define('TH', 4);
define('FR', 5);
define('SA', 6);
// note these keys are strings, not the above defined constants!
$WEEKDAYS = array('SU' => 0, 'MO' => 1, 'TU' => 2, 'WE' => 3, 'TH' => 4, 'FR' => 5, 'SA' => 6);



/**
  * Calendar constants: event priorities
  *
  */
global $EVENT_PRIORITIES;
define('SM_CAL_EVENT_PRIORITY_UNKNOWN',       0);
define('SM_CAL_EVENT_PRIORITY_EMERGENCY',     1);
define('SM_CAL_EVENT_PRIORITY_URGENT',        2);
define('SM_CAL_EVENT_PRIORITY_SERIOUS',       3);
define('SM_CAL_EVENT_PRIORITY_IMPORTANT',     4);
define('SM_CAL_EVENT_PRIORITY_NORMAL',        5);
define('SM_CAL_EVENT_PRIORITY_SECONDARY',     6);
define('SM_CAL_EVENT_PRIORITY_LOW',           7);
define('SM_CAL_EVENT_PRIORITY_INSIGNIFICANT', 8);
define('SM_CAL_EVENT_PRIORITY_IGNORE',        9);
$EVENT_PRIORITIES = array(
   SM_CAL_EVENT_PRIORITY_UNKNOWN       => _("Unknown"),
   SM_CAL_EVENT_PRIORITY_EMERGENCY     => _("Emergency"),
   SM_CAL_EVENT_PRIORITY_URGENT        => _("Urgent"),
   SM_CAL_EVENT_PRIORITY_SERIOUS       => _("Serious"),
   SM_CAL_EVENT_PRIORITY_IMPORTANT     => _("Important"),
   SM_CAL_EVENT_PRIORITY_NORMAL        => _("Normal"),
   SM_CAL_EVENT_PRIORITY_SECONDARY     => _("Secondary"),
   SM_CAL_EVENT_PRIORITY_LOW           => _("Low"),
   SM_CAL_EVENT_PRIORITY_INSIGNIFICANT => _("Insignificant"),
   SM_CAL_EVENT_PRIORITY_IGNORE        => _("Ignore"),
);



/**
  * Calendar constants: number of seconds in a...
  *
  */
define('SM_CAL_DAY_SECONDS',   86400);
define('SM_CAL_WEEK_SECONDS',  604800);



/**
  * iCal constants
  *
  */
define('ICAL_LINE_DELIM', "\015\012");
define('SM_CAL_PRODID', '-//SquirrelMail//NONSGML SquirrelMail Calendar Plugin V###VERSION###//EN');
define('SM_CAL_ICAL_PROPERTY_TYPE_TEXT',           'TEXT');
define('SM_CAL_ICAL_PROPERTY_TYPE_DATE',           'DATE');
define('SM_CAL_ICAL_PROPERTY_TYPE_DATETIME_LOCAL', 'DATE-TIME-LOCAL');
define('SM_CAL_ICAL_PROPERTY_TYPE_DATETIME_UTC',   'DATE-TIME-UTC');
define('SM_CAL_ICAL_PROPERTY_TYPE_DATETIME_TZ',    'DATE-TIME-TIME-ZONE');
define('SM_CAL_ICAL_PROPERTY_TYPE_BINARY',         'BINARY');
define('SM_CAL_ICAL_PROPERTY_TYPE_BOOLEAN',        'BOOLEAN');
define('SM_CAL_ICAL_PROPERTY_TYPE_CAL_ADDRESS',    'CAL-ADDRESS');
define('SM_CAL_ICAL_PROPERTY_TYPE_DURATION',       'DURATION');
define('SM_CAL_ICAL_PROPERTY_TYPE_FLOAT',          'FLOAT');
define('SM_CAL_ICAL_PROPERTY_TYPE_INT',            'INTEGER');
define('SM_CAL_ICAL_PROPERTY_TYPE_PERIOD',         'PERIOD');
define('SM_CAL_ICAL_PROPERTY_TYPE_RRULE',          'RECUR');
define('SM_CAL_ICAL_PROPERTY_TYPE_TIME_LOCAL',     'TIME-LOCAL');
define('SM_CAL_ICAL_PROPERTY_TYPE_TIME_UTC',       'TIME-UTC');
define('SM_CAL_ICAL_PROPERTY_TYPE_TIME_TZ',        'TIME-TIME-ZONE');
define('SM_CAL_ICAL_PROPERTY_TYPE_URI',            'URI');
define('SM_CAL_ICAL_PROPERTY_TYPE_UTC_OFFSET',     'UTC-OFFSET');



/**
  * iCal constants: event recurrence types
  *
  */
global $RECURRENCE_TYPES;
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_SECONDLY', 'SECONDLY');
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_MINUTELY', 'MINUTELY');
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_HOURLY', 'HOURLY');
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_DAILY', 'DAILY');
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_WEEKLY', 'WEEKLY');
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_MONTHLY', 'MONTHLY');
define('SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_YEARLY', 'YEARLY');
$RECURRENCE_TYPES = array(
   SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_DAILY   => _("Days"),
   SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_WEEKLY  => _("Weeks"),
   SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_MONTHLY => _("Months"),
   SM_CAL_ICAL_EVENT_RECURRENCE_FREQ_YEARLY  => _("Years"),
);






?>
