<?php

/**
  * SquirrelMail Shared Calendar Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Presents the user with the main administrative menu
  *
  * @param array $color Standard SquirrelMail colors array
  *
  */
function display_main_admin_interface($color) 
{

   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   if (!isset($color[12])) $color[12] = '';
   echo "<center>\n"
      . "<table width=\"80%\" bgcolor=\"" . $color[9] . "\"><tr><td align=\"center\">\n"
      . "<b>" . _("Calendar Setup") . "</b></td></tr><tr><td>\n"
      . "<table width=\"100%\" bgcolor=\"" . $color[9] . "\" cellpadding=\"3\">\n"
      . "<tr width=\"50%\" bgcolor=\"" . $color[12] . "\"><td>\n"
      . _("Create shared access calendars for select users\n or public calendars for all users.\n")
      . "</td><td width=\"50%\">\n"
      . _("Manage user permissions for your shared calendars.\n")
      . "</td></tr><tr><td align=\"center\">\n"
      . "<form action=\"admin_options.php\" method=\"post\">\n"
      . "<input type=\"submit\" value=\"" . _("Calendars") . "\" />\n"
      . '<input type="hidden" name="cal_action" value="' . SM_CAL_EDIT_CALENDARS . "\" />\n"
      . "</form>\n"
      . "</td><td align=\"center\">\n"
      . "<form action=\"admin_options.php\" method=\"post\">\n"
      . "<input type=\"submit\" value=\"" . _("Users") . "\" />\n"
      . '<input type="hidden" name="cal_action" value="' . SM_CAL_EDIT_USERS . "\" />\n"
      . "</form>\n"
      . "</td></tr></table>"
      . "</td></tr></table>\n"
      . "</center>\n";

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Presents the user with an interface to create and
  * maintain edit shared calendars
  *
  * @param array $color Standard SquirrelMail colors array
  * @param array $calList A list of all the calendars that
  *                       the current user has administrative
  *                       privileges against (array of 
  *                       Calendar objects)
  *
  */
function display_calendar_admin_interface($color, $calList) 
{

   // split calendar list into shared and public lists
   //
   $sharedList = array();
   $publicList = array();
   foreach ($calList as $calendar)
      if ($calendar->getCalendarType() == SM_CAL_TYPE_SHARED)
         $sharedList[] = $calendar;
      else if ($calendar->getCalendarType() == SM_CAL_TYPE_PUBLIC)
         $publicList[] = $calendar;


   if (!isset($color[12])) $color[12] = '';


   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   echo "<br><table align=\"center\" width=\"80%\"><tr><td align=\"left\">" 
      . _("<b>Shared</b>\n"
      . " calendars can be assigned to users with read only\n"
      . " or read/write access. To manage user access to your\n"
      . " shared calendars, use the \"Users\" button.") 
      . "</td></tr><tr><td align=\"left\">"

      . "<br>" 

      . _("<b>Public</b> calendars are available to all users\n"
      . " in addition to their private personal calendar.") 
      . "</td></tr></table><br>\n"
      . "<form action=\"admin_options.php\" method=\"post\">\n"
      . "<table align=\"center\" width=\"80%\" bgcolor=\"" . $color[9] . "\">\n"
      . "<tr bgcolor=\"" . $color[4] . "\"><td align=\"center\">\n";

   if (!empty($sharedList))
   {
      echo "<br><table align=\"center\" width=\"100%\" bgcolor=\"" . $color[12] . "\">\n"
         . "<tr bgcolor=\"" . $color[9] . "\"><td align=\"center\"></td>"
         . "<td align=\"center\">\n<b>"
         . _("Shared Calendars") . "</b>\n</td></tr>\n";

      foreach ($sharedList as $calendar)
      {
         echo "<tr><td align=\"center\">\n"
            . "<input type=\"checkbox\" name=\"delitem[" . $calendar->getID() . "]\" value=\"1\" />\n"
            . "</td><td align=\"center\">" . $calendar->getName() . "</td></tr>\n";
      }
   }
   else
   {
      echo "<table align=\"center\" width=\"100%\" bgcolor=\"" . $color[12] . "\">\n"
         . "<tr bgcolor=\"" . $color[9] . "\"><td align=\"center\">\n"
         . "<b>" . _("Shared calendars") . "</b>\n"
         . "</td></tr><tr><td align=\"center\">\n"
         . "<b>" . _("No Shared Calendars Defined") . "</b></td></tr>\n";
   }
   echo "</table><br>\n";

   if (!empty($publicList))
   {
      echo "<table align=\"center\" width=\"100%\" bgcolor=\"" . $color[12] . "\">\n"
         . "<tr bgcolor=\"" . $color[9] . "\"><td align=\"center\"></td>"
         . "<td align=\"center\">\n"
         . "<b>" . _("Public Calendars") . "</b>\n"
         . "</td></tr>\n";

      foreach ($publicList as $calendar)
      {
         echo "<tr><td align=\"center\">\n"
            . "<input type=\"checkbox\" name=\"delitem[" . $calendar->getID() . "]\" value=\"1\" />\n"
            . "</td><td align=\"center\">" . $calendar->getName() . "</td></tr>\n";
      }
   }
   else
   {
      echo "<table align=\"center\" width=\"100%\" bgcolor=\"" . $color[12] . "\">\n"
         . "<tr bgcolor=\"" . $color[9] . "\"><td align=\"center\">\n"
         . "<b>" . _("Public calendars") . "</b>\n"
         . "</td></tr><tr><td align=\"center\">\n"
         . "<b>" . _("No Public Calendars Defined") . "</b></td></tr>\n";
   }
   echo "</table><br>\n"
      . "</td></tr><tr><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"submit\" value=\"" 
      . _("Delete") . "\" /></td></tr></table>\n";

   echo '<input type="hidden" name="cal_action" value="' . SM_CAL_EDIT_CALENDARS . "\" />\n"
      . "<input type=\"hidden\" name=\"del_action\" value=\"Delete\" /></form>\n"
      . "<form action=\"admin_options.php\" method=\"post\">\n"
      . "<table width=\"80%\" align=\"center\">\n"
      . "<tr><td><b>" . _("Add a new calender") 
      . "</b></td></tr><tr><td align=\"center\">\n"
      . _("Name") 
      . ":&nbsp;<input type=\"text\" name=\"new_cal\" size=\"50\" />\n"
      . "</td></tr><tr><td align=\"center\">\n"
      . '<input type="hidden" name="cal_action" value="' 
      . SM_CAL_EDIT_CALENDARS . "\" />\n"
      . "<input type=\"hidden\" name=\"add_action\" value=\"Add\" />\n"
      . "<input type=\"checkbox\" id=\"public\" name=\"public\" value=\"yes\" />\n"
      . "&nbsp;&nbsp;<label for=\"public\">" . _("make <b>PUBLIC</b> (read/write for all users)") 
      . "</label>\n"
      . "</tr></td><tr><td align=\"center\"><input type=\"submit\" value=\"" 
      . _("Add") . "\" />\n"
      . "</td></tr></table><br><br></form>\n";

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Presents the user with an interface that allows adding and
  * managing users that have access to one or more shared 
  * calendar.
  *
  * @param array $color Standard SquirrelMail colors array
  * @param array $calList A list of all the calendars that
  *                       the current user has administrative
  *                       privileges against (array of
  *                       Calendar objects)
  *
  */
function display_user_admin_interface($color, $calList)
{

   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   if (!isset($color[12])) $color[12] = '';

   echo "<table align=\"center\" width=\"80%\"><tr><td><br>\n";

   echo _("<b>To delete one or more users</b> from a calendar, check the box next\n"
        . " to each username and click the 'Delete Users' button.") . "<br><br>\n"

        . _("<b>To add a user</b> to a calendar, type in the username below the\n"
        . " calendar, choose the user's access level, and click the 'Add User' button.") 
        . "<br><br>\n"

        . _("Note that you may use wildcards in user names: * means \"zero\n"
        . " or more characters\" and ? means \"exactly one alphanumeric\n"
        . " character\". For example, \"*@mydomain.com\" will give everyone\n"
        . " in \"mydomain.com\" access to the calendars you assign to that\n"
        . " username.\n")
        . "<br><br>\n"

        . _("<b>To update user access levels</b> for a calendar, adjust the 'Access\n"
        . " Level' selections, then click the 'Save' button below that calendar.") 
        . "<br><br>\n"

        . _("Note that only owners of public calendars will have write access\n"
        . " to those calendars.\n")

        . "</td></tr></table>\n";
             

   if (sizeof($calList) == 0)
      echo "<br><br><br><center><table width=\"80%\" cellspacing=\"3\" bgcolor=\"" 
         . $color[9] . "\"><tr><td bgcolor=\"" . $color[5] . "\" align=\"center\">"
         . "<b>" . _("No Shared Calendars Have Been Defined")
         . "</b></td></tr></table></center>";


   // iterate thru calendars, printing permissions table for each one
   //
   foreach ($calList as $calendar)
   {

      if ($calendar->getCalendarType() == SM_CAL_TYPE_PERSONAL)
         continue;

      echo "<form name=\"editCal_" . $calendar->getID() . "\" action=\"admin_options.php\" method=\"post\">\n"
         . "<br><center><table width=\"80%\" bgcolor=\"" . $color[9] 
         . "\"><tr><td colspan=\"3\">\n"
         . "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"25%\">&nbsp;</td>"
         . "<td align=\"center\"><b>" . $calendar->getName() 
         . ($calendar->getCalendarType() == SM_CAL_TYPE_PUBLIC ? '&nbsp;&nbsp;(' . _("Public") . ')' : '') 
         . "</b></td><td width=\"25%\" align=\"right\"><small><a href=\"admin_options.php?cal_action="
         . SM_CAL_EDIT_HOLIDAYS . "&calID=" . $calendar->getID() . "\">" . _("Edit Holidays") 
         . "</a></small></td></tr></table></td></tr><tr><td colspan=\"3\">\n"
         . "<table width=\"100%\" bgcolor=\"" . $color[4] . "\">\n"
         . "<tr bgcolor=\"" . $color[5] . "\"><td>&nbsp;</td><td width=\"100\" nowrap><b>" . _("User") 
         . "</b></td><td><b>" . _("Access Level") . "</b></td></tr>\n";


      // print out all users for this calendar
      //
      $allUsers = array_merge($calendar->getReadableUsers(), $calendar->getWriteableUsers(), $calendar->getOwners());
      natcasesort($allUsers);
      if (sizeof($allUsers) == 0)
         echo "<tr><td align=\"center\" colspan=\"3\">"
            . _("No users defined for this calendar")
            . "</td></tr>";

      foreach ($allUsers as $user)
      {

         $encodedUser = str_replace(array(' ', '?', '*'), array('SPACE', 'QUESTION', 'ASTERISK'), $user);
         echo "<tr><td align=\"center\"><input type=\"checkbox\" name=\"users[" . $encodedUser . "]\" /></td>"
            . "<td align=\"left\">$user</td><td align=\"left\">"
            . "<select name=\"userPerms[$encodedUser]\">";

         if ($calendar->getCalendarType() != SM_CAL_TYPE_PUBLIC)
            echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_READ . "\" " 
               . (in_array($user, $calendar->getReadableUsers()) ? 'SELECTED' : '') . ">" 
               . _("Read") . "</option>"
               . "<option value=\"" . SM_CAL_ACCESS_LEVEL_WRITE . "\" " 
               . (in_array($user, $calendar->getWriteableUsers()) ? 'SELECTED' : '') . ">" 
               . _("Write") . "</option>";

         echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_OWNER . "\" " 
            . (in_array($user, $calendar->getOwners()) ? 'SELECTED' : '') . ">" 
            . _("Owner") . "</option>"
            . "</select></td></tr>";

      }

      echo "</table></td></tr><tr><td align=\"left\">"
         . "<input name=\"deleteUsers\" value=\"" . _("Delete Users") 
         . "\" type=\"button\" onClick=\"document.editCal_" . $calendar->getID() 
         . ".user_action.value='delete'; document.editCal_" . $calendar->getID() . ".submit()\" />"
         . "</td><td align=\"center\">"
         . "<input type=\"text\" name=\"addUser\" size=\"15\" /> "
         . "<select name=\"addUserPerm\">";

      if ($calendar->getCalendarType() != SM_CAL_TYPE_PUBLIC)
         echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_READ . "\">" . _("Read") . "</option>"
            . "<option value=\"" . SM_CAL_ACCESS_LEVEL_WRITE . "\">" . _("Write") . "</option>";

      echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_OWNER . "\">" . _("Owner") . "</option>"
         . "</select> "
         . "<input type=\"button\" value=\"" . _("Add User") . "\" onClick=\"document.editCal_" 
         . $calendar->getID() . ".user_action.value='add'; document.editCal_" . $calendar->getID() 
         . ".submit()\"></td><td align=\"right\" />"
         . "<input name=\"savePerms\" value=\"" . _("Save") 
         . "\" type=\"button\" onClick=\"document.editCal_" . $calendar->getID() 
         . ".user_action.value='saveperms'; document.editCal_" . $calendar->getID() 
         . ".submit()\" /></td></tr></table>"
         . '<input type="hidden" name="cal_action" value="' . SM_CAL_EDIT_USERS . "\" />\n"
         . "<input type=\"hidden\" value=\"" . $calendar->getID() . "\" name=\"calID\" />"
         . "<input type=\"hidden\" value=\"\" name=\"user_action\" /></form>";

   }

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



/**
  * Presents the user with an interface that allows adding and
  * managing holidays for a given calendar, as well as adding
  * global holidays to the system.
  * 
  * @param array $color Standard SquirrelMail colors array
  * @param object $calendar The calendar whose holidays are being edited
  * @param array $holidayList A list of all global holidays in the system
  *                       
  */
function display_holiday_admin_interface($color, $calendar, $holidayList)
{

   bindtextdomain ('calendar', SM_PATH . 'locale');
   textdomain ('calendar');

   if (!isset($color[12])) $color[12] = '';
   
   echo "<table align=\"center\" width=\"80%\"><tr><td><br>\n";
   
   echo _("<b>To create a holiday,</b> blah blah\n"
        . " and click the 'Blah Blah' button.") . "<br><br>\n"
        
        . _("Note that you must also add the new holiday to your calendar if desired.\n")
        . "<br><br>\n"

        . _("<b>To add a holiday</b> to a calendar, blah blah blah\n"
        . " and click the 'Blah Blah' button.")
        . "<br><br>\n"
        
        . _("<b>To remove a holiday</b> from a calendar, blah blah blah,\n"
        . " then click the 'Blah' button below that calendar.")

        . "</td></tr></table>\n";


   if (sizeof($holidayList) == 0)
      echo "<br><br><br><center><table width=\"80%\" cellspacing=\"3\" bgcolor=\""
         . $color[9] . "\"><tr><td bgcolor=\"" . $color[5] . "\" align=\"center\">"
         . "<b>" . _("No Holidays Have Been Defined") 
         . "</b></td></tr></table></center>";


   // iterate thru holidays, displaying each...
   //
   foreach ($holidayList as $holiday)
   {

echo "global holiday " . $holiday->getID() . " : " . $holiday->name . "<br>" . nl2br($holiday->comments) . "<HR>";
/* LEFT OFF HERE.... need global holiday edit interface:  
                         holiday name
                                 comments
                                 admin comments (non-display)

                     then we need an interface for showing what holidays are 
                     already in the given calendar (and for what date each one is)
                     and a way to change that date, remove the holiday, or add
                     new global holidays to the calendar


this code just stolen from above....

      echo "<form name=\"editCal_" . $calendar->getID() . "\" action=\"admin_options.php\" method=\"post\">\n"
         . "<br><center><table width=\"80%\" bgcolor=\"" . $color[9]
         . "\"><tr><td colspan=\"3\">\n"
         . "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"25%\">&nbsp;</td>"
         . "<td align=\"center\"><b>" . $calendar->name
         . ($calendar->getCalendarType() == SM_CAL_TYPE_PUBLIC ? '&nbsp;&nbsp;(' . _("Public") . ')' : '')
         . "</b></td><td width=\"25%\" align=\"right\"><small><a href=\"admin_options.php?cal_action="
         . SM_CAL_EDIT_HOLIDAYS . "&calID=" . $calendar->getID() . "\">" . _("Edit Holidays")
         . "</a></small></td></tr></table></td></tr><tr><td colspan=\"3\">\n"
         . "<table width=\"100%\" bgcolor=\"" . $color[4] . "\">\n"
         . "<tr bgcolor=\"" . $color[5] . "\"><td>&nbsp;</td><td width=\"100\" nowrap><b>" . _("User")
         . "</b></td><td><b>" . _("Access Level") . "</b></td></tr>\n";


      // print out all users for this calendar
      //
      $allUsers = array_merge($calendar->readable_users, $calendar->writeable_users, $calendar->owners);
      natcasesort($allUsers);
      if (sizeof($allUsers) == 0)
         echo "<tr><td align=\"center\" colspan=\"3\">"
            . _("No users defined for this calendar")
            . "</td></tr>";

      foreach ($allUsers as $user)
      {

         $encodedUser = str_replace(array(' ', '?', '*'), array('SPACE', 'QUESTION', 'ASTERISK'), $user);
         echo "<tr><td align=\"center\"><input type=\"checkbox\" name=\"users[" . $encodedUser . "]\" /></td>"
            . "<td align=\"left\">$user</td><td align=\"left\">"
            . "<select name=\"userPerms[$encodedUser]\">";

         if ($calendar->getCalendarType() != SM_CAL_TYPE_PUBLIC)
            echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_READ . "\" "
               . (in_array($user, $calendar->readable_users) ? 'SELECTED' : '') . ">"
               . _("Read") . "</option>"
               . "<option value=\"" . SM_CAL_ACCESS_LEVEL_WRITE . "\" "
               . (in_array($user, $calendar->writeable_users) ? 'SELECTED' : '') . ">"
               . _("Write") . "</option>";

         echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_OWNER . "\" "
            . (in_array($user, $calendar->owners) ? 'SELECTED' : '') . ">"
            . _("Owner") . "</option>"
            . "</select></td></tr>";

      }

      echo "</table></td></tr><tr><td align=\"left\">"
         . "<input name=\"deleteUsers\" value=\"" . _("Delete Users")
         . "\" type=\"button\"/ onClick=\"document.editCal_" . $calendar->getID()
         . ".user_action.value='delete'; document.editCal_" . $calendar->getID() . ".submit()\" />"
         . "</td><td align=\"center\">"
         . "<input type=\"text\" name=\"addUser\" size=\"15\" /> "
         . "<select name=\"addUserPerm\">";

      if ($calendar->getCalendarType() != SM_CAL_TYPE_PUBLIC)
         echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_READ . "\">" . _("Read") . "</option>"
            . "<option value=\"" . SM_CAL_ACCESS_LEVEL_WRITE . "\">" . _("Write") . "</option>";

      echo "<option value=\"" . SM_CAL_ACCESS_LEVEL_OWNER . "\">" . _("Owner") . "</option>"
         . "</select> "
         . "<input type=\"button\" value=\"" . _("Add User") . "\" onClick=\"document.editCal_" 
         . $calendar->getID() . ".user_action.value='add'; document.editCal_" . $calendar->getID() 
         . ".submit()\" /></td><td align=\"right\">"
         . "<input name=\"savePerms\" value=\"" . _("Save") 
         . "\" type=\"button\"/ onClick=\"document.editCal_" . $calendar->getID() 
         . ".user_action.value='saveperms'; document.editCal_" . $calendar->getID() 
         . ".submit()\" /></td></tr></table>"
         . '<input type="hidden" name="cal_action" value="' . SM_CAL_EDIT_USERS . "\" />\n"
         . "<input type=\"hidden\" value=\"" . $calendar->getID() . "\" name=\"calID\" />"
         . "<input type=\"hidden\" value=\"\" name=\"user_action\" /></form>";
*/

   }

   bindtextdomain ('squirrelmail', SM_PATH . 'locale');
   textdomain ('squirrelmail');

}



?>
