<?PHP

function main_menu($color) {
    if (!isset($color[12])) $color[12] = '';
    print "<br><br><center>\n".
        "<table width=\"80%\" bgcolor=\"$color[9]\"><tr><td align=center>\n".
        "<b>" . _("Shared Calendar Setup") . "</b></td></tr><tr><td>\n".
        "<table width=\"100%\" bgcolor=\"$color[9]\" cellpadding=3>\n".
        "<tr bgcolor=\"$color[12]\"><td>\n".
        _("Here you can create shared access calendars for select users \n".
        " or public calendars for all users.\n").
        "</td><td>\n".
        _("Here you can give users rights to read and/or\n".
        "write to the available shared access calendars.\n").
        "</td></tr><tr><td align=center>\n".
        "<form action=\"admin_options.php\" method=post>\n".
        "<input type=submit value=\"" . _("Calendars") . "\">\n".
        "<input type=hidden name=\"cal_action\" value=\"Calendars\">\n".
        "</form>\n".
        "</td><td align=center>\n".
        "<form action=\"admin_options.php\" method=post>\n".
        "<input type=submit value=\"" . _("Users") . "\">\n".
        "<input type=hidden name=\"cal_action\" value=\"Users\">\n".
        "</form>\n".
        "</td></tr></table>".
        "</td></tr></table>\n".
        "</center>\n";
}


// returns the username of the calendar owner, or FALSE if none found
//
function get_calendar_owner($cal_name)
{

    global $data_dir;
    $calendar_data_name = $data_dir . $cal_name;
    if (file_exists($calendar_data_name)) 
    {
        $fp = fopen ($calendar_data_name, 'r');
        while (!feof ($fp))  
        {
//TODO: Not finished yet... it is not clear if we need this function
            //if 
        }
    }

    return FALSE;

}


// returns TRUE if the given administrative user is one 
// of the "owners" of the given user
//
function userIsOwnedBy($user, $admin_user)
{

// TODO: not clear if we need this function...
    return FALSE;

}



// need to have a way to map what 
// the original index number in the full calendar list
// for an index number based on a restricted list - so
// we just make an array whose keys are the full list
// index numbers and the vlues are the restricted list
// index numbers or 'NOT IN LIST' if that calendar is
// restricted to this user
//
function get_calendar_index_mappings($data_dir, $result_type, $user) 
{
    $mappings = array();
    $fullCount = 0;
    $restrictedCount = 0;

    $calendar_data_name = 'SharedCalList';
    if (file_exists("$data_dir$calendar_data_name")) 
    {
        $fp = fopen ("$data_dir$calendar_data_name", 'r');
        while (!feof ($fp)) 
        {
            $line = fgets($fp,1024);
            if (preg_match("/^\{(\d+)\}\s*\{OWNER=(.*)\}\s*(.+)/", $line, $match)) 
            {
                if ($result_type == 'shared') 
                {
                    if ($user == $match[2])
                        $mappings[$fullCount++] = $restrictedCount++;
                    else
                        $mappings[$fullCount++] = 'NOT IN LIST';
                }
            }
            if (preg_match("/^P\{(\d+)\}\s*\{OWNER=(.*)\}\s*(.+)/", $line, $match)) 
            {
                if ($result_type == 'public') 
                {
                    if ($user == $match[2])
                        $mappings[$fullCount] = $restrictedCount++;
                    else
                        $mappings[$fullCount++] = 'NOT IN LIST';
                }
            }
        }
        fclose($fp);
    }
    return $mappings;
}



// if $restrict_list_to_user is given as a username, only those
// calendars that are owned by that user are returned in the list
//
function read_calendar_list($data_dir, $result_type, $restrict_list_to_user = FALSE) {

    // hack... just make this a separate global array cuz 
    // calendar info is so poorly organized... this doesn't
    // help, but i'm not up for a total rewrite...
    //
    global $calendar_owners;
    if (!isset($calendar_owners))
        $calendar_owners = array();

    $shared_cals = array();
    $pub_cals = array();
    $calendar_data_name = 'SharedCalList';
    if (file_exists("$data_dir$calendar_data_name")) {
        $fp = fopen ("$data_dir$calendar_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            if (preg_match("/^\{(\d+)\}\s*\{OWNER=(.*)\}\s*(.+)/", $line, $match)) {
                $cal_name = $match[3];
                $cal_owner = $match[2];
                $calendar_owners[$cal_name] = $cal_owner;
                if (!$restrict_list_to_user || $restrict_list_to_user == $cal_owner)
                    array_push($shared_cals, $cal_name);
            }
            if (preg_match("/^P\{(\d+)\}\s*\{OWNER=(.*)\}\s*(.+)/", $line, $match)) {
                $cal_name = $match[3];
                $cal_owner = $match[2];
                $calendar_owners[$cal_name] = $cal_owner;
                if (!$restrict_list_to_user || $restrict_list_to_user == $cal_owner)
                    array_push($pub_cals, $cal_name);
            }
        }
        fclose($fp);
    }
    if ($result_type == 'public') {
        return $pub_cals;
    }
    elseif ($result_type == 'shared') {
        return $shared_cals;
    }
}

function save_calendar_list($data_dir, $update_list, $save_type) {

    global $calendar_owners;

    $calendar_data_name = 'SharedCalList';
    if ($save_type == 'shared') {
        $known_type = 'public';
    }
    elseif ($save_type == 'public') {
        $known_type = 'shared';
    }

    $known_list = read_calendar_list($data_dir, $known_type);

    if ($known_type == 'public') {
        $public_list = $known_list;
        $shared_list = $update_list;
    }
    elseif ($known_type == 'shared') {
        $public_list = $update_list;
        $shared_list = $known_list;
    }

    $fp = fopen ("$data_dir$calendar_data_name", "w");
    if ($fp) {
        $count = count($shared_list);
        for ($x=0;$x<$count;$x++) {
            $line = '';
            $length = strlen($shared_list[$x]);
            $line .= "{".$length."}{OWNER=".$calendar_owners[$shared_list[$x]]."} ".$shared_list[$x];
            fwrite($fp, $line."\n", 1024);
        }
        $count = count($public_list);
        for ($x=0;$x<$count;$x++) {
            $line = '';
            $line .= 'P';
            $length = strlen($public_list[$x]);
            $line .= "{".$length."}{OWNER=".$calendar_owners[$public_list[$x]]." ".$public_list[$x];
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
    else {
        print "Could not save data for shared calendar plugin";
    }
}

function get_user_codes ($data_dir) {
    $results = array();
    $user_data_name = 'SharedUserList';
    if (file_exists("$data_dir$user_data_name")) {
        if (filesize("$data_dir$user_data_name") != '0') {
            $fp = fopen("$data_dir$user_data_name", "r");
            $x=0;
            while (!feof ($fp)) {
                $line = fgets($fp,1024);
                    $line = trim($line);
                    if (!empty($line)) {
                        $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
                        $results[$x]['name'] = $line_parts[0];
                        $results[$x]['code'] = $line_parts[1];
                        $results[$x]['owners'] = explode('|', $line_parts[2]);
                        $x++;
                    }
            }
            fclose($fp);
        }
    }
    return $results;
    clearstatcache;
}

function get_user_code ($data_dir, $username) {
    $result = '';
    $user_data_name = 'SharedUserList';
    if (file_exists("$data_dir$user_data_name")) {
        $fp = fopen("$data_dir$user_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
            if (isset($line_parts[0])) {
                if (preg_match('/^' . str_replace(array('?', '*'), 
                                                  array('\w{1}', '.*?'), 
                                                  $line_parts[0]) . '$/',
                               $username)) {
                    $line = trim($line);
                    $result = combine_permissions($result, $line_parts[1]);
                }
            }
        }
        fclose($fp);
    }
    return $result;    
}

// takes two permissions strings and combines them, giving 
// the user the most broad/permissive combination of the two
//
function combine_permissions ($permissions, $new_permissions) {

   if ($permissions == '') return $new_permissions;

   $permissions_array = preg_split('//', $permissions, -1, PREG_SPLIT_NO_EMPTY); 
   $new_permissions_array = preg_split('//', $new_permissions, -1, PREG_SPLIT_NO_EMPTY); 

   $returnValue = '';

   for ($i = 0; $i < sizeof($permissions_array); $i++) {
      if ($new_permissions_array[$i] > $permissions_array[$i])
         $returnValue .= $new_permissions_array[$i];
      else
         $returnValue .= $permissions_array[$i];

   }

   return $returnValue;

}

function save_user_codes ($data_dir, $userdata) {
   $user_data_name = 'SharedUserList';
   $fp = fopen("$data_dir$user_data_name", "w");
   if ($fp) {
       $count = count($userdata);
       for ($x=0;$x<$count;$x++) {
            $line = $userdata[$x]['name']." = ".$userdata[$x]['code']
                  ." = ".implode('|', $userdata[$x]['owners']);
            fwrite($fp, $line."\n", 1024);
       }
       fclose($fp);
   }
   else {
       print _("Could not save data for the shared calendar plugin");
   }
   return $userdata;
}

function addto_user_codes ($data_dir) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        $count = count($userdata);
            for ($x=0;$x<$count;$x++) {
            $line = $userdata[$x]['name']." = ".$userdata[$x]['code']."0"
                  ." = ".implode('|', $userdata[$x]['owners']);
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
    else {
        print _("Could not save data for the shared calendar plugin");
    }
}

function delall_user_codes ($data_dir) {
    $user_data_name = 'SharedUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        fclose($fp);
    }
    else {
        print _("Could not save data for the shared calendar plugin");
    }
}

function delfrom_user_codes ($data_dir, $index) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        $count = count($userdata);
        for ($x=0;$x<$count;$x++) {
            $new_code = substr_replace($userdata[$x]['code'], '', $index, 1);
            $line = $userdata[$x]['name']." = ".$new_code
                  ." = ".implode('|', $userdata[$x]['owners']);
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
}

function remove_user ($data_dir, $name, $owner) {
//echo "<hr>removing $data_dir , $name <hr>";exit;

    $userdata = get_user_codes($data_dir);


    // check if this user still has other owners
    // in which case we just remove the current owner
    // instead of actually removing the user
    //
    for ($x = 0; $x < count($userdata); $x++)
    {
        if ($userdata[$x]['name'] == $name)
        {
            // while we're here, make sure this owner
            // has permission to delete this user
            // 
            if (!in_array($owner, $userdata[$x]['owners']))
            {
                echo '<center><font size="4" color="red">' . _("Permission denied; cannot delete user") . '</font></center>';
                exit;
            }

            if (count($userdata[$x]['owners']) > 1)
            {
                $index = array_search($owner, $userdata[$x]['owners']);
                array_splice($userdata[$x]['owners'], $index, 1);
                save_user_codes($data_dir, $userdata);
                return;
            }
        }
    }

    $user_data_name = 'SharedUserList';
    $count = count($userdata);
    for ($x=0;$x<$count;$x++) {
        if ($name == $userdata[$x]['name']) {
        //if (preg_match("/^$name$/", $userdata[$x]['name'])) {
                array_splice($userdata, $x, 1);
                break;
        }
    }    
    save_user_codes ($data_dir, $userdata);
}

function check_me($data_dir, $name, $calendar) {
    $ccode = get_user_code($data_dir, $name);
    $public_list = read_calendar_list($data_dir, 'public');
    $shared_list = read_calendar_list($data_dir, 'shared');

    if ($calendar == 'Personal') {
        return 'write';
    }
    foreach ($public_list as $public_calendar) {
        if ($calendar == $public_calendar) {
            return 'write';
        }
    }
    $code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
    $count = count($shared_list);
    $access = '';
    for ($x=0;$x<$count;$x++) {
        if (trim($shared_list[$x]) == trim($calendar)) {
            switch ($code[$x]) {
                case 0:
                    $access = 'no';
                    break;
                case 1:
                    $access = 'read';
                    break;
                case 2:
                    $access = 'write';
                    break;
                default:
                    break;
             }
            break;
        }
    }
    return $access;
}

function add_user ($data_dir, $name, $cal_list, $owner) {
    $userdata = get_user_codes($data_dir);
    
    // check if this user already exists with other owners
    //
    for ($x = 0; $x < count($userdata); $x++)
    {
        if ($userdata[$x]['name'] == $name)
        {
            $userdata[$x]['owners'][] = $owner;
            $userdata = save_user_codes($data_dir, $userdata);
            return $userdata;
        }
    }

    $user_number = count($userdata);
    $count = count($cal_list);
    $val = str_repeat("0", $count);
    $userdata[$user_number]['name'] = $name;
    $userdata[$user_number]['code'] = $val;
    $userdata[$user_number]['owners'] = array($username);
    $userdata = save_user_codes($data_dir, $userdata);
    return $userdata;
}

?>
