<?PHP

function main_menu($color) {
    print "<br><br><center>\n".
        "<form action=\"admin_options.php\" method=post>\n".
        "<table width=\"80%\" bgcolor=\"$color[9]\"><tr><td align=center>\n".
        "<b>" . _("Shared Calendar Setup") . "</b></td></tr><tr><td>\n".
        "<table width=\"100%\" bgcolor=\"$color[9]\" cellpadding=3>\n".
        "<tr bgcolor=\"$color[12]\"><td>\n".
        _("Here you can create shared access calendars for select users \n".
        " or public calendars for all users.\n").
        "</td><td>\n".
        _("Here you can give users rights to read and/or\n".
        "write to the available shared access calendars.\n").
        "</td></tr><tr><td align=center>\n".
        "<input type=submit name=\"submit\" value=\"" . _("Calendars") . "\">\n".
        "</td><td align=center>\n".
        "<input type=submit name=\"submit\" value=\"" . _("Users") . "\">\n".
        "</td></tr></table>".
        "</td></tr></table>\n".
        "</form>\n".
        "</center>\n";
}

function read_calendar_list($data_dir, $result_type) {
    $shared_cals = array();
    $pub_cals = array();
    $calendar_data_name = 'SharedCalList';
    if (file_exists("$data_dir$calendar_data_name")) {
        $fp = fopen ("$data_dir$calendar_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            if (preg_match("/^\{(\d+)\}/", $line, $match)) {
                $cal_name = substr($line, (strpos($line, '}')+2), $match[1]);
                array_push($shared_cals, $cal_name);
            }
            if (preg_match("/^P\{(\d+)\}/", $line, $match)) {
                $cal_name = substr($line, (strpos($line, '}')+2), $match[1]);
                array_push($pub_cals, $cal_name);
            }
        }
        fclose($fp);
    }
    if ($result_type == 'public') {
        return $pub_cals;
    }
    elseif ($result_type == 'shared') {
        return $shared_cals;
    }
}

function save_calendar_list($data_dir, $update_list, $save_type) {
    $calendar_data_name = 'SharedCalList';
    if ($save_type == 'shared') {
        $known_type = 'public';
    }
    elseif ($save_type == 'public') {
        $known_type = 'shared';
    }

    $known_list = read_calendar_list($data_dir, $known_type);

    if ($known_type == 'public') {
        $public_list = $known_list;
        $shared_list = $update_list;
    }
    elseif ($known_type == 'shared') {
        $public_list = $update_list;
        $shared_list = $known_list;
    }

    $fp = fopen ("$data_dir$calendar_data_name", "w");
    if ($fp) {
        $count = count($shared_list);
        for ($x=0;$x<$count;$x++) {
            $line = '';
            $length = strlen($shared_list[$x]);
            $line .= "{".$length."}"." ".$shared_list[$x];
            fwrite($fp, $line."\n", 1024);
        }
        $count = count($public_list);
        for ($x=0;$x<$count;$x++) {
            $line = '';
            $line .= 'P';
            $length = strlen($public_list[$x]);
            $line .= "{".$length."}"." ".$public_list[$x];
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
    else {
        print "Could not save data for shared calendar plugin";
    }
}

function get_user_codes ($data_dir) {
    $results = array();
    $user_data_name = 'SharedUserList';
    if (file_exists("$data_dir$user_data_name")) {
        if (filesize("$data_dir$user_data_name") != '0') {
            $fp = fopen("$data_dir$user_data_name", "r");
            $x=0;
            while (!feof ($fp)) {
                $line = fgets($fp,1024);
                    $line = trim($line);
                    if (!empty($line)) {
                        $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
                        $results[$x]['name'] = $line_parts[0];
                        $results[$x]['code'] = $line_parts[1];
                        $x++;
                    }
            }
            fclose($fp);
        }
    }
    return $results;
    clearstatcache;
}

function get_user_code ($data_dir, $username) {
    $result = '';
    $user_data_name = 'SharedUserList';
    if (file_exists("$data_dir$user_data_name")) {
        $fp = fopen("$data_dir$user_data_name", "r");
        while (!feof ($fp)) {
            $line = fgets($fp,1024);
            $line_parts = preg_split("/ = /",$line, -1, PREG_SPLIT_NO_EMPTY);
            if (isset($line_parts[0])) {
                if (preg_match('/^' . str_replace(array('?', '*'), 
                                                  array('\w{1}', '.*?'), 
                                                  $line_parts[0]) . '$/',
                               $username)) {
                    $line = trim($line);
                    $result = combine_permissions($result, $line_parts[1]);
                }
            }
        }
        fclose($fp);
    }
    return $result;    
}

// takes two permissions strings and combines them, giving 
// the user the most broad/permissive combination of the two
//
function combine_permissions ($permissions, $new_permissions) {

   if ($permissions == '') return $new_permissions;

   $permissions_array = preg_split('//', $permissions, -1, PREG_SPLIT_NO_EMPTY); 
   $new_permissions_array = preg_split('//', $new_permissions, -1, PREG_SPLIT_NO_EMPTY); 

   $returnValue = '';

   for ($i = 0; $i < sizeof($permissions_array); $i++) {
      if ($new_permissions_array[$i] > $permissions_array[$i])
         $returnValue .= $new_permissions_array[$i];
      else
         $returnValue .= $permissions_array[$i];

   }

   return $returnValue;

}

function save_user_codes ($data_dir, $userdata) {
   $user_data_name = 'SharedUserList';
   $fp = fopen("$data_dir$user_data_name", "w");
   if ($fp) {
       $count = count($userdata);
       for ($x=0;$x<$count;$x++) {
            $line = $userdata[$x]['name']." = ".$userdata[$x]['code'];
            fwrite($fp, $line."\n", 1024);
       }
       fclose($fp);
   }
   else {
       print _("Could not save data for the shared calendar plugin");
   }
   return $userdata;
}

function addto_user_codes ($data_dir) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        $count = count($userdata);
            for ($x=0;$x<$count;$x++) {
            $line = $userdata[$x]['name']." = ".$userdata[$x]['code']."0";
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
    else {
        print _("Could not save data for the shared calendar plugin");
    }
}

function delall_user_codes ($data_dir) {
    $user_data_name = 'SharedUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        fclose($fp);
    }
    else {
        print _("Could not save data for the shared calendar plugin");
    }
}

function delfrom_user_codes ($data_dir, $index) {
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedUserList';
    $fp = fopen("$data_dir$user_data_name", "w");
    if ($fp) {
        $count = count($userdata);
        for ($x=0;$x<$count;$x++) {
            $new_code = substr_replace($userdata[$x]['code'], '', $index, 1);
            $line = $userdata[$x]['name']." = ".$new_code;
            fwrite($fp, $line."\n", 1024);
        }
        fclose($fp);
    }
}

function remove_user ($data_dir, $name) {
//echo "<hr>removing $data_dir , $name <hr>";exit;
    $userdata = get_user_codes($data_dir);
    $user_data_name = 'SharedUserList';
    $count = count($userdata);
    for ($x=0;$x<$count;$x++) {
        if ($name == $userdata[$x]['name']) {
        //if (preg_match("/^$name$/", $userdata[$x]['name'])) {
                array_splice($userdata, $x, 1);
                break;
        }
    }    
    save_user_codes ($data_dir, $userdata);
}

function check_me($data_dir, $name, $calendar) {
    $ccode = get_user_code($data_dir, $name);
    $public_list = read_calendar_list($data_dir, 'public');
    $shared_list = read_calendar_list($data_dir, 'shared');

    if ($calendar == 'Personal') {
        return 'write';
    }
    foreach ($public_list as $public_calendar) {
        if ($calendar == $public_calendar) {
            return 'write';
        }
    }
    $code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
    $count = count($shared_list);
    $access = '';
    for ($x=0;$x<$count;$x++) {
        if (trim($shared_list[$x]) == trim($calendar)) {
            switch ($code[$x]) {
                case 0:
                    $access = 'no';
                    break;
                case 1:
                    $access = 'read';
                    break;
                case 2:
                    $access = 'write';
                    break;
                default:
                    break;
             }
            break;
        }
    }
    return $access;
}

function add_user ($data_dir, $name, $cal_list) {
    $userdata = get_user_codes($data_dir);
    $user_number = count($userdata);
    $count = count($cal_list);
    $val = str_repeat("0", $count);
    $userdata[$user_number]['name'] = $name;
    $userdata[$user_number]['code'] = $val;
    $userdata = save_user_codes($data_dir, $userdata);
    return $userdata;
}

?>
