<?php
/*
 *
 *  calendar.php
 *
 *  Copyright (c) 2001 Michal Szczotka <michal@tuxy.org>
 *  Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  Displays the main calendar page (month view).
 *  Modified by Jason Munro 6/28/02
 *
 */

require_once('calendar_data.php');
require_once('functions.php');
require_once('shared_functions.php');
chdir('..');
require_once('../src/validate.php');
require_once('../functions/strings.php');
require_once('../functions/date.php');
require_once('../config/config.php');
require_once('../functions/page_header.php');
require_once('../src/load_prefs.php');

if (isset($_GET['cal'])) {
    $cal = $_GET['cal'];
}
if (isset($_POST['cal'])) {
    $cal = $_POST['cal'];
}

$checkup = check_me($data_dir, $_SESSION['username'], $cal);
if ($checkup == 'no') {
    print "<center><font color=\"red\"><br><br><big><b>" . _("You do not have access to this calendar") . "</b></big></font></center>\n";
    exit();
}

/* get globals */
if (isset($_GET['month'])) {
    $month = $_GET['month'];
}
if (isset($_GET['year'])) {
    $year = $_GET['year'];
}
if (isset($_POST['year'])) {
    $year = $_POST['year'];
}
if (isset($_POST['month'])) {
    $month = $_POST['month'];
}
/* got 'em */

//display upper part of month calendar view
function startcalendar() {
    global $year, $month, $day, $color, $cal;

    $prev_date = mktime(0, 0, 0, $month - 1, 1, $year);
    $act_date  = mktime(0, 0, 0, $month, 1, $year);
    $next_date = mktime(0, 0, 0, $month + 1, 1, $year);
    $prev_month = date( 'm', $prev_date );
    $next_month = date( 'm', $next_date);
    $prev_year = date( 'Y', $prev_date);
    $next_year = date( 'Y', $next_date );
    $self = 'calendar.php';

    echo "<TR BGCOLOR=\"$color[0]\"><TD>" .
         "<TABLE WIDTH=100% BORDER=0 CELLPADDING=2 CELLSPACING=1 BGCOLOR=\"$color[0]\">" .
         '<tr>'.
         "<th><a href=\"$self?cal=".urlencode($cal)."&year=".($year-1)."&month=$month\">&lt;&lt;&nbsp;".($year-1)."</a></th>\n".
         "<th><a href=\"$self?cal=".urlencode($cal)."&year=$prev_year&month=$prev_month\">&lt;&nbsp;" .
         date_intl( 'M', $prev_date). "</a></th>\n".
         "<th bgcolor=$color[0] colspan=3>" .
         date_intl( 'F Y', $act_date ) . "</th>\n" .
         "<th><a href=\"$self?cal=".urlencode($cal)."&year=$next_year&month=$next_month\">" .
         date_intl( 'M', $next_date) . "&nbsp;&gt;</a></th>".
         "<th><a href=\"$self?cal=".urlencode($cal)."&year=".($year+1)."&month=$month\">".($year+1)."&nbsp;&gt;&gt;</a></th>".
         '</tr><tr>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Sunday") . '</th>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Monday") . '</th>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Tuesday") . '</th>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Wednesday") . '</th>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Thursday") . '</th>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Friday") . '</th>'.
         "<th WIDTH=\"14%\" bgcolor=$color[5] width=90>" . _("Saturday") . '</th>'.
        '</tr>';

}

//main logic for month view of calendar
function drawmonthview() {
    global $year, $month, $day, $color, $calendardata, $todayis, $cal;
    $aday = 1 - date('w', mktime(0, 0, 0, $month, 1, $year));
    $days_in_month = date('t', mktime(0, 0, 0, $month, 1, $year));
    while ($aday <= $days_in_month) {
        echo '<tr>';
        for ($j=1; $j<=7; $j++) {
            $cdate="$month";
            ($aday<10)?$cdate=$cdate."0$aday":$cdate=$cdate."$aday";
            $cdate=$cdate."$year";
            if ( $aday <= $days_in_month && $aday > 0){
                echo "<TD BGCOLOR=\"$color[4]\" height=50 valign=top>\n" .
                     "<div align=right>";
                echo(($cdate==$todayis) ? "<font size=-1 color=$color[1]>[ " . _("TODAY") . " ] " : "<font size=-1>");
                echo "<a href=day.php?cal=".urlencode($cal)."&year=$year&month=$month&day=";
                echo(($aday<10) ? "0" : "");
                echo "$aday>$aday</a></font></div>";
            } else {
                echo "<TD BGCOLOR=\"$color[0]\">\n".
                     "&nbsp;";
            }
            if (isset($calendardata[$cdate])){
                $i=0;
                while ($calfoo = each($calendardata[$cdate])) {
                    $calbar = $calendardata[$cdate][$calfoo['key']];
                    echo ($calbar['priority']==1) ? "<a href=\"#\" style=\"text-decoration:none; color: $color[1]\" title=\"" . eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $calbar['message']) . "\">$calbar[title]</a><br>\n" : "<a href=\"#\" style=\"text-decoration:none; color: $color[6]\" title=\"" . eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $calbar['message']) . "\">$calbar[title]</a><br>\n";
                    $i=$i+1;
                    if($i==2){
                        break;
                    }
                }
            }
            echo "\n</TD>\n";
            $aday++;
        }
        echo '</tr>';
    }
}

//end of monthly view and form to jump to any month and year
//or different calendar
function endcalendar() {
    global $year, $month, $day, $color, $cal;

    global $data_dir, $username;
    $shared_list = read_calendar_list($data_dir, 'shared');
    $public_list = read_calendar_list($data_dir, 'public');
    $ccode = get_user_code($data_dir, $username);
    if ($ccode == '') {
        $cal_num = count($shared_list);
        $ccode = str_repeat("0", $cal_num);
    }


    echo "          <TR><TD COLSPAN=5>\n".
         "          <FORM NAME=caljump ACTION=\"calendar.php\" METHOD=POST>\n".
         "          <SELECT NAME=\"year\">\n";
    select_option_year($year);
    echo "          </SELECT>\n".
         "          <SELECT NAME=\"month\">\n";
    select_option_month($month);
    echo "          </SELECT>\n".
         '         <INPUT TYPE=SUBMIT VALUE="' . _("Go") . "\">\n".
         "         <input type=hidden name=cal value=\"$cal\">\n".
         "          </FORM>\n".
         "          </TD>\n".
         "          <TD COLSPAN=2><FORM NAME=\"calswitch\"><SELECT NAME=\"calselect\">\n";
    $count = count($public_list);
    for ($x=0;$x<$count;$x++) {
        $url_calendar=urlencode($public_list[$x]);
        echo "<OPTION VALUE=\"calendar.php?cal=$url_calendar\"";
        if ($cal == $public_list[$x]) echo " SELECTED";
        echo ">$public_list[$x]</OPTION>\n";
    }
    $code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
    for ($x=0;$x<count($shared_list);$x++) {
        $url_calendar = urlencode($shared_list[$x]);
            switch ($code[$x]) {
                    case 0:
                    break;
                    case 1:
                    case 2:
                       echo "<OPTION VALUE=\"calendar.php?cal=$url_calendar\"";
                       if ($cal == $shared_list[$x]) echo " SELECTED";
                       echo ">$shared_list[$x]</OPTION>\n";
                       break;
                    default:
                       break;
            }
    }
    echo "<OPTION VALUE=\"calendar.php?cal=Personal\"";
    if ($cal == 'Personal') echo " SELECTED";
    echo ">Personal</OPTION>\n".
         "          </SELECT>\n".
         '          <INPUT TYPE=BUTTON VALUE="' . _("Go") . '" onClick="' .
         'for (i=0;i<document.calswitch.calselect.length;i++){if ' .
         '(document.calswitch.calselect.options[i].selected) ' .
         'dest=document.calswitch.calselect.options[i].value;} ' .
         'location.href=dest;">' . "\n";
    echo "          </FORM></TD></TR>\n".
         "</TABLE></TD></TR></TABLE>\n";
}


if( !isset( $month ) || $month <= 0){
    $month = date( 'm' );
}
if( !isset($year) || $year <= 0){
    $year = date( 'Y' );
}
if( !isset($day) || $day <= 0){
    $day = date( 'd' );
}

$todayis = date( 'mdY' );
$calself=basename($PHP_SELF);

displayPageHeader($color, 'None');
calendar_header();
readcalendardata();
startcalendar();
drawmonthview();
endcalendar();

?>
</body></html>
