<?php
/*
 *	ServerSideFilter - ServerSide mail filter plugin for SquirrelMail
 *	By Patrick Swieskowski, Rick Sheaffer, and Jon Stroud
 */


/**
 * These are the backend definitions.  You should never directly call any
 * of these functions. Calls to these functions are made from functions.php
 */

function local_filter_get() {
   global $username;

   $localfile = "/tmp/serversidefilter/";
   if (!is_dir($localfile)) {
      mkdir($localfile, 0777);
   }
   chmod($localfile, 0777);

   $localfile .= "filterfile.$username";
   touch($localfile);
   if (local_filter_exists()) {
      $result = invoke_filtercmd("getrc filter", "", $localfile);
   } else {
     $err_code = create_filter();
     if (!$err_code) local_filter_get();
   }
   return $localfile;
}

function local_filter_exists() {
   $exists = invoke_filtercmd("rcexists filter", "", "");
   if ($exists == 0)
       return true;
   else
       return false;
}

function local_filter_put($file) {
   return invoke_filtercmd("putrc filter", $file, "");
   //unlink($file);
}

function local_write_forward($tmpfile) {
  return invoke_filtercmd("putrc forward", $tmpfile, "");
}


function get_password() {
    $key = ""; $onetimepad = "";
    sqgetGlobalVar('key', $key, SQ_COOKIE);
    sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
    return OneTimePadDecrypt($key, $onetimepad);
}

function invoke_filtercmd($argstring, $inputfile, $outputfile) {
      global $username;
      $command = escapeshellcmd("../plugins/serversidefilter/script/filtercmd $argstring");
      if ($outputfile) {
         $command .= " >$outputfile ";
      }
      
      $pipe = popen($command, "w");
      if (!$pipe) exit("Could not run $command");
      $password = get_password();
      fwrite($pipe, "$username\n$password\n");
      if ($inputfile) {
	 // copy the file to the pipe
         $handle = fopen($inputfile, "r");
         while ($data = fread($handle, 8192)) {
            fwrite($pipe, $data);
         }
         fclose($handle);
      }
      $result = pclose($pipe);
      // simulate WEXITSTATUS($result) -- this is not portable
      $result = $result / 256;

      //DEBUG: uncomment to help debug problems
      if ($result > 1) { 
         echo("$command -> $result<br>\n");
      //   echo("username: $username password: $password\n");
      }

      return $result;
}

/**
 * Procmail backend
 *
 */
function procmail_write_filter_recipie($fd, $action, $field, $string, $folder,
                                       $toFolder, $toAddress, $add_string, $matching) {
   global $default_folder_prefix, $USE_MAILDIRS;

   if ($action == "m" or $action == "d")
       $procaction2 = ":";
   else
       $procaction2 = "c:";

   $procaction1 = $procaction2;

   if ($USE_MAILDIRS) {
      $df = preg_replace("/\./",'',$default_folder_prefix);
      $folder = preg_replace("/$df/",'',$folder);
      $folder = $folder.'/';
   }

   $folder = '$MAILDIR'.$folder;

   //escape spaces
   $folder = preg_replace('/\s/', '\ ', $folder);

   if ($action == "d")
      $copystring = "/dev/null";
   elseif ($toFolder == 'on' && $toAddress == 'on') {
      $procaction1 = 'c:';
      $copystring = "$folder\n :0 A$procaction2\n! $add_string";
   }
   elseif ($toFolder == 'on')
      $copystring = "$folder";
   elseif ($toAddress == 'on')
      $copystring = "! $add_string";
   else
      $copystring = "";
  
   switch ($field) {
      case "TO_" :
         $field = "^(To|Cc):";
         $location = "H";
         break;
      case _("Body") :
         $field = "";
         $location = "B";
         break;
      case _("Any Header") :
         $field = "";
         $location = "H";
         break;
      case _("Anywhere") :
        $field = "";
        $location = "HB";
        break;
      default :
         $field = "^".preg_quote($field).":";
         $location = "H";
         break;
   }
 
   $string = preg_quote($string);
   switch ($matching) {
      case _("Contains") :
         $prefix = ".*";
         $suffix = "";
         break;
      case _("Begins With") :
         $prefix = " ";
         $suffix = "";
         break;
      case _("Ends With") :
         $prefix = ".*";
         $suffix = "$";
         break;
      case _("Is Exactly") :
        $prefix = " ";
        $suffix = "$";
        break;
      case _("Matches Regex") :
        $prefix = "";
        $suffix = "";
        $string = stripslashes($string);
        break;
      default :
        $prefix = ".*";
        $suffix = "";
        break;
   }
   fputs($fd, ":0${location}${procaction1}\n* ${field}${prefix}${string}${suffix}\n${copystring}\n");
}

function procmail_write_default_recipie($fd) {
   global $DEFAULT_DELIVERY;
   fputs($fd, "\n:0:\n${DEFAULT_DELIVERY}\n");
}

function procmail_write_spam_filter($fd) {
   global $username, $SPAMFILTER, $SPAMFILTERMAXKB;

   $spamfiltercmd = vd_replace($SPAMFILTER);
   if (isset($SPAMFILTERMAXKB) && $SPAMFILTERMAXKB > 0) {
     $bytes = $SPAMFILTERMAXKB * 1024;
     $rules = "* < $bytes\n";
   } else {
     $rules = "";
   }
   fputs($fd, "\n:0wf$rules\n| ${spamfiltercmd}\n");
}

function vd_replace($setting) {
   global $username, $VIRTUAL_DOMAINS, $SEPERATOR;
   if (isset($VIRTUAL_DOMAINS) && ($VIRTUAL_DOMAINS==1)) {
      list($user, $domain) = split($SEPERATOR,$username);
      $domuser = my_virtual_domain_user($domain);
   } else {
      $user = $username;
      $domain = '';
      $domuser = '';
   }
   return preg_replace(
      array('/\[DOMAIN\]/','/\[USERNAME\]/','/\[DOMUSER\]/'),
      array($domain,$user,$domuser),
      $setting
   );
}

/**
 * Maildrop backend
 *
 */
function maildrop_write_filter_recipie($fd, $action, $field, $string, $folder,
                                       $toFolder, $toAddress, $add_string, $matching) {
   global $default_folder_prefix;

   if ($action == "m" or $action == "d")
       $dropaction = "to";
   else
       $dropaction = "cc";

   $df = preg_replace("/\./",'',$default_folder_prefix);
   $folder = preg_replace("/$df/",'',$folder);
   $folder = '$MAILDIR/'.$folder;

   if ($action == "d") 
      $copystring = "to /dev/null";
   elseif ($toFolder == 'on' && $toAddress == 'on')
      $copystring = "cc \"$folder\"\n$dropaction \"!$add_string\"";
   elseif ($toFolder == 'on')
      $copystring = "$dropaction \"$folder\"";
   elseif ($toAddress == 'on')
      $copystring = "$dropaction \"!$add_string\"";
   else
      $copystring = "";

   switch ($field) {
      case "TO_" :
         $field = "^(To|Cc):";
         $location = "h";
         break;
      case _("Body") :
         $field = "";
         $location = "b";
         break;
      case _("Any Header") :
         $field = "";
         $location = "h";
         break;
      case _("Anywhere") :
        $field = "";
        $location = "w";
         break;
      default :
         $field = "^".preg_quote($field).":";
         $location = "h";
         break;
   }

   $string = preg_quote($string);
   switch ($matching) {
      case _("Contains") :
         $prefix = ".*";
         $suffix = "";
         break;
      case _("Begins With") :
         $prefix = " ";
         $suffix = "";
         break;
      case _("Ends With") :
         $prefix = ".*";
         $suffix = "$";
         break;
      case _("Is Exactly") :
        $prefix = " ";
        $suffix = "$";
        break;
      case _("Matches Regex") :
        $prefix = "";
        $suffix = "";
        $string = stripslashes($string);
        break;
      default :
        $prefix = ".*";
        $suffix = "";
        break;
   }
   fputs($fd, "if (/${field}${prefix}${string}${suffix}/:${location})\n{\n${copystring}\n}\n");
}

function maildrop_write_default_recipie($fd) {
   global $DEFAULT_DELIVERY;
   fputs($fd, "\nto \"${DEFAULT_DELIVERY}\"\n");
}

function maildrop_write_spam_filter($fd) {
   global $username, $SPAMFILTER, $SPAMFILTERMAXKB;

   $spamfiltercmd = vd_replace($SPAMFILTER);
   $maildropcmd = "\nxfilter \"${spamfiltercmd}\"\n";
   if (isset($SPAMFILTERMAXKB) && $SPAMFILTERMAXKB > 0) {
     $bytes = $SPAMFILTERMAXKB * 1024;
     $maildropcmd = "\n".'if ($SIZE < '.$bytes.")\n{".$maildropcmd."}\n";
   }
   fputs($fd, $maildropcmd);
}

/*
 * Recursive mkdir function taken from the PHP documentation
 *
 */
function mkdirs($strPath, $mode)
{
  if (is_dir($strPath)) return true;

  $pStrPath = dirname($strPath);
  if (!mkdirs($pStrPath, $mode)) return false;
  return mkdir($strPath, $mode);
}

?>
