#!/usr/bin/php -q
<?php

/* Serversidefilter config migration script -- run from command line.
 * 
 * Reads in config.php, and outputs settings on stdout.
 * The output does not include descriptive comments from the
 * config.php file.
 */

/*******************

New in 1.4.0:
FILTER_FILE_PATH
FORWARD_FILE_TYPE
FORWARD_FILE_PATH

Deprecated in 1.4.0:
FILTERDIR
CREATE_DOT_QMAIL
DOT_QMAIL_DIR
CREATE_DOT_FORWARD
DOT_FORWARD_DIR

Unchanged settings:
ALWAYS_CREATE
FILTER_APP_PATH
DEFAULT_DELIVERY
ALLOW_UNSUBSCRIBED
SPAMFILTER
SPAMHEADER
SPAMFILTERMAXKB
SPAMVALUE
UNSUREVALUE
VIRTUAL_DOMAINS
LOCAL_MAILDIR
USE_MAILDIRS
SEPERATOR

*******************/

/* Include the config.php file given as the argument. */
if ($argc != 2) {
  echo("USAGE: migrate_config.php config.php\n");
  exit(1);
}
include_once($argv[1]);

/* prepare the output file */
function begin_migration() {
  global $settings;
  $settings = array();
}
function end_migration() {
  // copy everything config.php -- when we see a line that matches a
  // setting, copy in the new value instead.

  global $settings;

  $orig = fopen("config.php", "r");
  $new = fopen("config.php.new", "w");
  $matches = array();
  while ($line = fgets($orig, 4096)) {
    if (preg_match(':^(\s+)(//\s*|)[$]([A-Z_]+)\s*=:', $line, $matches)) {
      $key = $matches[3]; $indent = $matches[1];
      if (array_key_exists($key, $settings)) {
        $newvalue = $settings[$key];
        if ($newvalue == "WRITTEN") {
          $line = "";
        } else {
          $line = $indent . str_replace("\n", $indent."\n", $newvalue);
          $settings[$key] = "WRITTEN";
        }
      }
    } else if (preg_match('/[?]>/', $line)) {
      // "end" of file, write any remaining settings.
      // Shouldn't get here normally, as the distributed config.php ought 
      // to have all settings we want.
      $line = "\n\n";
      foreach ($settings as $key => $value) {
         if ($value != "WRITTEN") {
           $line .= $value;
         }
      }
      $line .= "\n\n?>\n";
    }
    fputs($new, $line);
  }

  fclose($orig);
  fclose($new);
  echo("config.php.new written\n");
}

function output_setting($setting, $value, $commented, $notes) {
  output_raw_setting($setting, "'$value'", $commented, $notes);
}
function output_int_setting($setting, $value, $commented, $notes) {
  output_raw_setting($setting, $value, $commented, $notes);
}
function output_bool_setting($setting, $value, $commented, $notes) {
  output_raw_setting($setting, $value ? 'true' : 'false', $commented, $notes);
}
function output_raw_setting($setting, $value, $commented, $notes) {
  global $settings;
  $eol = "";
  if ($notes) {
    fputs($fd, "\n// $notes\n");
    $eol = "\n";
  }
  $settings[$setting] = ($commented ? '//' : '') . '$' . $setting . " = $value;\n$eol";
}


begin_migration();

/* Handle FILTER_FILE_PATH */
if (!isset($FILTER_FILE_PATH)) {
   // TODO: this code is not robust: should call output_broken_setting
   // if the calculations below fail.
   $FILTER_ARRY = explode("/", $FILTER_APP_PATH);
   $FILTER_APP = $FILTER_ARRY[count($FILTER_ARRY)-1];
   $FILTERAPP2FILE = array(
       "maildrop" => ".mailfilter", 
       "procmail" => ".procmailrc"
       );
   $FILTERFILE = $FILTERAPP2FILE[$FILTER_APP];
   $FILTER_FILE_PATH = "$FILTERDIR/$FILTERFILE";
}
output_setting('FILTER_FILE_PATH', $FILTER_FILE_PATH, 0, '');

/* Handle FORWARD_FILE_TYPE */
$notes = "";
if (!isset($FORWARD_FILE_TYPE)) {
   // if both are set, qmail wins; if neither, 'forward' wins.
   if (isset($CREATE_DOT_QMAIL) && $CREATE_DOT_QMAIL) {
     $FORWARD_FILE_TYPE = 'qmail';
   } else if (isset($CREATE_DOT_FORWARD) && $CREATE_DOT_FORWARD) {
     $FORWARD_FILE_TYPE = 'forward';
   } else {
    $notes .= "Which type applies is unclear: this is an arbitrary choice. ";
     $FORWARD_FILE_TYPE = 'forward';
    
  }
}
output_setting('FORWARD_FILE_TYPE', $FORWARD_FILE_TYPE, 0, $notes);


/* Handle FORWARD_FILE_PATH */
$notes = ""; $commented = 0;
if (!isset($FORWARD_FILE_PATH)) {
  if ($FORWARD_FILE_TYPE == 'qmail') {

    if (!isset($DOT_QMAIL_DIR)) {
      // make a wild guess
      $notes .= "This is a wild guess. ";
      $DOT_QMAIL_DIR = '/home/[USERNAME]/';
    }

    // this logic matches what is in lines 79-88 in functions.php r1.10
    if (isset($VIRTUAL_DOMAINS) && $VIRTUAL_DOMAINS) {     
      $QMAIL_FILE = '.qmail-[USERNAME]';
    } else {
      $QMAIL_FILE = '.qmail';
    }
    $FORWARD_FILE_PATH = "$DOT_QMAIL_DIR/$QMAIL_FILE";
    $create = isset($CREATE_DOT_QMAIL) && $CREATE_DOT_QMAIL;
  } else {
    if (!isset($DOT_FORWARD_DIR)) {
      // make a wild guess
      $notes .= "This is a wild guess. ";
      $DOT_FORWARD_DIR = '/home/[USERNAME]/';
    }
    $FORWARD_FILE_PATH = "$DOT_FORWARD_DIR/.forward";
    $create = isset($CREATE_DOT_FORWARD) && $CREATE_DOT_FORWARD;
 }
  if (!$create) {
   $commented = 1;
   $notes .= "Uncomment to enable writing .$FORWARD_FILE_TYPE files. ";
  }
}
output_setting('FORWARD_FILE_PATH', $FORWARD_FILE_PATH, $commented, $notes);

/* handle all of the rest of the settings */
output_bool_setting('ALWAYS_CREATE', $ALWAYS_CREATE, 0, '');
output_setting('FILTER_APP_PATH', $FILTER_APP_PATH, 0, '');
output_setting('DEFAULT_DELIVERY', $DEFAULT_DELIVERY, !isset($DEFAULT_DELIVERY), '');
output_bool_setting('ALLOW_UNSUBSCRIBED', $ALLOW_UNSUBSCRIBED, 0, '');
output_setting('SPAMFILTER', $SPAMFILTER, !isset($SPAMFILTER), '');
output_setting('SPAMHEADER', $SPAMHEADER, 0, '');
output_int_setting('SPAMFILTERMAXKB', $SPAMFILTERMAXKB, !isset($SPAMFILTERMAXKB), '');
output_setting('SPAMVALUE', $SPAMVALUE, 0, '');
if (isset($UNSUREVALUE)) {
  output_setting('UNSUREVALUE', $UNSUREVALUE, 0, '');
} else {
  output_setting('UNSUREVALUE', 'Unsure', 1, '');
}
output_bool_setting('VIRTUAL_DOMAINS', $VIRTUAL_DOMAINS, 0, '');
output_bool_setting('LOCAL_MAILDIR', $LOCAL_MAILDIR, 0, '');
output_bool_setting('USE_MAILDIRS', $USE_MAILDIRS, 0, '');
output_setting('SEPERATOR', $SEPERATOR, 0, '');

end_migration();

?>

