<?php
/*
 *	ServerSideFilter - ServerSide mail filter plugin for SquirrelMail
 *	By Patrick Swieskowski, Rick Sheaffer, and Jon Stroud
 */


	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'plugins/serversidefilter/backend.php');
	}
	else
	{
		include_once ('../plugins/serversidefilter/backend.php');
	}

/* 
 * Filter functions
 *   These are the functions you call to get or write the filter files
 *   These simply call the only available backend, "local"
 */
function filter_get() {   
   return local_filter_get();
}

function filter_exists() {
   return local_filter_exists();
}

function filter_put($file) {
   return local_filter_put($file);
}


function write_forward() {
   global $username, $FILTER_FILE_PATH, $FORWARD_FILE_TYPE, $FILTER_APP_PATH;

   $tmpfile = "/tmp/forwardfile-$username";

   $fd = fopen($tmpfile,"w");
   $filterpath = vd_replace($FILTER_FILE_PATH);
   $contents_array = array(
     "qmail" => "|preline $FILTER_APP_PATH $filterpath\n",
     "forward" => "|$FILTER_APP_PATH $filterpath\n"
     );
   $contents = $contents_array[$FORWARD_FILE_TYPE];
   fwrite($fd, $contents);
   fclose($fd);

   $result = local_write_forward($tmpfile);
}

/**
 * Create Filter files
 *   This function is used to write the application specific function to the filter file
 */

function set_filter_app () {
   global $FILTER_APP_PATH, $FILTER_APP;

   $FILTER_ARRY = explode("/", $FILTER_APP_PATH);
   $FILTER_APP = $FILTER_ARRY[count($FILTER_ARRY)-1];
}

function write_filter_recipie($fd, $action, $field, $string, $folder, 
                              $toFolder, $toAddress, $add_string, $matching) {
   global $FILTER_APP;
   
   $wr_filter = $FILTER_APP.'_write_filter_recipie';
   $wr_filter($fd, $action, $field, $string, $folder,
              $toFolder, $toAddress, $add_string, $matching);
}

/*
 * This function is used to write a default delivery action
 */
function write_default_recipie($fd) {
   global $FILTER_APP, $DEFAULT_DELIVERY;
   
   if(isset($DEFAULT_DELIVERY) && $DEFAULT_DELIVERY != '') {
      $wr_default = $FILTER_APP.'_write_default_recipie';
      $wr_default($fd);
   }
}

function write_spam_filter($fd) {
   global $FILTER_APP;
   
   $wr_spam_filter = $FILTER_APP.'_write_spam_filter';
   $wr_spam_filter($fd);
}

/**
 * Virtual domain functions
 *    These functions pertain to information necessary when working with virtual domains
 */

// get the owner of a virtual domain
function my_virtual_domain_user($domain) {
    $vfile = "../plugins/serversidefilter/virtualdomains";
    if (!file_exists($vfile) || !is_readable($vfile)){
       return false;
    }
    $fd = fopen($vfile, 'r');
    $contents = fread($fd, filesize($vfile));
    $contents = rtrim($contents);
    if (strlen($contents) > 0){
        $domuary = explode("\n", $contents);
        foreach ($domuary as $domu){
            list($dom,$user) = split(':', $domu);
            if ($dom == $domain) break;
        }
        if ($dom == $domain) return $user;
        else return false;
    } else {
        return false;
    }
}

?>
