<?php
	// include compatibility plugin
	//
	if (defined('SM_PATH'))
		include_once(SM_PATH . 'plugins/compatibility/functions.php');
	else if (file_exists('../plugins/compatibility/functions.php'))
		include_once('../plugins/compatibility/functions.php');
	else if (file_exists('./plugins/compatibility/functions.php'))
		include_once('./plugins/compatibility/functions.php');



	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'plugins/serversidefilter/config.php');
		include_once (SM_PATH . 'plugins/serversidefilter/functions.php');
	}
	else
	{
		include_once ('../plugins/serversidefilter/config.php');
		include_once ('../plugins/serversidefilter/functions.php');
	}

	// Display dropdown menu of field options

	function fieldDropdown($str) {
		global $fields;

		print("<select name=field>\n");

		for ($i = 0; $i < count($fields); $i++) {
			print("<option value=\"$i\"");
			if ($fields[$i] == $str)
				print(" selected");
			if ($fields[$i] == "TO_")
				print(">" . _("To or Cc") . "</option>\n");
			else
				print(">$fields[$i]</option>\n");
		}

		print("</select>\n");
	}

	// Display dropdown menu of folder options

	function folderDropdown($str) {
		global $folders;

		print("<select name=folder>\n");

		for ($i = 0; $i < count($folders); $i++) {
			print("<option value=\"$i\"");
			if ($folders[$i] == $str)
				print(" selected");
			print(">$folders[$i]</option>\n");
		}
		
		print("</select>\n");
	}


        function matchingDropdown($str) {
                global $matching;

                print("<select name=matching>\n");

                for ($i = 0; $i < count($matching); $i++) {
                        print("<option value=\"$i\"");
                        if ($matching[$i] == $str)
                                print(" selected");
                        print(">$matching[$i]</option>\n");
                }

                print("</select>\n");
        }

	function read_recipies($file) {
		global $recipies, $spamrule_set, $unsurerule_set, $SPAMHEADER, $SPAMVALUE, $UNSUREVALUE;
	
                $buf = '';

		if ($fd = fopen($file, 'r'))
		while (!feof($fd) && $buf != "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail")
			$buf = rtrim(fgets($fd, 4096));

		while (!feof($fd) && $buf != "##End Filter Configuration") {
			$buf = fgets($fd, 4096);
			if (substr($buf, 0, 3) == "###") {
				$tmp = explode(" '' ", substr($buf, 3));
				$new['field'] = stripslashes($tmp[0]);
				$new['string'] = stripslashes($tmp[1]);
                                if ($new['field'] == $SPAMHEADER) {
				   if ($new['string'] == $SPAMVALUE) $spamrule_set = true;
				   if ($new['string'] == $UNSUREVALUE) $unsurerule_set = true;
                                }
				$new['folder'] = stripslashes($tmp[2]);
				$new['action'] = stripslashes($tmp[3]);
                                if (isset($tmp[4])) $new['toFolder'] = stripslashes($tmp[4]);
                                else $new['toFolder'] = 'on';
				if (isset($tmp[5])) $new['toAddress'] = stripslashes($tmp[5]);
                                else $new['toAddress'] = 'off';
                                if (isset($tmp[6])) $new['add_string'] = stripslashes($tmp[6]);
                                else $new['add_string'] = "";
                                if (isset($tmp[7])) $new['matching'] = stripslashes(trim($tmp[7]));
                                else $new['matching'] = "Contains";
                                array_push($recipies, $new);
			}
		}

		fclose($fd);
	}

	// Write the recipes in the recipies array
	
	function write_recipies($oldfile, $newfile) {
		global $username, $recipies, $SEPERATOR, $SPAMFILTER, $SPAMHEADER, $UNSUREVALUE, $SPAMVALUE,
                       $VIRTUAL_DOMAINS, $LOCAL_MAILDIR, $FILE_BACKEND, $FORWARD_FILE_PATH;

                if (isset($VIRTUAL_DOMAINS) && $VIRTUAL_DOMAINS==1)
                   list($user, $domain) = split($SEPERATOR,$username);
                else {
                   $user = $username;
                   $domain = '';
                }
               
		$MAILDIR = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$LOCAL_MAILDIR);
		
		$of = fopen($oldfile, 'r');
		$nf = fopen($newfile, 'w');

		$buf = rtrim(fgets($of, 4096));
		while (!feof($of) && $buf != "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail") {
			fputs($nf, "$buf\n");
			$buf = rtrim(fgets($of, 4096));
		}


		fputs($nf, "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail\n");
		fputs($nf, "MAILDIR=$MAILDIR # Default mail directory\n");

                if (isset($SPAMFILTER) && $SPAMFILTER != '')
                   write_spam_filter($nf);

		for ($i = 0; $i < count($recipies); $i++) {
			$field = $recipies[$i]['field'];
			$string = $recipies[$i]['string'];
			$folder = $recipies[$i]['folder'];
                        $action = $recipies[$i]['action'];
                        $toFolder = $recipies[$i]['toFolder'];
                        $toAddress = $recipies[$i]['toAddress'];
                        $add_string = $recipies[$i]['add_string'];
			$matching = $recipies[$i]['matching'];

			$ssfield = addslashes($recipies[$i]['field']);
			$ssstring = addslashes($recipies[$i]['string']);
			$ssfolder = addslashes($recipies[$i]['folder']);
			$ssaction = addslashes($recipies[$i]['action']);
                        $sstoFolder = addslashes($recipies[$i]['toFolder']);
                        $sstoAddress = addslashes($recipies[$i]['toAddress']);
                        $ssadd_string = addslashes($recipies[$i]['add_string']);
			$ssmatching = addslashes($recipies[$i]['matching']);

			fputs($nf, "\n###${ssfield} '' ${ssstring} '' ${ssfolder} '' ${ssaction} '' ${sstoFolder} '' ${sstoAddress} '' ${ssadd_string} '' ${ssmatching} \n");
                        write_filter_recipie($nf, $action, $field, $string, $folder, 
                                             $toFolder, $toAddress, $add_string, $matching);
		}

                write_default_recipie($nf);

		fputs($nf, "\n##End Filter Configuration\n");


		while (!feof($of) && $buf != "##End Filter Configuration")
			$buf = rtrim(fgets($of,4096));

		while (!feof($of)) {
			$buf = fgets($of,4096);
			fputs($nf, "$buf");
		}

		fclose($of);
		fclose($nf);
                
                if (isset($FORWARD_FILE_PATH))
                    write_forward();

	}

	function create_filter() {
		global $username, $SEPERATOR, $SPAMFILTER, 
                       $VIRTUAL_DOMAINS, $LOCAL_MAILDIR, $FILE_BACKEND;

                if (isset($VIRTUAL_DOMAINS) && $VIRTUAL_DOMAINS==1)
                   list($user, $domain) = split($SEPERATOR,$username);
                else {
                   $user = $username;
                   $domain = '';
                }

                $MAILDIR = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$LOCAL_MAILDIR);

                $file = "/tmp/filterfile.$username";
		$nf = fopen($file, "w");

                $header = "";
                $footer = "";
                if (file_exists("../plugins/serversidefilter/skeleton/header")) {
                    $header_ary = file("../plugins/serversidefilter/skeleton/header"); 
                    foreach ($header_ary as $line)
                        $header = $header . $line;
                }
                if (file_exists("../plugins/serversidefilter/skeleton/footer")) {
                    $footer_ary = file("../plugins/serversidefilter/skeleton/footer");
                    foreach ($footer_ary as $line)
                        $footer = $footer . $line;
                }

                fputs($nf, $header);
		fputs($nf, "##Begin Filter Configuration -- Please do not edit by hand, use SquirrelMail\n");
		fputs($nf, "MAILDIR=$MAILDIR # Default mail directory\n");

                if (isset($SPAMFILTER) && $SPAMFILTER != '')
                   write_spam_filter($nf);

                write_default_recipie($nf);
		fputs($nf, "\n##End Filter Configuration\n");
                fputs($nf, $footer);
		fclose($nf);
		$err_code = filter_put($file);
                if (isset($FORWARD_FILE_PATH) and !$err_code)
                    $err_code = write_forward();
                return $err_code;
	}

	// Print the recipies

	function print_recipies() {
		global $recipies, $color, $SPAMHEADER, $SPAMVALUE, $UNSUREVALUE;

                $bgcolor = $color[0];
		for ($i = 0; $i < count($recipies); $i++) {
			$str = $recipies[$i]['string'];
                        $toFolder = '';
                        $toAddress = '';
                        if ($recipies[$i]['toFolder'] == 'on') $toFolder = 'checked';
                        if ($recipies[$i]['toAddress'] == 'on') $toAddress = 'checked';
                        $add = $recipies[$i]['add_string'];

			print("<form method=post action=\"options.php\"><input type=hidden name=rule value=\"$i\">\n");
			print("<tr><td align=right valign=top>");
			if ($recipies[$i]['field'] == $SPAMHEADER) {
                           print('<input type=hidden name=field value="' . $SPAMHEADER . '">');
                           print('<input type=hidden name=matching value="0">');
                           if ($recipies[$i]['string'] == $UNSUREVALUE) {
                              print('<input type=hidden name=string value="'.$UNSUREVALUE.'">');
                              print(_("If message is marked as") . ' <b>' . _("UNSURE") . '</b> ' . _("then") . " ");
                           } else {
                              print('<input type=hidden name=string value="'.$SPAMVALUE.'">');
                              print(_("If message is marked as") . ' <b>' . _("SPAM") . '</b> ' . _("then") . " ");
                           }
                        } else {
                           print(_("If") . " ");
  			   fieldDropdown($recipies[$i]['field']);
                           matchingDropdown($recipies[$i]['matching']);
			   print(" <input type=text name=string size=10 value=\"$str\"> " . _("then") . " ");
                        }
			print("<select name=action>\n");

			if ($recipies[$i]['action'] == "m")
				print("<option value=m selected>" . _("move") . "</option>\n<option value=c>" . _("copy") . "</option>\n<option value=d>" . _("delete") . "</option>\n");
			else if ($recipies[$i]['action'] == "c")
				print("<option value=m>" . _("move") . "</option>\n<option value=c selected>" . _("copy"). "</option>\n<option value=d>" . _("delete") . "</option>\n");
                        else
                                print("<option value=d>" . _("delete") . "</option>\n<option value=m>" . _("move") . "</option>\n<option value=c selected>" . _("copy"). "</option>\n");

			print("</select>\n " . _("to") . "</td>");
                        print("<td><table border=0 cellspacing=0 cellpadding=0>");
                        print("<tr>");
                        print("<td><input type=checkbox name=toFolder $toFolder>" . _("Folder") . "&nbsp;&nbsp;</td>");
                        print("<td>"); folderDropdown($recipies[$i]['folder']); print("</td>");
                        print("</tr><tr>");
                        print("<td><input type=checkbox name=toAddress $toAddress>" . _("Email") . "&nbsp;&nbsp;</td>");
                        print("<td><input type=text name=add_string value=\"$add\"></td>");
                        print("</td></table>");
			print("\n</td>\n");
			print("<td valign=top><input type=image src=\"images/save.gif\" border=0 name=modify alt=\"save\"></td>\n");
			print("<td valign=top><input type=image src=\"images/delete.gif\" border=0 name=delete alt=\"delete\"></td>\n");

			// Let's not display the move arrows if they're not needed
			if (count($recipies) == 1) {
				print("<td>&nbsp;</td>\n<td>&nbsp;</td>\n");
			} else if ($i == 0) {
				print("<td colspan=2 align=center valign=top><input type=image src=\"images/down.gif\" border=0 name=down alt=\"move down\"></td>\n");
			} else if ($i == count($recipies)-1) {
				print("<td colspan=2 align=center valign=top><input type=image src=\"images/up.gif\" border=0 name=up alt=\"move up\"></td>\n");
			} else {
				print("<td valign=top><input type=image src=\"images/up.gif\" border=0 name=up alt=\"move up\"></td>\n");
				print("<td valign=top><input type=image src=\"images/down.gif\" border=0 name=down alt=\"move down\"></td>\n");
			}

			print("</tr></form>\n");
		}
                return $i;
	}
?>
