<?php
/*
 *	ServerSideFilter - ServerSide mail filter plugin for SquirrelMail
 *	By Patrick Swieskowski, Rick Sheaffer, and Jon Stroud
 */


	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'plugins/serversidefilter/backend.php');
	}
	else
	{
		include_once ('../plugins/serversidefilter/backend.php');
	}
/* 
 * Filter functions
 *   The are the functions you call to get or write the filter files
 *   The backend implementation is called from within these functions
 *   The backend definitions are backend.php
 */
function filter_get() {
   global $FILE_BACKEND;
   $filter_get = $FILE_BACKEND.'_filter_get';
   return $filter_get();
}

function filter_exists(){
   global $FILE_BACKEND;
   $filter_exists = $FILE_BACKEND.'_filter_exists';
   return $filter_exists();
}

function filter_put($file) {
   global $FILE_BACKEND;
   $filter_put = $FILE_BACKEND.'_filter_put';
   return $filter_put($file);
}

function write_dot_qmail() {
   global $username, $SEPERATOR, $VIRTUAL_DOMAINS, $FILE_BACKEND,
          $FILTERDIR, $FILTERFILE, $FILTER_APP_PATH;
 
   $tmpfile = "/tmp/.qmail-$username";
   if ($VIRTUAL_DOMAINS) list($user,$domain) = split($SEPERATOR,$username);
   else $user = $username;
   $fd = fopen($tmpfile,"w");
   $filterpath = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$FILTERDIR);
   $filterfile = "$filterpath/$FILTERFILE";
   $contents = "|preline $FILTER_APP_PATH $filterfile\n";
   fwrite($fd, $contents);
   fclose($fd);
   $write_dot_qmail = $FILE_BACKEND.'_write_dot_qmail';
   $write_dot_qmail($tmpfile);
   unlink($tmpfile);
}

/**
 * Create Filter files
 *   This function is used to write the application specific function to the filter file
 */

function write_filter_recipie($fd, $action, $field, $string, $folder, 
                              $toFolder, $toAddress, $add_string) {
   global $FILTER_APP;
   
   $wr_filter = $FILTER_APP.'_write_filter_recipie';
   $wr_filter($fd, $action, $field, $string, $folder,
              $toFolder, $toAddress, $add_string);
}

/*
 * This function is used to write a default delivery action
 */
function write_default_recipie($fd) {
   global $FILTER_APP, $DEFAULT_DELIVERY;
   
   if(isset($DEFAULT_DELIVERY) && $DEFAULT_DELIVERY != '') {
      $wr_default = $FILTER_APP.'_write_default_recipie';
      $wr_default($fd);
   }
}

function write_spam_filter($fd) {
   global $FILTER_APP;
   
   $wr_spam_filter = $FILTER_APP.'_write_spam_filter';
   $wr_spam_filter($fd);
}

/**
 * Virtual domain functions
 *    These functions pertain to information necessary when working with virtual domains
 */

// Get the list of vitual domains
function my_list_virtual_domains() {
   global $VD_BACKEND;
   $list_vd = $VD_BACKEND.'_list_virtual_domains';
   return $list_vd();
}

// get the owner of a virtual domain
function my_virtual_domain_user($domain) {
   global $VD_BACKEND;
   $vd_user = $VD_BACKEND.'_virtual_domain_user';
   return $vd_user($domain);
}

// check to see if the password is saved
function check_pass($domain){
    global $STORAGE_DIR, $FILE_BACKEND;
    
    $vdomain = preg_replace('/\./','_',$domain);
    $file = "$STORAGE_DIR/$vdomain";
    if (file_exists($file) && is_file($file)) {
       $ckpass = $FILE_BACKEND.'_check_pass';
       $user = my_virtual_domain_user($domain);
       $pass = my_get_domain_passwd($domain);
       return $ckpass($user,$pass);
    } else
       return false;
}


/**
 * This function will return a stored domain password or false if
 * there isn't one.
 *
 * @param $domain  a vadmin domain.
 * @return         the domain password stored in $domain/passwd, or
 *                 false if that file is empty.
 */
function my_get_domain_passwd($domain){
    global $STORAGE_DIR;
    
    $mydomain = preg_replace('/\./','_',$domain);
    $file = "$STORAGE_DIR/$mydomain";
    if (file_exists($file) && is_file($file)) {
        $fd = fopen($file,'r'); 
        $contents = fread($fd, filesize($file));
        $contents = rtrim($contents);
        $clearpass = my_crypto($contents, 'decrypt');
        return $clearpass;
    } else return false;
}

// store the domain password to a file
function my_put_domain_passwd($domain, $clearpass){
    global $STORAGE_DIR;
    
    $file = "$STORAGE_DIR/$domain";
    $fd = fopen($file,'w'); 
    $encpass = my_crypto($clearpass, 'encrypt');
    fwrite($fd,$encpass);
    fclose($fd);
}


?>
