<?php
/*
 *	ServerSideFilter - ServerSide mail filter plugin for SquirrelMail
 *	By Patrick Swieskowski, Rick Sheaffer, and Jon Stroud
 */

	chdir('..');
	define('SM_PATH','../');



	// include compatibility plugin
	//
	if (defined('SM_PATH'))
		include_once(SM_PATH . 'plugins/compatibility/functions.php');
	else if (file_exists('../plugins/compatibility/functions.php'))
		include_once('../plugins/compatibility/functions.php');
	else if (file_exists('./plugins/compatibility/functions.php'))
		include_once('./plugins/compatibility/functions.php');



	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'include/validate.php');
		include_once (SM_PATH . 'functions/page_header.php');
		include_once (SM_PATH . 'functions/imap.php');
		include_once (SM_PATH . 'include/load_prefs.php');
		include_once (SM_PATH . 'plugins/serversidefilter/config.php');
		include_once (SM_PATH . 'plugins/serversidefilter/functions.php');
	}
	else
	{
		include_once ('../src/validate.php');
		include_once ('../functions/page_header.php');
		include_once ('../functions/imap.php');
		include_once ('../src/load_prefs.php');
		include_once ('../plugins/serversidefilter/config.php');
		include_once ('../plugins/serversidefilter/functions.php');
	}


	global $username, $key, $imapServerAddress, $imapPort;
	global $fields, $folders, $imapConnection, $imap_stream;
	global $recipies;

	compatibility_sqextractGlobalVar('onetimepad');
	compatibility_sqextractGlobalVar('delimiter');

	// get global variables for versions of PHP < 4.1
	//
	if (!compatibility_check_php_version(4, 1)) {
		global $HTTP_COOKIE_VARS, $HTTP_POST_VARS;
		$_COOKIE = $HTTP_COOKIE_VARS;
		$_POST = $HTTP_POST_VARS;
	}

        if (array_key_exists('savepass', $_POST)) {
           $domains = my_list_virtual_domains();
           foreach($domains as $domain) {
              $domain = preg_replace('/\./','_',$domain);
              $domainpass = $_POST[$domain];
              if ($domainpass != '******' && $domainpass != '') my_put_domain_passwd($domain, $domainpass); 
           }
           header("Location: options.php");
        } 
        else 
            displayPageHeader($color, 'None');
?>
<br>
<table width="95%" align=center border=0 cellpadding=2 cellspacing=0>
<tr><td align="center" bgcolor="<?php echo  $color[0] ?>">
	<b><?php echo _("Administration") . " - " . _("Mail Filters"); ?></b>

<table width="100%" border=0 cellpadding=1 cellspacing=1>
<tr><td bgcolor="<?php echo  $color[4] ?>" align=center><br>
<?php echo _("This form allows the administrator to set the domain passwords which will be stored encrypted.
This will allow files to be moved into the appropriate directories if virtual domains are enabled.") . "<br>" .
_("Leave the entry blank if you do not want to change the password.")?>
<form method=post action="admin.php">
<table border=0 cellpadding=1 cellspacing=3>
<input type=hidden name="savepass" value=1>

<?php
  $domains = my_list_virtual_domains();
  $body = '';
  foreach($domains as $domain) {
     if (check_pass($domain)) $passval='value="******"';
     else $passval='';
     $body .= "<tr><td>$domain:</td><td><input type=password name=\"$domain\" $passval>";
  }
  $body .= '<tr><td colspan=2 align=center><input type=submit></td></tr>';
  echo $body;

?>
</table></td></tr></table></body></html>
