<?php

/*
 *	ServerSideFilter - ServerSide mail filter plugin for SquirrelMail
 *	By Patrick Swieskowski, Rick Sheaffer, and Jon Stroud
 */

	chdir('..');
	define('SM_PATH','../');



	// include compatibility plugin
	//
	if (defined('SM_PATH'))
		include_once(SM_PATH . 'plugins/compatibility/functions.php');
	else if (file_exists('../plugins/compatibility/functions.php'))
		include_once('../plugins/compatibility/functions.php');
	else if (file_exists('./plugins/compatibility/functions.php'))
		include_once('./plugins/compatibility/functions.php');



	if (compatibility_check_sm_version(1, 3))
	{
		include_once (SM_PATH . 'include/validate.php');
		include_once (SM_PATH . 'functions/page_header.php');
		include_once (SM_PATH . 'functions/imap.php');
		include_once (SM_PATH . 'include/load_prefs.php');
		include_once (SM_PATH . 'plugins/serversidefilter/config.php');
		include_once (SM_PATH . 'plugins/serversidefilter/recipie_functions.php');
	}
	else
	{
		include_once ('../src/validate.php');
		include_once ('../functions/page_header.php');
		include_once ('../functions/imap.php');
		include_once ('../src/load_prefs.php');
		include_once ('../plugins/serversidefilter/config.php');
		include_once ('../plugins/serversidefilter/recipie_functions.php');
	}


	global $username, $key, $imapServerAddress, $imapPort;
	global $fields, $folders, $imapConnection, $imap_stream;
	global $recipies;

	compatibility_sqextractGlobalVar('onetimepad');
	compatibility_sqextractGlobalVar('delimiter');

	// get global variables for versions of PHP < 4.1
	//
	if (!compatibility_check_php_version(4, 1)) {
		global $HTTP_COOKIE_VARS, $HTTP_POST_VARS;
		$_COOKIE = $HTTP_COOKIE_VARS;
		$_POST = $HTTP_POST_VARS;
	}

	$key = $_COOKIE['key'];

	$fields = array("From", "Subject", "To", "Cc", "TO_");
        $spamrule_set = false;

	// figure out if we're already connected to IMAP server
	//
	if (!isset($imap_stream) && !isset($imapConnection)) {
		$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
		$previously_connected = false;
	} elseif (isset($imapConnection)) {
		$previously_connected = true;
	} else {
		$previously_connected = true;
		$imapConnection = $imap_stream;
	}

	$boxes = sqimap_mailbox_list($imapConnection);

	if (!$previously_connected) 
		sqimap_logout($imapConnection);

	$folders = array();
	for ($i = 0; $i < count($boxes); $i++)
		if (!in_array('noselect', $boxes[$i]['flags']))
			array_push($folders, $boxes[$i]['unformatted']);

	$recipies = array();

	$file = filter_get();
	read_recipies($file);

	if (array_key_exists('create_x', $_POST)) {

		// Create a new entry
                if ($_POST['field'] == 'X-Spam-Flag')
                   $new['field'] = 'X-Spam-Flag';
                else
		   $new['field'] = $fields[$_POST['field']];
		$new['string'] = $_POST['string'];
		if (get_magic_quotes_gpc() == 1)
			$new['string'] = stripslashes($new['string']);
		$new['folder'] = $folders[$_POST['folder']];
		$new['action'] = $_POST['action'];
                if (isset($_POST['toFolder']))
                   $new['toFolder'] = 'on';
                else
                   $new['toFolder'] = 'off';
                if (isset($_POST['toAddress']))
                   $new['toAddress'] = 'on';
                else
                   $new['toAddress'] = 'off';
		if ($_POST['add_string'] != null)
		$new['add_string'] = $_POST['add_string'];
                if (get_magic_quotes_gpc() == 1)
                   $new['add_string'] = stripslashes($new['add_string']);
		else $new['add_string'] = "";
		array_push($recipies, $new);
		write_recipies($file, "/tmp/$FILTERFILE.$username.tmp");
		filter_put("/tmp/$FILTERFILE.$username.tmp");
		unlink("/tmp/$FILTERFILE.$username.tmp");
	} elseif (array_key_exists('modify_x', $_POST)) {
		// Modify an existing entry
                if ($_POST['field'] == 'X-Spam-Flag')
                   $recipies[$_POST['rule']]['field'] = 'X-Spam-Flag';
                else
		   $recipies[$_POST['rule']]['field'] = $fields[$_POST['field']];
		$recipies[$_POST['rule']]['string'] = $_POST['string'];
		if (get_magic_quotes_gpc() == 1)
			$recipies[$_POST['rule']]['string'] = stripslashes($_POST['string']);
		$recipies[$_POST['rule']]['folder'] = $folders[$_POST['folder']];
		$recipies[$_POST['rule']]['action'] = $_POST['action'];
                if (isset($_POST['toFolder']))
                   $recipies[$_POST['rule']]['toFolder'] = 'on';
                else
                   $recipies[$_POST['rule']]['toFolder'] = 'off';
                if (isset($_POST['toAddress']))
                   $recipies[$_POST['rule']]['toAddress'] = 'on';
                else
                   $recipies[$_POST['rule']]['toAddress'] = 'off';
                $recipies[$_POST['rule']]['add_string'] = $_POST['add_string'];
		write_recipies($file, "/tmp/$FILTERFILE.$username.tmp");
		filter_put("/tmp/$FILTERFILE.$username.tmp");
		unlink("/tmp/$FILTERFILE.$username.tmp");
	} elseif (array_key_exists('delete_x', $_POST)) {

		// Delete an entry
		$recipies = array_merge(array_slice($recipies, 0, $_POST['rule']), array_slice($recipies, $_POST['rule']+1));
		write_recipies($file, "/tmp/$FILTERFILE.$username.tmp");
		filter_put("/tmp/$FILTERFILE.$username.tmp");
		unlink("/tmp/$FILTERFILE.$username.tmp");
	} elseif (array_key_exists('up_x', $_POST)) {

		// Move an entry up
		if ($_POST['rule'] > 0) {
			$tmp = $recipies[$_POST['rule']];
			$recipies[$_POST['rule']] = $recipies[$_POST['rule']-1];
			$recipies[$_POST['rule']-1] = $tmp;
  		        write_recipies($file, "/tmp/$FILTERFILE.$username.tmp");
		        filter_put("/tmp/$FILTERFILE.$username.tmp");
		        unlink("/tmp/$FILTERFILE.$username.tmp");
		}
	} elseif (array_key_exists('down_x', $_POST)) {

		// Move an entry down 
		if ($_POST['rule'] < count($recipies)-1) {
			$tmp = $recipies[$_POST['rule']];
			$recipies[$_POST['rule']] = $recipies[$_POST['rule']+1];
			$recipies[$_POST['rule']+1] = $tmp;
  		        write_recipies($file, "/tmp/$FILTERFILE.$username.tmp");
		        filter_put("/tmp/$FILTERFILE.$username.tmp");
		        unlink("/tmp/$FILTERFILE.$username.tmp");
		}
	}

        unlink($file);		
	displayPageHeader($color, 'None');
?>
<br>
<table width="95%" align=center border=0 cellpadding=2 cellspacing=0>
<tr><td align="center" bgcolor="<?php echo  $color[0] ?>">
	<b><?php echo _("Options") . " - " . _("Mail Filters"); ?></b>

<table width="100%" border=0 cellpadding=1 cellspacing=1>
<?php
        if (in_array($username, $ADMIN) && $VIRTUAL_DOMAINS && ($FILE_BACKEND == 'ftp')) {
           echo "<tr><td bgcolor=$color[4] align=center><br>";
           echo '<center><a href=admin.php>Admin - Set Domain Passwords</a></center>';
           $vdomains = my_list_virtual_domains();
           $goodpass = true;
           foreach($vdomains as $vdomain) {
              if (!check_pass($vdomain)) {
                 echo "<center>" . _("Passwords out of date") . "</center>";
                 $goodpass = false;
                 break;
              }
           }
           if ($goodpass) echo "<center>" . _("Passwords are all up to date") . "</center>";
           echo "<br></td></tr>";
        }
?>
<tr><td bgcolor="<?php echo  $color[4] ?>" align=center><br>
<table border=1 frame=void rules=rows noshade=0 bordercolor=<?php echo $color[0]?> cellpadding=5 cellspacing=0>
<?php
     if ($VIRTUAL_DOMAINS && ($FILE_BACKEND == 'ftp')) {
        list($vuser,$vdomain) = split($SEPERATOR,$username);
        if (!check_pass($vdomain)) {
            echo  _("Your domain") . " ($vdomain) " . _("password is out of date.  Your administrator will need to correct this before you may setup your mailfilters.");
            exit;
        }
     }
     $value = count($recipies);
?>
<tr><td bgcolor="<?php echo  $color[4] ?>" align=center colspan=6>
<table border=4 rules=rows noshade=0 bordercolor=<?php echo $color[0]?> cellpadding=5 cellspacing=0>
<tr><td colspan=6 align=center><b><?php echo _("Enter A New Filter:")?></td></tr>
<form method=post action="options.php">
<input type=hidden name="create.x" value="<?php print($value++)?>">
<tr><td align=right valign=top>
<?php echo _("If") . " "; echo fieldDropdown('') . " " . _("contains") . " <input type=text name=string size=10> " . _("then") . " " ?>
<select name=action>
<option value=m>move</option>
<option value=c>copy</option>
</select>
 to 
</td><td><table border=0 cellpadding=0 cellspacing=0>
<tr>
<td><input type=checkbox name=toFolder checked><?php echo _("Folder")?>&nbsp;&nbsp;</td>
<td><?php echo  folderDropdown('') ?></td>
</tr>
<tr>
<td><input type=checkbox name=toAddress><?php echo _("Email")?>&nbsp;&nbsp;</td>
<td><input type=text name=add_string></td>
</tr>
</table>
</td>
<td align=center valign=top><input type=image src="images/saveas.gif" border=0 name=create alt="save new"></td>
</tr>
</form>
<?php
      if (!$spamrule_set && isset($SPAMFILTER) && $SPAMFILTER != '') {
         echo  '<form method=post action="options.php">'
              .'<input type=hidden name="create.x" value="'.$value.'">'
              .'<tr><td align=right valign=top>'
              .'<input type=hidden name=field value="X-Spam-Flag">'
              .'<input type=hidden name=string value="YES">'
              ._("if message is marked as").' <b>'._("SPAM").'</b> '._("then")
              .' <select name=action>'
              .'<option value=m>move</option>'
              .'<option value=c>copy</option>'
              .'</select>'
              .' '._("to").'</td><td><table border=0 cellpadding=0 cellspacing=0>'
              .'<tr><td><input type=checkbox name=toFolder checked>' . _("Folder") . '&nbsp;&nbsp;</td><td>';
          folderDropdown('');
          echo  '</td></tr>'
               .'<td><input type=checkbox name=toAddress>' ._("Email") . '&nbsp;&nbsp;</td>'
               .'<td><input type=text name=add_string></td>'
               .'</tr></table></td>'
               .'<td colspan=4 align=center valign=top><input type=image src="images/saveas.gif" border=0 name=create alt="save new"></td></tr>'
               .'</form>';
       }
       echo "</table></td></tr>";
       echo "<tr><td colspan=6 align=center><br><b>"._("Existing Filters:")."</td></tr>";

       print_recipies();
?>
</table>
<p><b><?php echo _("Notice:") . "</b> " . _("Use of these filters may prevent the reading of mail in non-IMAP mail clients.") ?>
</td></tr>
</table>
</td></tr>
</table>
</body>
</html>

