<?php
/*
 *	ServerSideFilter - ServerSide mail filter plugin for SquirrelMail
 *	By Patrick Swieskowski, Rick Sheaffer, and Jon Stroud
 */


/**
 * These are the backend definitions.  You should never directly call any
 * of these functions.
 * Calls to these functions are made from functions.php
 */

/*
 * Local Backend
 *    Functions here work with a local file
 */
function local_filter_get() {
   global $username, $FILTERDIR, $FILTERFILE, $VIRTUAL_DOMAINS, $SEPERATOR;

   if (isset($VIRTUAL_DOMAINS) && ($VIRTUAL_DOMAINS==1)) {
      list($user, $domain) = split($SEPERATOR,$username);
   } else {
      $user = $username;
      $domain = '';
   }
   $path = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$FILTERDIR);
   if (!file_exists($path)) {
      mkdirs($path,0700);
   }

   $file = "$path/$FILTERFILE";
   $localfile = "/tmp/$FILTERFILE.$username";
   if (file_exists($file))
      copy($file, $localfile);
   else
      touch($localfile);

   return $localfile;
}

function local_filter_exists() {
   global $username, $FILTERDIR, $FILTERFILE, $VIRTUAL_DOMAINS, $SEPERATOR;

   if (isset($VIRTUAL_DOMAINS) && ($VIRTUAL_DOMAINS==1)) {
      list($user, $domain) = split($SEPERATOR,$username);
   } else {
      $user = $username;
      $domain = '';
   }
   $path = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$FILTERDIR);
   $file = "$path/$FILTERFILE";
   return file_exists($file);
}

// Put the filter file

function local_filter_put($file) {
   global $username, $FILTERDIR, $FILTERFILE, $VIRTUAL_DOMAINS, $SEPERATOR;

   if (isset($VIRTUAL_DOMAINS) && ($VIRTUAL_DOMAINS==1)) {
      list($user, $domain) = split($SEPERATOR,$username);
   } else {
      $user = $username;
      $domain = '';
   }
   $path = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$FILTERDIR);
   if (!file_exists($path)) {
      mkdirs($path,0700);
   }

   $newfile = "$path/$FILTERFILE";
   copy($file, $newfile);
}

// the local method has no way to check passwords. this function should really never be called.
function local_check_pass() {
   return false;
}
/*
 * FTP backend
 *   These functions implement moving the filter files and qmail files via FTP
 */
function ftp_filter_get() {
   global $username, $FILTERDIR, $FILTERFILE, $VIRTUAL_DOMAINS, $SEPERATOR;
   if ($VIRTUAL_DOMAINS) 
     list($user,$domain) = split($SEPERATOR,$username);
   else {
     $user = $username;
     $domain = '';
   }
   $path = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$FILTERDIR);
   $filtername = "$path/$FILTERFILE";
   $localfile = "/tmp/$FILTERFILE.$username";
   _ftp_get($localfile, $filtername);
   return $localfile;
}

function ftp_filter_exists() {
   $file = ftp_filter_get();
   if (filesize($file) > 0) $ret = true;
   else $ret = false;
   unlink($file);
   return $ret;
}

function ftp_filter_put($file) {
   global $username, $FILTERDIR, $FILTERFILE, $VIRTUAL_DOMAINS, $SEPERATOR;
   if ($VIRTUAL_DOMAINS) 
     list($user,$domain) = split($SEPERATOR,$username);
   else {
      $user = $username;
      $domain = '';
   }
   $path = preg_replace(array('/\[DOMAIN\]/','/\[USERNAME\]/'),array($domain,$user),$FILTERDIR);
   $filtername = "$path/$FILTERFILE";
   _ftp_put($file,$filtername);
}

function ftp_write_dot_qmail($file) {
   global $username, $VIRTUAL_DOMAINS, $SEPERATOR;
   if ($VIRTUAL_DOMAINS) list($user,$domain) = split($SEPERATOR,$username);
   else $user = $username;
   $dot_qmail = ".qmail-$user";
   _ftp_put($file,$dot_qmail);
}

function ftp_check_pass ($user, $pass) {
   global $imapServerAddress;

   $conn = @ftp_connect($imapServerAddress);
   $ret = @ftp_login($conn, $user, $pass);
   @ftp_quit($conn);
   return $ret;
}   
// Raw ftp functions
function _ftp_get($localfile, $remotefile) {
   global $username, $key, $onetimepad, $imapServerAddress, $VIRTUAL_DOMAINS, $SEPERATOR;

   if ($VIRTUAL_DOMAINS) {
      list($vuser,$vdomain) = split($SEPERATOR,$username);
      $password = my_get_domain_passwd($vdomain);
      $user = my_virtual_domain_user($vdomain);
   } else {
      compatibility_sqextractGlobalVar('onetimepad');
      if (!compatibility_check_php_version(4, 1)) {
         global $HTTP_COOKIE_VARS;
         $_COOKIE = $HTTP_COOKIE_VARS;
      }
      $key = $_COOKIE['key'];
      $password = OneTimePadDecrypt($key, $onetimepad);
      $user = $username;
   }

   $conn = @ftp_connect($imapServerAddress);
   @ftp_login($conn, $user, $password);
   @ftp_get($conn, $localfile, $remotefile, FTP_BINARY) or touch($localfile);
   @ftp_quit($conn);
}

function _ftp_put($localfile, $remotefile) {
   global $username, $key, $onetimepad, $imapServerAddress, $VIRTUAL_DOMAINS, $SEPERATOR;

   if ($VIRTUAL_DOMAINS) {
      list($vuser,$vdomain) = split($SEPERATOR,$username);
      $password = my_get_domain_passwd($vdomain);
      $user = my_virtual_domain_user($vdomain);
   } else {
      compatibility_sqextractGlobalVar('onetimepad');
      if (!compatibility_check_php_version(4, 1)) {
          global $HTTP_COOKIE_VARS;
          $_COOKIE = $HTTP_COOKIE_VARS;
      }
      $key = $_COOKIE['key'];
      $password = OneTimePadDecrypt($key, $onetimepad);
      $user = $username;
   }
   $conn = @ftp_connect($imapServerAddress);
   @ftp_login($conn, $user, $password);
   @ftp_put($conn, $remotefile, $localfile, FTP_BINARY);
   @ftp_site($conn,"CHMOD 0600 $remotefile");

   @ftp_quit($conn);
}

/**
 * Procmail backend
 *
 */

function procmail_write_filter_recipie($fd, $action, $field, $string, $folder,
                                       $toFolder, $toAddress, $add_string) {
   global $default_folder_prefix, $optional_delimiter, $USE_MAILDIRS;

   if ($action == "m")
       $procaction2 = ":";
   else
       $procaction2 = "c:";

   $procaction1 = $procaction2;

   if ($USE_MAILDIRS) {
      $df = preg_replace("/\./",'[\\.]?',$default_folder_prefix);
      $folder = preg_replace("/$df/",'',$folder);
      $folder = $folder.'/';
   }

   $folder = '$MAILDIR'.$optional_delimiter.$folder;

   //escape spaces
   $folder = preg_replace('/\s/', '\ ', $folder);

   if ($toFolder == 'on' && $toAddress == 'on') {
      $procaction1 = 'c:';
      $copystring = "$folder\n :0 A$procaction2\n! $add_string";
   }
   elseif ($toFolder == 'on')
      $copystring = "$folder";
   elseif ($toAddress == 'on')
      $copystring = "! $add_string";
   else
      $copystring = "";
   
   fputs($fd, ":0${procaction1}\n* ^${field}.*${string}\n${copystring}\n");
}

function procmail_write_default_recipie($fd) {
   global $DEFAULT_DELIVERY;
   fputs($fd, "\n:0:\n${DEFAULT_DELIVERY}\n");
}

function procmail_write_spam_filter($fd) {
   global $username, $SPAMFILTER;

   fputs($fd, "\n:0wf\n| ${SPAMFILTER} -u ${username} -f\n");
}

/**
 * Maildrop backend
 *
 */
function maildrop_write_filter_recipie($fd, $action, $field, $string, $folder,
                                       $toFolder, $toAddress, $add_string) {
   global $default_folder_prefix, $optional_delimiter;

   if ($action == "m")
       $dropaction = "to";
   else
       $dropaction = "cc";
   $df = preg_replace("/\./",'[\\.]?',$default_folder_prefix);
   $folder = preg_replace("/$df/",'',$folder);
   $folder = '$MAILDIR/'.$optional_delimiter.$folder;

   if ($toFolder == 'on' && $toAddress == 'on')
      $copystring = "cc \"$folder\"\n$dropaction \"!$add_string\"";
   elseif ($toFolder == 'on')
      $copystring = "$dropaction \"$folder\"";
   elseif ($toAddress == 'on')
      $copystring = "$dropaction \"!$add_string\"";
   else
      $copystring = "";
   fputs($fd, "if (/^${field}:.*${string}/)\n{\n${copystring}\n}\n");
}

function maildrop_write_default_recipie($fd) {
   global $DEFAULT_DELIVERY;
   fputs($fd, "\nto \"${DEFAULT_DELIVERY}\"\n");
}

function maildrop_write_spam_filter($fd) {
   global $username, $SPAMFILTER;

   fputs($fd, "\nxfilter \"${SPAMFILTER} -u ${username} -f\"\n");
}

/*
 * Recursive mkdir function taken from the PHP documentation
 *
 */
function mkdirs($strPath, $mode)
{
  if (is_dir($strPath)) return true;

  $pStrPath = dirname($strPath);
  if (!mkdirs($pStrPath, $mode)) return false;
  return mkdir($strPath, $mode);
}

/*
 * Virtual Domain Backend
 *   Some of this code is loosely based off of code from Konstantin Riabitsev's vadmin plugin
 */
function qmail_list_virtual_domains(){
    $control = '/var/qmail/control';
    $vfile = "$control/virtualdomains";
    if (!file_exists($vfile) || !is_readable($vfile)){
       return false;
    }
    $fd = fopen($vfile, 'r');
    $contents = fread($fd, filesize($vfile));
    $contents = rtrim($contents);
    if (strlen($contents) > 0){
        $domuary = explode("\n", $contents);
        $domary = array();
        foreach ($domuary as $domu){
            $domain = preg_replace('/:.*/s', '', $domu);
            array_push($domary, $domain);
        }
        return $domary;
    } else {
        return false;
    }
}

function qmail_virtual_domain_user($domain){
    $control = '/var/qmail/control';
    $vfile = "$control/virtualdomains";
    if (!file_exists($vfile) || !is_readable($vfile)){
       return false;
    }
    $fd = fopen($vfile, 'r');
    $contents = fread($fd, filesize($vfile));
    $contents = rtrim($contents);
    if (strlen($contents) > 0){
        $domuary = explode("\n", $contents);
        foreach ($domuary as $domu){
            list($dom,$user) = split(':', $domu);
            if ($dom == $domain) break;
        }
        if ($dom == $domain) return $user;
        else return false;
    } else {
        return false;
    }
}


/**
 * Crypto code.
 *   These functions encrypt the password
 *
 * This function stolen nearly verbatim from hastymail. 
 * http://hastymail.sf.net/
 */
function my_rc4_crypt($input, $key) {
    $k_tmp = preg_split('//', $key, -1, PREG_SPLIT_NO_EMPTY);
    foreach($k_tmp as $char) {
        $k[] = ord($char);
    }
    unset($k_tmp); 
    $message = preg_split('//', $input, -1, PREG_SPLIT_NO_EMPTY);
    $rep = count($k);
    for ($n=0;$n<$rep;$n++) {
        $s[] = $n;
    }
    $i = 0;
    $f = 0;
    for ($i = 0;$i<$rep;$i++) {
        $f = (($f + $s[$i] + $k[$i]) % $rep);
        $tmp = $s[$i];
        $s[$i] = $s[$f];
        $s[$f] = $tmp;
    }
    $i = 0;
    $f = 0;
    foreach($message as $letter) {
        $i = (($i + 1) % $rep);
        $f = (($f + $s[$i]) % $rep);
        $tmp = $s[$i];
        $s[$i] = $s[$f];
        $s[$f] = $tmp;
        $t = $s[$i] + $s[$f];
        $done = ($t^(ord($letter)));
        $i++;
        $f++;
        $enc_array[] = chr($done);
    }
    $coded = implode('', $enc_array);
    return $coded;
}

/**
 * This function does the encryption and decryption of sensitive
 * data stored on the HDD. It uses the CRYPTO_HASH_LINE as key.
 * This function is taken from the VADMIN plugin.
 *
 * @param $input the contents to encrypt/decrypt.
 * @param $mode  a string that can be either "decrypt" or "encrypt"
 *               depending on which action needs to be performed.
 * @return       the results of encryption/decryption.
 */
function my_crypto($input, $mode){
    $CRYPTO_HASH_LINE   = $_SERVER{'CRYPTO_HASH_LINE'};
    $MCRYPT_ALGO        = $_SERVER{'MCRYPT_ALGO'};

    /**
     * See if we have everything needed for
     * encryption/decryption. This includes checking for the
     * encryption functions, the algorithm, and the hash line.
     */
    if (!$CRYPTO_HASH_LINE || !$MCRYPT_ALGO){
        $message = '';
        if (!$CRYPTO_HASH_LINE){
            $message .= _("Could not find CRYPTO_HASH_LINE! ");
        }
        if (!$MCRYPT_ALGO){
            $message .= _("Could not find MCRYPT_ALGO! ");
        }
        echo "CRYPTO is misconfigured: $message";
    }
    $key = $CRYPTO_HASH_LINE;
    if ($MCRYPT_ALGO == 'rc4_builtin'){
        switch($mode){
        case 'encrypt':
            $endresult = base64_encode(vadmin_rc4_crypt($input, $key));
            break;
        case 'decrypt':
            $endresult = vadmin_rc4_crypt(base64_decode($input), $key);
            break;
        }
    } else {
        if (!function_exists('mcrypt_generic')){
            $message = _("An algorithm other than 'rc4_builtin' specified, but mcrypt support not found.");
            echo "CRYPTO is misconfigured: $message";
        }
        $td = mcrypt_module_open($MCRYPT_ALGO, '', MCRYPT_MODE_ECB, '');
        $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
        @mcrypt_generic_init($td, $key, $iv);
        switch ($mode){
        case 'encrypt':
            $endresult = base64_encode(mcrypt_generic($td, $input));
            break;
        case 'decrypt':
            $endresult = mdecrypt_generic($td, base64_decode($input));
            /**
             * There will be trailing nul's on the end. Remove
             * these. They suck.
             */
            $endresult = rtrim($endresult);
            break;
        }
        mcrypt_generic_deinit($td);
    }
    return $endresult;
}

?>
