<?php

/**
  * SquirrelMail Server Settings Backend Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage server_settings_backend
  *
  */



/**
  * Returns info about this plugin
  *
  */
function server_settings_backend_info()
{

   return array(
                 'english_name' => 'Server Settings Backend',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'summary' => 'Supplies a code library for other plugins that want to manipulate user settings stored outside of SquirrelMail.',
                 'details' => 'This plugin provides a highly configurable way for other plugins to retrieve and store settings outside of SquirrelMail.  Values stored in a SQL database, in LDAP, on a server accessed by FTP, or on the local file system (usually accessed via a set-uid wrapper that allows read and write access to files not owned or normally accessible by the web server) are all supported.  Even the credentials used for accessing the settings (for example, the FTP login username and password) can be recursively passed back to this plugin so that they themselves can be looked up in any one of the supported data stores.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array()
                    ),
                    '1.4.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.14',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function server_settings_backend_version()
{
   $info = server_settings_backend_info();
   return $info['version'];
}



