<?php

/**
  * SquirrelMail Server Settings Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage server_settings
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function server_settings_init()
{

   // this file includes the SMOPT_* constant definitions used 
   // in the plugin configuration file
   //
   if (check_sm_version(1, 5, 2))
      include_once(SM_PATH . 'include/constants.php');
   else
      include_once(SM_PATH . 'functions/options.php');


   // if calling sqimap_mailbox_list() to build a folder
   // list, we need this include file
   //
   include_once(SM_PATH . 'functions/imap_general.php');


   // on any page where an IMAP connection is not in use, in order
   // to allow the Server Settings configuration to have a mailbox
   // list option widget, need to fake out the code that retrieves
   // the mailbox list
   //
   global $imapConnection;
   $unregister_boxesnew = FALSE;
   if (!is_resource($imapConnection)
    && !sqGetGlobalVar('boxesnew', $boxesnew, SQ_SESSION))
   {
      sqsession_register(FALSE, 'boxesnew');
      $unregister_boxesnew = TRUE;
   }


   // when configtest being used and there is a folder
   // list widget in the configuration file, it's a bit
   // of a mess - we need to fake out a few things
   //
   global $server_settings_configtest;
   if ($server_settings_configtest)
      include_once(SM_PATH . 'functions/imap_mailbox.php');


   if (!@include_once(SM_PATH . 'config/config_server_settings.php'))
      if (!@include_once(SM_PATH . 'plugins/server_settings/config.php'))
         return FALSE;


   if ($unregister_boxesnew)
   {
      sqsession_unregister('boxesnew');
   }


   return TRUE;

}



/**
  * Show options block(s) on SM main options page
  *
  */
function server_settings_option_blocks_do()
{

   global $server_settings_option_pages, $optpage_blocks;

   server_settings_init();
   sq_change_text_domain('server_settings');

   foreach ($server_settings_option_pages as $index => $option_page)
   {
      if (!empty($option_page['NO_OPTION_PAGE']))
         continue;

      $optpage_blocks[] =
         array(
            'name' => _($option_page['TITLE']),
            'url'  => sqm_baseuri() . 'src/options.php?optpage=ss' . $index,
            'desc' => _($option_page['DESCRIPTION']),
            'js'   => FALSE,
         );
   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Show links in menu on top of content pane 
  *
  */
function server_settings_menuline_do()
{

   global $server_settings_option_pages;

   server_settings_init();
   sq_change_text_domain('server_settings');

   if (check_sm_version(1, 5, 2))
   {
      global $oTemplate, $nbsp;
      $output = '';

      foreach ($server_settings_option_pages as $index => $option_page)
         if (!empty($option_page['MENU_LINK']))
            $output .= makeInternalLink('src/options.php?optpage=ss' . $index,
                                        _($option_page['MENU_LINK']), '') . $nbsp . $nbsp;

      sq_change_text_domain('squirrelmail');

      return array('menuline' => $output);
   }
   else
   {

      foreach ($server_settings_option_pages as $index => $option_page)
         if (!empty($option_page['MENU_LINK']))
         {
            displayInternalLink('src/options.php?optpage=ss' . $index,
                                _($option_page['MENU_LINK']), '');
            echo "&nbsp;&nbsp;\n";
         }

      sq_change_text_domain('squirrelmail');
   }

}



