<?php

   global $sent_confirmation_debug;
   $sent_confirmation_debug = 0;

   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');



function sent_conf_options() {

   global $sent_conf_allow_user_override, $sent_conf_message_style,
          $sent_conf_include_recip_addr, $sent_conf_show_only_first_recip_addr,
          $username, $data_dir, $sent_conf_include_cc, $sent_conf_include_bcc,
          $sent_conf_show_headers;

   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/sent_confirmation/config.php');
   else
      include_once ('../plugins/sent_confirmation/config.php');

   if (!$sent_conf_allow_user_override)
      return;

   $sent_conf_style = getPref($data_dir, $username, 'sent_conf_style', $sent_conf_message_style);
   $sent_conf_incl_recip = getPref($data_dir, $username, 'sent_conf_incl_recip', $sent_conf_include_recip_addr);
   $sent_conf_show_only_first_recip_addr = getPref($data_dir, $username, 'sent_conf_show_only_first_recip_addr', $sent_conf_show_only_first_recip_addr);
   $sent_conf_include_cc = getPref($data_dir, $username, 'sent_conf_include_cc', $sent_conf_include_cc);
   $sent_conf_include_bcc = getPref($data_dir, $username, 'sent_conf_include_bcc', $sent_conf_include_bcc);
   $sent_conf_show_headers = getPref($data_dir, $username, 'sent_conf_show_headers', $sent_conf_show_headers);

   echo "<TR><TD COLSPAN=\"2\">&nbsp;</TD></TR>\n"
      . "<TR><TD ALIGN=CENTER VALIGN=MIDDLE COLSPAN=2 NOWRAP><B>"
      . _("Sent Mail Confirmation") . "</B></TD></TR>\n";

   echo "<tr><td align=right valign=top>\n".
      _("Display Sent Confirmation:") . "</td>\n".
        "<td>";
   echo "<input type='radio' value='off' name='sent_conf_style' ";
   if ($sent_conf_style == 'off') echo "CHECKED";
   echo ">&nbsp;" . _("Off") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='1' name='sent_conf_style' ";
   if ($sent_conf_style == '1') echo "CHECKED";
   echo ">&nbsp;" . _("1") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='2' name='sent_conf_style' ";
   if ($sent_conf_style == '2') echo "CHECKED";
   echo ">&nbsp;" . _("2") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='3' name='sent_conf_style' ";
   if ($sent_conf_style == '3') echo "CHECKED";
   echo ">&nbsp;" . _("3") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='4' name='sent_conf_style' ";
   if ($sent_conf_style == '4') echo "CHECKED";
   echo ">&nbsp;" . _("4") . "\n".
      "</td></tr>\n";

   echo "<tr><td align=right valign=top>\n".
      _("Show Header Fields:") . "</td>\n".
      "<td><input type='radio' value='1' name='sent_conf_show_headers' ";
   if ($sent_conf_show_headers == '1') echo "CHECKED";
   echo ">&nbsp;" . _("Yes") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='0' name='sent_conf_show_headers' ";
   if ($sent_conf_show_headers == '0') echo "CHECKED";
   echo ">&nbsp;" . _("No") . "\n".
      "</td></tr>\n";

   echo "<tr><td align=right valign=top>\n".
      _("Include Recipient Address:") . "</td>\n".
      "<td><input type='radio' value='1' name='sent_conf_incl_recip' ";
   if ($sent_conf_incl_recip == '1') echo "CHECKED";
   echo ">&nbsp;" . _("Yes") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='0' name='sent_conf_incl_recip' ";
   if ($sent_conf_incl_recip == '0') echo "CHECKED";
   echo ">&nbsp;" . _("No") . "\n".
      "</td></tr>\n";

   echo "<tr><td align=right valign=top>\n".
      _("Only Show First Recipient:") . "</td>\n".
      "<td><input type='radio' value='1' name='sent_conf_show_only_first_recip_addr' ";
   if ($sent_conf_show_only_first_recip_addr == '1') echo "CHECKED";
   echo ">&nbsp;" . _("Yes") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='0' name='sent_conf_show_only_first_recip_addr' ";
   if ($sent_conf_show_only_first_recip_addr == '0') echo "CHECKED";
   echo ">&nbsp;" . _("No") . "\n".
      "</td></tr>\n";

   echo "<tr><td align=right valign=top>\n".
      _("Show Cc Recipients:") . "</td>\n".
      "<td><input type='radio' value='1' name='sent_conf_include_cc' ";
   if ($sent_conf_include_cc == '1') echo "CHECKED";
   echo ">&nbsp;" . _("Yes") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='0' name='sent_conf_include_cc' ";
   if ($sent_conf_include_cc == '0') echo "CHECKED";
   echo ">&nbsp;" . _("No") . "\n".
      "</td></tr>\n";

   echo "<tr><td align=right valign=top>\n".
      _("Show Bcc Recipients:") . "</td>\n".
      "<td><input type='radio' value='1' name='sent_conf_include_bcc' ";
   if ($sent_conf_include_bcc == '1') echo "CHECKED";
   echo ">&nbsp;" . _("Yes") . "\n".
      "&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' value='0' name='sent_conf_include_bcc' ";
   if ($sent_conf_include_bcc == '0') echo "CHECKED";
   echo ">&nbsp;" . _("No") . "\n".
      "</td></tr>\n";

}



function sent_conf_options_save() {

   global $sent_conf_allow_user_override, $username, $data_dir,
          $sent_conf_style, $sent_conf_incl_recip, $sent_conf_include_cc,
          $sent_conf_show_only_first_recip_addr, $sent_conf_include_bcc,
          $sent_conf_show_headers;

   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/sent_confirmation/config.php');
   else
      include_once ('../plugins/sent_confirmation/config.php');

   if (!$sent_conf_allow_user_override)
      return;

   compatibility_sqextractGlobalVar('sent_conf_style');
   compatibility_sqextractGlobalVar('sent_conf_incl_recip');
   compatibility_sqextractGlobalVar('sent_conf_show_only_first_recip_addr');
   compatibility_sqextractGlobalVar('sent_conf_include_cc');
   compatibility_sqextractGlobalVar('sent_conf_include_bcc');
   compatibility_sqextractGlobalVar('sent_conf_show_headers');

   setPref($data_dir, $username, 'sent_conf_style', $sent_conf_style);
   setPref($data_dir, $username, 'sent_conf_incl_recip', $sent_conf_incl_recip);
   setPref($data_dir, $username, 'sent_conf_show_only_first_recip_addr', $sent_conf_show_only_first_recip_addr);
   setPref($data_dir, $username, 'sent_conf_include_cc', $sent_conf_include_cc);
   setPref($data_dir, $username, 'sent_conf_include_bcc', $sent_conf_include_bcc);
   setPref($data_dir, $username, 'sent_conf_show_headers', $sent_conf_show_headers);

}



// Very simple place to indicate that the message was sent
//
function sent_conf_message_sent_do() {

   global $sent_confirmation_debug, $sent_conf_message_sent_status,
          $sent_conf_include_recip_addr, $send_to, $send_to_cc, $send_to_bcc,
          $sent_conf_show_only_first_recip_addr, 
          $sent_conf_allow_user_override, $data_dir, $username,
          $sent_conf_include_cc, $sent_conf_include_bcc,
          $sent_conf_message_style, $sent_conf_show_headers;

   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/sent_confirmation/config.php');
   else
      include_once ('../plugins/sent_confirmation/config.php');

   if ($sent_conf_allow_user_override)
   {
      $sent_conf_message_style = getPref($data_dir, $username, 'sent_conf_style', $sent_conf_message_style);
      $sent_conf_include_recip_addr = getPref($data_dir, $username, 'sent_conf_incl_recip', $sent_conf_include_recip_addr);
      $sent_conf_show_only_first_recip_addr = getPref($data_dir, $username, 'sent_conf_show_only_first_recip_addr', $sent_conf_show_only_first_recip_addr);
      $sent_conf_include_cc = getPref($data_dir, $username, 'sent_conf_include_cc', $sent_conf_include_cc);
      $sent_conf_include_bcc = getPref($data_dir, $username, 'sent_conf_include_bcc', $sent_conf_include_bcc);
      $sent_conf_show_headers = getPref($data_dir, $username, 'sent_conf_show_headers', $sent_conf_show_headers);
   }

   $sent_conf_message_sent_status = 'sent';

   if ($sent_conf_include_recip_addr)
   {
      if ($sent_conf_show_only_first_recip_addr)
      {
         preg_match('/(.*?)[,; ]/', trim($send_to), $matches);
         if (isset($matches[1]))
            $sent_conf_message_sent_status = $matches[1] 
               . ($sent_conf_message_style < 3 ? ', et al' : '');
         else
            $sent_conf_message_sent_status = $send_to;
      }
      else
      {
         if ($sent_conf_show_headers)
            //$sent_conf_message_sent_status = 'To: ';
            $sent_conf_message_sent_status = '';
         else
            $sent_conf_message_sent_status = '';
         $sent_conf_message_sent_status .= $send_to;
         $send_to_cc = trim($send_to_cc);
         $send_to_bcc = trim($send_to_bcc);
         if ($sent_conf_include_cc && !empty($send_to_cc))
         {
            if ($sent_conf_show_headers)
               $sent_conf_message_sent_status .= ', Cc: ' . $send_to_cc;
            else
               $sent_conf_message_sent_status .= ', ' . $send_to_cc;
         }
         if ($sent_conf_include_bcc && !empty($send_to_bcc))
         {
            if ($sent_conf_show_headers)
               $sent_conf_message_sent_status .= ', Bcc: ' . $send_to_bcc;
            else
               $sent_conf_message_sent_status .= ', ' . $send_to_bcc;
         }
      }
   }

   compatibility_sqsession_register($sent_conf_message_sent_status, 
                                    'sent_conf_message_sent_status');

   if ($sent_confirmation_debug == 1)
   {
      echo "<b>just before sending</b><pre>";
      print_r($_SESSION);
      echo "</pre>";
      exit;
   }

}



// Determine if there was a message just sent, if so, display message
//
function sent_conf_check_is_sent_do() {

   global $sent_conf_message_sent_status, $color, $sent_confirmation_debug, 
          $sent_conf_message_style, $sent_conf_include_recip_addr, 
          $sent_conf_allow_user_override, $data_dir, $username,
          $sent_conf_show_headers;

   compatibility_sqextractGlobalVar('sent_conf_message_sent_status');

   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/sent_confirmation/config.php');
   else
      include_once ('../plugins/sent_confirmation/config.php');

   if ($sent_conf_allow_user_override)
   {
      $sent_conf_message_style = getPref($data_dir, $username, 'sent_conf_style', $sent_conf_message_style);
      $sent_conf_include_recip_addr = getPref($data_dir, $username, 'sent_conf_incl_recip', $sent_conf_include_recip_addr);
      $sent_conf_show_headers = getPref($data_dir, $username, 'sent_conf_show_headers', $sent_conf_show_headers);
   }

   if ($sent_confirmation_debug == 2)
   {
      echo "<b>session...</b><pre>";
      print_r($_SESSION);
      echo "</pre>";
   }


   // remove leading commas/semicolons, brackets, if any
   //
   if (isset($sent_conf_message_sent_status) 
          && !empty($sent_conf_message_sent_status)
          && $sent_conf_message_sent_status != 'not_sent'
          && $sent_conf_message_style != 'off')
   {
      $sent_conf_message_sent_status = preg_replace('/^(\W*)/', '', $sent_conf_message_sent_status);
      $sent_conf_message_sent_status = preg_replace('/[<>]/', '', $sent_conf_message_sent_status);
   }


   // if we should be showing a notification, then do it
   //
   if (isset($sent_conf_message_sent_status) 
          && !empty($sent_conf_message_sent_status)
          && $sent_conf_message_sent_status != 'not_sent'
          && $sent_conf_message_style != 'off')
   {

      echo '<table width="100%" bgcolor="' . $color[0] 
         . '" cellpadding="0" cellspaceing="0"><tr><td>';

      if ($sent_conf_message_style == 1)
      {
         if ($sent_conf_include_recip_addr)
            echo '<strong>' . _("Message Sent To: ") 
               . $sent_conf_message_sent_status . '</strong>';
         else
            echo '<strong>' . _("Message Sent") . '</strong>';
      }
      else if ($sent_conf_message_style == 2)
      {
         if ($sent_conf_include_recip_addr)
            echo '<strong><center>' . _("Your message has been sent to ") 
               . $sent_conf_message_sent_status . '</center></strong>';
         else
            echo '<strong><center>' . _("Your message has been sent") . '</center></strong>';
      }
      else if ($sent_conf_message_style == 3)
      {

         // code stolen from /src/read_body.php as 
         // well as Wolf Bergenheim's Todo plugin
         //
         global $color, $base_uri, $mailbox, $sort, $startMessage,
                $sent_logo, $sent_logo_width, $sent_logo_height;
         $urlMailbox = urlencode($mailbox);

         echo '<TABLE CELLSPACING="0" WIDTH="100%" BORDER="0" ALIGN="CENTER" CELLPADDING="0">' 
            . '<TR><TD BGCOLOR="' . $color[9] . '" WIDTH="100%">' 
            . '<TABLE WIDTH="100%" CELLSPACING="0" BORDER="0" CELLPADDING="3">' 
            . '<TR>' 
            . '<TD ALIGN="LEFT" WIDTH="100%">' 
            . '<SMALL>' 
            . '<A HREF="' . $base_uri . 'src/'
            . "right_main.php?sort=$sort&amp;startMessage=$startMessage&amp;mailbox=$urlMailbox\">"
            . _("Message List") . '</A></SMALL>' 
            . '</TD></TR></TABLE>'
            . '</TD></TR><TR><TD>';


         echo '<br><table align=center width="60%" cellpadding=0 bgcolor="'
            . $color[9] . '" cellspacing=3 border=0>'
            . '<tr><td>'
            . '<table width="100%" cellpadding=5 cellspacing=1 border=0 bgcolor="' 
            . $color[4] .'">';
         if (isset($sent_logo) && !empty($sent_logo))
         {
            echo '<tr><td align="center"><img src="' . $sent_logo . '"';
            if (isset($sent_logo_width) && !empty($sent_logo_width))
               echo 'width="' . $sent_logo_width . '"';
            if (isset($sent_logo_height) && !empty($sent_logo_height))
               echo ' height="' . $sent_logo_height . '"';
            echo '></td></tr>'. "\n"; 
         }
         echo '<tr><td align="center"><form action="../plugins/sent_confirmation/address_book_import.php" method="POST" onSubmit="if (document.forms[0].elements.length == 2) { document.forms[0].elements[0].checked=true; return true;} okToSubmit=false; for (i=0; i<document.forms[0].elements.length; i++){if (document.forms[0].elements[i].type == \'checkbox\') if (document.forms[0].elements[i].checked) okToSubmit=true} if (!okToSubmit) alert(\'' . _("Please select an address to add to your address book.") . '\'); return okToSubmit"><strong>'. "\n" 
            . _("Message Sent To:") . '</strong></td></tr>'."\n"
            . '<tr><td align=center><table border=0 cellspacing=0 cellpadding=0>'."\n";
          
         $addresses = preg_split('/[,;]\s*/', $sent_conf_message_sent_status);
         $x = 0;
         foreach ($addresses as $address)
         {
            $address = trim($address);
            if (!empty($address))
            {
               if ($sent_conf_show_headers && strpos($address, 'Cc:') === 0)
               {
                  $address = substr($address, 3);
                  echo '</table></td></tr><tr><td align="center"><strong>'."\n"
                     . _("Cc:") . '</strong></td></tr><tr><td align="center">'
                     . '<table border=0 cellspacing=0 cellpadding=0>'
                     . '<tr><td><input type="checkbox" name="address' . (++$x) 
                     . '" value="' . urlencode($address) . '">&nbsp;</td><td>'."\n"
                     . $address . '</td></tr>'."\n";
               }
               else if ($sent_conf_show_headers && strpos($address, 'Bcc:') === 0)
               {
                  $address = substr($address, 4);
                  echo '</table></td></tr><tr><td align="center"><strong>'."\n"
                     . _("Bcc:") . '</strong></td></tr><tr><td align="center">'
                     . '<table border=0 cellspacing=0 cellpadding=0>'
                     . '<tr><td><input type="checkbox" name="address' . (++$x) 
                     . '" value="' . urlencode($address) . '">&nbsp;</td><td>'."\n"
                     . $address . '</td></tr>'."\n";
               }
               else
                  echo '<tr><td><input type="checkbox" name="address' . (++$x) 
                     . '" value="' . urlencode($address) . '">&nbsp;</td><td>'."\n"
                     . $address . '</td></tr>'."\n";
            }
         }

         echo '</table>'
            . '<br><input type=submit value="' . _("Add To Address Book")
            . '"></form></td></tr></table>'
            . '</td></tr></table>';

         echo '<TABLE WIDTH="100%" CELLSPACING="0" BORDER="0" CELLPADDING="3">' 
            . '<TR>' 
            . '<TD ALIGN="RIGHT" WIDTH="100%"><br>' 
            . '<SMALL>' 
            . '<A HREF="' . $base_uri . 'src/'
            . "right_main.php?sort=$sort&amp;startMessage=$startMessage&amp;mailbox=$urlMailbox\">"
            . _("Message List") . '</A></SMALL>' 
            . '</TD></TR></TABLE></TD></TR></TABLE>';

         echo '</td></tr></table>'
            . '</body></html>';

         $sent_conf_message_sent_status = 'not_sent';
         compatibility_sqsession_register($sent_conf_message_sent_status, 
                                          'sent_conf_message_sent_status');
         exit(0);

      }
      else if ($sent_conf_message_style == 4)
      {

         // code stolen from /src/read_body.php as 
         // well as Wolf Bergenheim's Todo plugin
         //
         global $color, $base_uri, $mailbox, $sort, $startMessage,
                $sent_logo, $sent_logo_width, $sent_logo_height;
         $urlMailbox = urlencode($mailbox);

         echo '<TABLE CELLSPACING="0" WIDTH="100%" BORDER="0" ALIGN="CENTER" CELLPADDING="0">' 
            . '<TR><TD BGCOLOR="' . $color[9] . '" WIDTH="100%">' 
            . '<TABLE WIDTH="100%" CELLSPACING="0" BORDER="0" CELLPADDING="3">' 
            . '<TR>' 
            . '<TD ALIGN="LEFT" WIDTH="100%">' 
            . '<SMALL>' 
            . '<A HREF="' . $base_uri . 'src/'
            . "right_main.php?sort=$sort&amp;startMessage=$startMessage&amp;mailbox=$urlMailbox\">"
            . _("Message List") . '</A></SMALL>' 
            . '</TD></TR></TABLE>'
            . '</TD></TR><TR><TD>';


         echo '<br><table align=center width="60%" cellpadding=0 bgcolor="'
            . $color[9] . '" cellspacing=3 border=0>'
            . '<tr><td>'
            . '<table width="100%" cellpadding=5 cellspacing=1 border=0 bgcolor="' 
            . $color[4] .'">';
         if (isset($sent_logo) && !empty($sent_logo))
         {
            echo '<tr><td align="center"><img src="' . $sent_logo . '"';
            if (isset($sent_logo_width) && !empty($sent_logo_width))
               echo 'width="' . $sent_logo_width . '"';
            if (isset($sent_logo_height) && !empty($sent_logo_height))
               echo ' height="' . $sent_logo_height . '"';
            echo '></td></tr>'; 
         }
         echo '<tr><td align="center"><strong>' 
            . _("Message Sent To:") . '</strong></td></tr>'
            . '<tr><td align=center><table border=0 cellspacing=0 cellpadding=0>';
          
         $addresses = preg_split('/[,;]\s*/', $sent_conf_message_sent_status);
         $x = 0;
         foreach ($addresses as $address)
         {
            $address = trim($address);
            if (!empty($address))
            {
               if ($sent_conf_show_headers && strpos($address, 'Cc:') === 0)
               {
                  $address = substr($address, 4);
                  echo '</table></td></tr><tr><td align="center"><strong>'."\n"
                     . _("Cc:") . '</strong></td></tr><tr><td align="center">'
                     . '<table border=0 cellspacing=0 cellpadding=0>'
                     . '<tr><td>' . $address . '</td></tr>'."\n";
               }
               else if ($sent_conf_show_headers && strpos($address, 'Bcc:') === 0)
               {
                  $address = substr($address, 5);
                  echo '</table></td></tr><tr><td align="center"><strong>'."\n"
                     . _("Bcc:") . '</strong></td></tr><tr><td align="center">'
                     . '<table border=0 cellspacing=0 cellpadding=0>'
                     . '<tr><td>' . $address . '</td></tr>'."\n";
               }
               else
                  echo '<tr><td>' . $address . '</td></tr>';
            }
         }

         echo '</table>'
            . '<br></td></tr></table>'
            . '</td></tr></table>';

         echo '<TABLE WIDTH="100%" CELLSPACING="0" BORDER="0" CELLPADDING="3">' 
            . '<TR>' 
            . '<TD ALIGN="RIGHT" WIDTH="100%"><br>' 
            . '<SMALL>' 
            . '<A HREF="' . $base_uri . 'src/'
            . "right_main.php?sort=$sort&amp;startMessage=$startMessage&amp;mailbox=$urlMailbox\">"
            . _("Message List") . '</A></SMALL>' 
            . '</TD></TR></TABLE></TD></TR></TABLE>';

         echo '</td></tr></table>'
            . '</body></html>';

         $sent_conf_message_sent_status = 'not_sent';
         compatibility_sqsession_register($sent_conf_message_sent_status, 
                                          'sent_conf_message_sent_status');
         exit(0);

      }

      echo '</td></tr></table>';

   }

   $sent_conf_message_sent_status = 'not_sent';
   compatibility_sqsession_register($sent_conf_message_sent_status, 
                                    'sent_conf_message_sent_status');

}



//
//
function sent_conf_compose_bottom_do() {

   global $sent_conf_message_sent_status;
   $sent_conf_message_sent_status = 'not_sent';
   compatibility_sqsession_register($sent_conf_message_sent_status, 
                                    'sent_conf_message_sent_status');

}



?>
