<?php

/**
 * setup.php
 *
 * Copyright (c) 1999-2003 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * $Id: setup.php,v 1.8 2003/01/17 18:15:23 kink Exp $
 */

#you can set this to whatever the default threshold/minimum should be
define( 'select_range_default_min', 4 );

if (!defined('SM_PATH')){
    define('SM_PATH','../../');
}

function select_range_do_abook(){
    global $javascript_on;

    if( $javascript_on ){
        global $data_dir, $username;
        global $select_range_display_errors;
        global $select_range_messages_threshold;

        #this should be set from the parent addressbook.php function
        global $alist;
     
        #see whether we should use extra links in address book
        $select_range_abook = 1;

        #TODO: move this out into separate function, also in print statement below
        if( !isset( $select_range_messages_threshold ) ){
            $select_range_messages_threshold = 
                getPref($data_dir, $username, 'plugin_select_range_threshold', select_range_default_min );
        }
        if( !isset( $select_range_display_errors ) ){
            $select_range_display_errors =
                getPref($data_dir, $username, 'plugin_select_range_display_errors', '1');
        }
        include_once( SM_PATH . 'plugins/select_range/overrides.php' );

        if( isset( $alist ) && is_array( $alist ) && $select_range_abook ){

            #globally tell this function that the hook to call select_range exists
            #if( $link_only ){
            #    $select_range_hook = 1;
            #}
    
            #TODO: move this test into a separate function
            if( 
                $select_range_messages_threshold != -1 &&
                (
                    ( $select_range_messages_threshold == 0 ) ||
                    ( count( $alist ) >= $select_range_messages_threshold )
                )
            ){
                $function_bit = 'Abook';
                $abook_func = 'FormAddrs' . $function_bit;
        
                $result = select_range_jscript_function( $function_bit, $select_range_display_errors, 'abook' );
                #might as well add a "toggle all" link while we're at it
                $result .= <<<EOF
<script language="JavaScript" type="text/javascript">
<!--
function CheckAllAddrs() {
  for (var i = 0; i < document.$abook_func.elements.length; i++) {
    if(document.$abook_func.elements[i].type == 'checkbox'){
      document.$abook_func.elements[i].checked = 
        !(document.$abook_func.elements[i].checked);
    }
  }
}
//-->
</script>
EOF;
		          $result .= 
                    html_tag( 
                        'p', 
                        '<a href="javascript:void(0)" onClick="CheckAllAddrs();">' . 
                            _( 'Toggle All' ) .
                            '</a>' .
                            '&nbsp;&nbsp;' .
                            select_range_link( 'SelectRange' . $function_bit ), 
                        'center' 
                    ) . 
                    "\n";

                echo $result;
            }
        }
    }
}

function select_range_do_options(){
    include_once( SM_PATH . 'functions/i18n.php' );
    #we'll leave this i18n'ized in case there is no "select range options" translation
    #TODO: remove this once all translations have been converted
    $options = _( 'Options' );

    bindtextdomain( 'select_range', SM_PATH . 'plugins/select_range/locale' );
    textdomain( 'select_range' );
    $option_title = _( 'Select Range Options' );
    if( $option_title == 'Select Range Options' ){
        $option_title = _( 'Select Range' ) . " $options";
    }
    #if you don't like this wording, you can override it in the locale file
    #if part 2 or 3 is set to ' ', it will not be printed
    $threshold_caption_1 = _( 'Number of list items before showing link' );
    $threshold_caption_2 = _( 'Set to 0 to always show the link' );
    $threshold_caption_3 = _( 'Set to -1 to never show the link' );
    $errors_caption = _( 'Display select range errors' );

    #check for presence of old i18n'ized caption_1 string
    #if it's there and been i18n'ized, we can assume the new string
    #hasn't been translated, so we'll use the old string
    #TODO: remove this once all translations have been converted
    if( _( 'Number of messages before showing select range link' ) != 'Number of messages before showing select range link' ){
        $threshold_caption_1 = _( 'Number of messages before showing select range link' );
    }

    bindtextdomain( 'squirrelmail', SM_PATH . 'locale' );
    textdomain( 'squirrelmail' );

	 $threshold_caption = $threshold_caption_1;
	 if( $threshold_caption_2 != ' ' ){
        $threshold_caption .= '<br>' . $threshold_caption_2;
    }
	 if( $threshold_caption_3 != ' ' ){
        $threshold_caption .= '<br>' . $threshold_caption_3;
    }
    global $optpage_data;

    $optpage_data['grps']['select_range'] = $option_title;

    $optionValues = array();

    include_once( SM_PATH . 'plugins/select_range/overrides.php' );
    global $data_dir, $username;
    if( !isset( $select_range_messages_threshold ) ){
        #if the user has selected threshold zero
        #need to set initial value to space-prefixed zero 
        #otherwise php interprets it as "empty" and displays blank
        $init_value = 
            getPref($data_dir, $username, 'plugin_select_range_threshold', select_range_default_min );
        if( !$init_value ){
            $init_value = ' 0';
        }
        $optionValues[] = array(
            'name' => 'plugin_select_range_threshold',
            'caption' => $threshold_caption,
            'type' => SMOPT_TYPE_STRING,
            'initial_value' => $init_value,
            'size' => SMOPT_SIZE_TINY,
				'save' => 'select_range_validate_threshold'
        );
    }

    if( !isset( $select_range_display_errors ) ){
        $optionValues[] = array(
            'name' => 'plugin_select_range_display_errors',
            'caption' => $errors_caption,
            'type' => SMOPT_TYPE_BOOLEAN,
            'initial_value' => 
                getPref($data_dir, $username, 'plugin_select_range_display_errors', '1')
        );
    }

    $optpage_data['vals']['select_range'] = $optionValues;

}

function select_range_do_print( $link_only = 0, $prefix = '' ){
    global $javascript_on;

    if( $javascript_on ){
        global $numMessages, $startMessage, $PG_SHOWALL, $data_dir, $username;
        global $select_range_hook;
        global $select_range_display_errors;
        global $select_range_messages_threshold;

        #globally tell this function that the hook to call select_range exists
        if( $link_only ){
            $select_range_hook = 1;
        }
 
        if( !isset( $select_range_messages_threshold ) ){
            $select_range_messages_threshold = 
                getPref($data_dir, $username, 'plugin_select_range_threshold', select_range_default_min );
        }
        if( !isset( $select_range_display_errors ) ){
            $select_range_display_errors =
                getPref($data_dir, $username, 'plugin_select_range_display_errors', '1');
        }
        include_once( SM_PATH . 'plugins/select_range/overrides.php' );
    
        #figure out how many messages are on the current page
        unset( $message_count );
        if( isset( $PG_SHOWALL ) && $PG_SHOWALL ){
            $message_count = $numMessages;
        } else if( isset( $numMessages ) && isset( $startMessage ) ){
            #I'd love to use $PG_SHOWNUM here, but apparently it isn't set yet
            $show_num = getPref($data_dir, $username, 'show_num', 15 );
            $message_count = (int) $show_num;
            if( $message_count > $numMessages - $startMessage + 1 ){
                $message_count = $numMessages - $startMessage + 1;
            }
        }

        #if $message_count can't be determined, we'll set threshold to 0 
        #so link is shown
        if( !isset( $message_count ) && $select_range_messages_threshold >= 0 ){
            $select_range_messages_threshold = 0;
        }
    
        if( 
            $select_range_messages_threshold != -1 &&
            (
                ( $select_range_messages_threshold == 0 ) ||
                ( $message_count >= $select_range_messages_threshold )
            )
        ){
            global $mailbox;
            $safe_name = preg_replace("/[^0-9A-Za-z_]/", '_', $mailbox);
            $func_name = "SelectRange" . $safe_name;
            $result = '';
    
            if( $link_only ){
                global $_SERVER;
                #kludgey attempt to disable this link on the search page
                if( !isset( $_SERVER ) || $_SERVER[ 'PHP_SELF' ] != '/src/search.php' ){
                    $result .= $prefix . select_range_link( $func_name );
                }
                return( $result );
                
            } else {
                #keep track of whether we already printed this function
                #so we don't print it more than once
                global $select_range_already_printed_jscript;
        
                if( ! isset( $select_range_already_printed_jscript ) ){
                    $result .= 
                        select_range_jscript_function( 
                            $safe_name,
                            $select_range_display_errors
                        );
                }
        
                if( !isset( $select_range_hook ) ){
                    #need to put the link in a table so css rules are followed
                    $result .= "\n<table>\n"
                        . "<tr><td>\n"
                        . select_range_link( $func_name )
                        . "\n"
                        . "</td></tr>\n"
                        . "</table>\n";
                }

                echo ( $result );
            }
        }
    }
}

function select_range_jscript_function( $safe_name, $alerts = 1, $context = '' ){
    include_once( SM_PATH . 'functions/i18n.php' );

    global $select_range_already_printed_jscript;
    $func_name = "SelectRange" . $safe_name;

    if( $context == 'abook' ){
        $form_name = "FormAddrs" . $safe_name;
    
        bindtextdomain('select_range', SM_PATH . 'plugins/select_range/locale');
        textdomain('select_range');
        $at_least_one_item_between = _( "Please leave at least one un-selected address between the first and last selected addresses" );
        $at_least_two_items_selected = _( "Please select at least two addresses" );

        bindtextdomain('squirrelmail', SM_PATH . 'locale');
        textdomain('squirrelmail');
    } else {
        $form_name = "FormMsgs" . $safe_name;
    
        bindtextdomain('select_range', SM_PATH . 'plugins/select_range/locale');
        textdomain('select_range');
        $at_least_one_item_between = _( "Please leave at least one un-selected message between the first and last selected messages" );
        $at_least_two_items_selected = _( "Please select at least two messages" );
        bindtextdomain('squirrelmail', SM_PATH . 'locale');
        textdomain('squirrelmail');
    }
     
    $result = <<<EOF
<script language="JavaScript" type="text/javascript">
<!--
function $func_name() { 
  var first_checked_message = -1;
  var last_checked_message = -1; 
  var unchecked_after_first = 0;
  var checked_after_unchecked = 0;
  var display_alert = $alerts;
  for (var i = 0; i < document.$form_name.elements.length; i++) {
    if( document.$form_name.elements[i].type == 'checkbox' ) {
      if( document.$form_name.elements[i].checked ){
        if( first_checked_message == -1 ){
          first_checked_message = i;
        } else {
          last_checked_message = i;
        }
        if( unchecked_after_first != 0 ){
          checked_after_unchecked = 1;
        }
      } else {
        if( first_checked_message != -1 ){
          unchecked_after_first = 1;
        }
      }
    }
  }
  if( first_checked_message != -1 && last_checked_message != -1 ){
    if( checked_after_unchecked == 0 ){
      if( display_alert == 1 ){
        alert( "$at_least_one_item_between" );
      }
    } else {
      for (var i = first_checked_message; i < last_checked_message; i++) {
        if( document.$form_name.elements[i].type == 'checkbox' ) {
          document.$form_name.elements[i].checked = true;
        }
      }
    }
  } else {
    if( display_alert == 1 ){
      alert( "$at_least_two_items_selected" );
    }
  }
}
//-->
</script>

EOF;
    $select_range_already_printed_jscript = 1;
    return( $result );
}

function select_range_link( $func_name ){
    include_once( SM_PATH . 'functions/i18n.php' );

    bindtextdomain('select_range', SM_PATH . 'plugins/select_range/locale');
    textdomain('select_range');

    $return_val = "\n"
        . '<a href="javascript:void(0)" onClick="' 
        . $func_name 
        . '();">' 
        . _("Select Range")
        . "</a>\n";

    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');

    return( $return_val );
}

#make sure user passed an integer or negative integer
function select_range_validate_threshold( $option ){
    global $data_dir, $username;

    $thresh = $option->new_value;
    $matches = array();
    preg_match( '/^\s*(\-?)(\d*)$/', $thresh, $matches );
    if( $matches[1] ){
        $thresh = -1;
    } else if( $matches[2] ){
        $thresh = $matches[2];
    } else if( $matches[2] === '0' ){
        $thresh = 0;
    } else {
        $thresh = select_range_default_min;
    }
	 $option->new_value = $thresh;
    save_option( $option );
}
?>
