<?php
// $Id: sa_whitelist.inc.php,v 1.13 2005/03/14 18:19:54 perlstalker Exp $

if (!defined('SM_PATH')) { define('SM_PATH' , '../../'); }

include_once(SM_PATH.'include/validate.php');
include_once(SM_PATH.'functions/page_header.php');
include_once(SM_PATH.'include/load_prefs.php');
include_once(SM_PATH.'plugins/sasql/sasql_conf.php');
include_once(SM_PATH.'plugins/sasql/sasql_db.php');

// From sasql_conf.php
global $SqlDSN;
global $SqlTable;
global $useSA2_43;
global $globalUsername;
global $allowed_params;
global $allowed_wl_params;
global $sa_params;
global $wl_params;
global $default_domain;

// from SM
global $username;
global $color;

// Form vars
sqgetGlobalVar('viewsection', $viewsection, SQ_FORM);
sqgetGlobalVar('delete', $delete, SQ_FORM);
sqgetGlobalVar('edit', $edit, SQ_FORM);
sqgetGlobalVar('address', $address, SQ_FORM);
sqgetGlobalVar('preference', $preference, SQ_FORM);
sqgetGlobalVar('action', $action, SQ_FORM);
sqgetGlobalVar('prefid', $prefid, SQ_FORM);

if ($delete) {
  sasql_DelPref ($DBHandle, $SqlTable, $username, $delete);
}
if ($action) {
  $error = -1;
  if (!$address) {
    $error++;
    $errmsg[$error] = _("Error: You must include an e-mail address.");
  }
  if ($address 
      && !ereg ("^([*a-zA-Z0-9_\.'-]+@)?[*a-zA-Z0-9\.-]+$", $address)
      ) {
    $error++;
    $errmsg[$error] = _("Error: You have entered an invalid e-mail address.");
  }
  if (!$preference) {
    $error++;
    $errmsg[$error] = _("Error: You must select Allow or Deny.");
  }
  if ($error < 0) {
    if ($action == "update") {
      sasql_UpdatePref ($DBHandle, $SqlTable, $username, $prefid, $preference, $address);
    } elseif ($action == "new") {
      sasql_AddPref ($DBHandle, $SqlTable, $username, $preference, $address);
    }
  }
}
$globalList = sasql_ReadWBList ( $DBHandle, $SqlTable, $globalUsername);
$global_wblist_count = 0;
foreach ($globalList as $gaddr) {
  $global_wblist_count += count($gaddr);
}

$wbList = sasql_ReadWBList ( $DBHandle, $SqlTable, $username );
?>

<table width="100%" border="0" cellpadding="1" cellspacing="1">
<?php if ($global_wblist_count > 0): ?>
 <tr>
  <td align="center" bgcolor="<?php echo $color[4]; ?>">
   <b><?php echo _("Global Allow / Deny Address List"); ?></b>
  </td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4] ?>">
   <table border="0" width="100%">
    <tr>
     <td><b><?php echo _("Address"); ?></b></td>
      <td><b><?php echo _("Type"); ?></b></td>
      <td><b>&nbsp;<b></td>
     </tr>

<?php
// Global white/black list
   $wblistcounter = 0;
   foreach ($globalList as $pref) {
     foreach ($pref as $addr) {
       $wblistcounter++;
       if ($wblistcounter % 2) {
         $tr_bgcolor = " bgcolor=$color[0]";
       } else {
         $tr_bgcolor = "";
       }
       // highlight the relevant address line
       if (strstr($addr['value'], $address)) {
         $tr_bgcolor = " bgcolor=$color[3]";
       }
       echo "<tr$tr_bgcolor>";
       echo "<td>". $addr['value'] ."</td>";
       echo "<td>";
       echo $wl_params[$addr['preference']]['title'];

       echo "</td><td>&nbsp;</td></tr>\n";
     }
}
?>
    </table>
   </td>
  </tr>
<?php endif; ?>
  <tr>
   <td align="center" bgcolor="<?php echo $color[4] ?>">
    <b><?php echo _("Personal Allow / Deny Address List"); ?></b>
   </td>
  </tr>
  <tr>
   <td bgcolor="<?php echo $color[4] ?>">
    <table border="0" width="100%">
     <tr>
      <td><b><?php echo _("Address"); ?></b></td>
      <td><b><?php echo _("Type"); ?></b></td>
      <td><b><?php echo _("Action"); ?><b></td>
     </tr>
<?php
      if ($delete) {
?>
     <tr>
      <td colspan="3" align="center">
       <b><?php echo _("Address Removed"); ?></b>
      </td>
     </tr>
<?php 
      }

// User's white/black list
$wblistcounter = 0;
foreach ($wbList as $pref) {
  foreach ($pref as $addr) {
    $wblistcounter++;
    if ($wblistcounter % 2) {
      $tr_bgcolor = " bgcolor=$color[0]";
    } else {
      $tr_bgcolor = "";
    }
    // highlight the relevant address line
    if (strstr($addr['value'], $address)) {
      $tr_bgcolor = " bgcolor=$color[3]";
    }
    echo "<tr$tr_bgcolor>";
    echo "<td>". $addr['value'] ."</td>";
    echo "<td>";
    if (isset($wl_params[$addr['preference']]['title'])) {
	echo $wl_params[$addr['preference']]['title'];
    } else {
	echo sprintf(_("Unknown option: %s"), $addr['preference']);
    }
    echo "</td>";
    echo "<td>";
    echo "<a href='sasql_options.php?";
    if (isset($viewsection)) {
      echo "viewsection=$viewsection&";
    }
    echo "delete=".$addr['prefid']."'>"._("Delete")."</a>";
    echo "&nbsp;";
    echo "<a href='sasql_options.php?";
    if (isset($viewsection)) {
      echo "viewsection=$viewsection&";
    }
    echo "edit=".$addr['prefid']."#editform'>"._("Edit")."</a>";
    echo "</td>";
    echo "</tr>\n";
  }
}
?>
    </table><?php /* End white/blacklist */ ?>
   </td>
  </tr>

<?php /* Form */ ?>
<?php
if ($edit) {
  //echo $edit;
  $header = _("Edit Address");
  $addr = sasql_GetPref ($DBHandle, $SqlTable, $username, $edit);
  $formact = "update";
  $type = $addr['preference'];
  $address = $addr['value'];
} else {
  $header = _("Add New Address");
  $formact = "new";
  $type = '';
  $address = '';
}
?>
 <tr>
  <td align="center" bgcolor="<?php echo $color[4]; ?>">
   <b><?php echo $header; ?></b>
  </td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>">
<a name="editform">&nbsp;</a>
<form action="sasql_options.php" method="post">
 <input type="hidden" name="action" value="<?php echo $formact; ?>">
 <input type="hidden" name="prefid" value="<?php echo $addr['prefid'] ?>">
 <table border="0">
<?php
foreach ($errmsg as $msg) {
  echo "<tr><td colspan='2'>";
  echo $msg;
  echo "</td></tr>";
}
?>
  <tr>
   <td><b><?php echo _("Address:"); ?></b></td>
   <td><input name="address" type="text" size="40" maxlength="100" value="<?php echo $address ?>"></td>
  </tr>
  <tr>
   <td><b><?php echo _("Type:"); ?></b></td>
   <td>
    <select name='preference'>
<?php
   foreach ($allowed_wl_params as $param) {
     echo "<option value='$param' ";
     if ($type == $param) { print 'selected'; }
     echo ">".$wl_params[$param]['title']."</option>\n";
   }
?>
    </select>
    <input type="submit" value="<?php echo $header; ?>" name="submit">
   </td>
  </tr>
 </table>
</form>
<?php /* End Form */ ?>

<?php /* Help */ ?>
 <tr>
  <td align="center" bgcolor="<?php echo $color[4]; ?>">
   <b><?php echo _("Legend"); ?></b>
  </td>
 </tr>
 <tr>
  <td align="center" bgcolor="<?php echo $color[4]; ?>">
   <table border='0' width='100%'>
<?php
foreach ($allowed_wl_params as $param) {
  echo '<tr>';
  echo "<td bgcolor='$color[4]'><b>".$wl_params[$param]['title']."</b></td>";
  echo "<td bgcolor='$color[4]'>".$wl_params[$param]['descr']."</td>";
  echo "</tr>\n";
}
?>
   </table>
  </td>
 </tr>
</table>
