<?php
// $Id: policyd.inc.php,v 1.3 2006/11/02 22:06:15 perlstalker Exp $

require_once('DB.php');

if (!defined('SM_PATH')) { define('SM_PATH', '../..'); }

// Set sasql gettext domain
bindtextdomain ('sasql', SM_PATH . 'locale');
textdomain ('sasql');

// policyd does not, yet, allow one to change the DB schema.
// That doesn't stop me from planning for it here :-)
$policyd_tables = array("policy" => "policy");
$policyd_cols = array();
$policyd_cols['policy'] = array("_rcpt" => "_rcpt",
				"_optin" => "_optin",
				"_priority" => "_priority");

// Include SM options
include_once(SM_PATH.'include/validate.php');
include_once(SM_PATH.'functions/page_header.php');
include_once(SM_PATH.'include/load_prefs.php');

// Include sasql config
include_once(SM_PATH.'plugins/sasql/sasql_conf.php');

// Include policyd config
include_once(SM_PATH.'plugins/sasql/policyd_conf.php');

// From policyd config
global $policyd_dsn, $policy_grey_priority, $policyd_grey_default;

// From sasql
global $default_domain;

// From SM
global $username, $color;

sqgetGlobalVar('color', $color, SQ_SESSION);

function policyd_connect () {
  global $policyd_dsn;
  global $color;
  $dbh = DB::connect($policyd_dsn, true);
  if (DB::isError($dbh)) {
    include_once (SM_PATH.'functions/display_messages.php');
    /* To translators: %s's are the function name and PEAR generated errors.
     */
    error_box (sprintf (_("Database error in %s: %s"),
			"policyd_connect",
			DB::errorMessage($dbh)),
	       $color
	       );
    return "";
  }

  return $dbh;
}

function policyd_grey_is_optin ($username) {
  global $default_domain;
  global $color;

  global $policyd_tables, $policyd_cols;

  $dbh = policyd_connect();

  if (isset($default_domain)) {
    $pdom = $default_domain;
  }

  // sasql_options.php appends the domain to the $username
  if (preg_match ('/@(.+)/', $username, $matches)) {
    $pdom = $matches[1];
  }

  $query = sprintf ("SELECT * from %s where %s = '%s' or %s = '@%s' order by %s asc",
		   $policyd_tables['policy'],
		   $policyd_cols['policy']['_rcpt'], $username,
		   $policyd_cols['policy']['_rcpt'], $pdom,
		   $policyd_cols['policy']['_priority']
		   );

  $res = $dbh->query($query);
  if (DB::isError($res)) {
    include_once (SM_PATH.'functions/display_messages.php');
    /* To translators: %s's are the function name and PEAR generated errors.
     */
    error_box (sprintf (_("Database error in %s: %s"),
			"policyd_is_optin",
			$res->getDebugInfo()),
	       $color);
    return "";
  }

  $optin = -1;
  while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)) {
    $optin = $row[$policyd_cols['policy']['_optin']];
  }

  return $optin;
}

function policyd_grey_optinout ($username, $optin) {
  global $policyd_tables, $policyd_cols;
  global $policyd_grey_priority;
  global $color;

  $dbh = policyd_connect();

  $query = sprintf ("DELETE from %s where %s = '%s'",
		    $policyd_tables["policy"],
		    $policyd_cols["policy"]["_rcpt"],
		    $username);

  $res = $dbh->query($query);
  if (DB::isError($res)) {
    include_once (SM_PATH.'functions/display_messages.php');
    /* To translators: %s's are the function name and PEAR generated errors.
     */
    error_box (sprintf (_("Database error in %s: %s"),
			"policyd_grey_optin",
			$res->getDebugInfo()),
	       $color);
    return "";
  }

  $query = sprintf("INSERT into %s values ('%s', '%s', '%s')",
		   $policyd_tables["policy"],
		   $username,
		   $optin ? 1 : 0,
		   $policyd_grey_priority);

  $res = $dbh->query($query);
  if (DB::isError($res)) {
    include_once (SM_PATH.'functions/display_messages.php');
    /* To translators: %s's are the function name and PEAR generated errors.
     */
    error_box (sprintf (_("Database error in %s: %s"),
			"policyd_grey_optin",
			$res->getDebugInfo()),
	       $color);
    return "";
  }


}

sqgetGlobalVar('policyd_submit', $policyd_submit, SQ_FORM);
sqgetGlobalVar('policyd_grey_enable', $policyd_grey_enable, SQ_FORM);

//echo "Enable: $policyd_grey_enable";

if ($policyd_submit) {
  $optin = policyd_grey_is_optin($username);

  if ($policyd_grey_enable) {
    policyd_grey_optinout($username, True);
  } else {
    policyd_grey_optinout($username, False);
  }
}

$optin = policyd_grey_is_optin($username);
if ($optin == -1) {
  $optin = $policyd_grey_default;
}

?>
<form action="sasql_options.php" method="post">
 <input type="hidden" name="update" value="1">
 <table width="100%" border="0" cellpadding"1" cellspacing="1">
  <tr>
   <td align="center" bgcolor="<?php echo $color[4]; ?>">
    <b><?php echo _("Policy Settings"); ?></b>
   </td>
  </tr>
  <tr>
   <td align="center" bgcolor="<?php echo $color[4]; ?>">
    <table border='0' width="100%">
     <td align='right' bgcolor='<?php echo $color[4]; ?>'>
      <input type='checkbox' name='policyd_grey_enable' value='1' <?php if ($optin) { echo "CHECKED"; } ?> />
     </td>
     <td bgcolor='<?php echo $color[4]; ?>'><b>
      <?php echo _("Greylisting"); ?>
     </b></td>
     <td bgcolor='<?php echo $color[4]; ?>'>
      <?php
       /* To translators: %s's are <a ..> and </a> */
       echo sprintf(_('Enable greylisting. See %sthis page%s for more details.'),
         '<a href="sasql_options.php?viewsection=policyd_docs#greylisting">',
         '</a>'
       );
       echo ' <b>'.sprintf(_("Warning: ")).'</b>';
       echo _('Greylisting may delay the delivery of email.');
      ?>
     </td>
    </table>
   </td>
  </tr>
  <tr>
   <td bgcolor="<?php echo $color[4]; ?>">
    <input name="policyd_submit" type="submit" value="<?php echo _("Save Settings"); ?>">
   </td>
  </tr>
 </table>
</form>
<?php
// Set gettext domain back to squirrelmail.
bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');
?>
