<?php

// $Id: sa_opts-dist.php,v 1.12 2005/03/14 18:35:57 perlstalker Exp $

// This file contains the default settings for SpamAssassin options.
// These options can be overridden and new options can be added to
// sa_opts.php. 

// *** You should not edit this file. ***

global $sa_params;	# General params
global $wl_params;	# White/black list

// Set sasql gettext domain
bindtextdomain ('sasql', SM_PATH . 'locale');
textdomain ('sasql');

// required_hists
$sa_params['required_hits']['title'] = _('Spam Score');
$sa_params['required_hits']['descr'] = _("Once all SpamAssassin tests have been run, the resulting score is matched against this value, and if greater than this value, the e-mail message is marked as spam. We recommend a value of '5'.");
$sa_params['required_hits']['type'] = 'select';
$sa_params['required_hits']['values'] = array('0' => _("0 - Very Aggressive"),
					      '1' => _("1"),
					      '2' => _("2 - Aggressive"),
					      '3' => _("3"),
					      '4' => _("4"),
					      '5' => _("5 - Recommended"),
					      '6' => _("6"),
					      '7' => _("7"),
					      '8' => _("8 - Lenient"),
					      '9' => _("9"),
					      '10' => _("10 - Very Lenient"),
					      '99' => _("Don't Filter")
					      );
$sa_params['required_hits']['default'] = '5';

// SA 3 changed required_hits to required_score
$sa_params['required_score'] = $sa_params['required_hits'];

// NOTE: The ordering here is a little odd to allow some inclusion of 
// other option names.
// subject_tag
$sa_params['subject_tag']['title'] = _('Spam Subject Tag');
$sa_params['subject_tag']['type'] = 'text';
$sa_params['subject_tag']['default'] = _('*****SPAM*****');

// rewrite_subject
$sa_params['rewrite_subject']['title'] = _('Rewrite Subject Line');
// To translators: %s is the default from subject_tag
$sa_params['rewrite_subject']['descr'] = sprintf (_('SpamAssassin can re-write the subject line of e-mail that has been determined to be spam by prefixing the original subject with: %s.  To turn on this feature, select this option.'), $sa_params['subject_tag']['default']);
$sa_params['rewrite_subject']['type'] = 'checkbox';
$sa_params['rewrite_subject']['values'] = 1;
$sa_params['rewrite_subject']['default'] = '0';

// This is here to allow me to include the rewrite_subject title

/**
 * To Translators: %s is the title from rewrite_subject
 */
$sa_params['subject_tag']['descr'] = sprintf(_('The text to prefix to the subject of messages determined to be spam. %s must be turned on.'), '<b>'.$sa_params['rewrite_subject']['title'].'</b>');

// 'rewrite_header subject'
$sa_params['rewrite_header subject']['title'] = _('Rewrite Subject Line');
$sa_params['rewrite_header subject']['descr'] = _('SpamAssassin can re-write the subject line of e-mail that has been determined to be spam by prefixing the original subject with this value.');
$sa_params['rewrite_header subject']['type'] = 'text';
$sa_params['rewrite_header subject']['default'] = '';
$sa_params['rewrite_header subject']['delete'] = True;

// use_terse_report
$sa_params['use_terse_report']['title'] = _('Short Report');
$sa_params['use_terse_report']['descr'] = _('This option will tell SpamAssassin to use a shorter spam report once the message has been found to be spam.');
$sa_params['use_terse_report']['type'] = 'checkbox';
$sa_params['use_terse_report']['values'] = 1;
$sa_params['use_terse_report']['default'] = '0';

// use_dcc
$sa_params['use_dcc']['title'] = _('Use DCC');
$sa_params['use_dcc']['descr'] = _('Checks messages against the DCC (Distrubuted Checksum Clearinghouse) to see if a message matches a known spam message.');
$sa_params['use_dcc']['type'] = 'checkbox';
$sa_params['use_dcc']['values'] = 1;
$sa_params['use_dcc']['default'] = '1';

// use_razor1
$sa_params['use_razor1']['title'] = _('Use SpamNet (version 1)');
$sa_params['use_razor1']['descr'] = _('Checks messages against SpamNet to see if a message is a known spam message.');
$sa_params['use_razor1']['type'] = 'checkbox';
$sa_params['use_razor1']['values'] = 1;
$sa_params['use_razor1']['default'] = '0';

// use_razor2
$sa_params['use_razor2']['title'] = _('Use SpamNet (version 2)');
$sa_params['use_razor2']['descr'] = _('Checks messages against SpamNet to see if a message is a known spam message.');
$sa_params['use_razor2']['type'] = 'checkbox';
$sa_params['use_razor2']['values'] = 1;
$sa_params['use_razor2']['default'] = '1';

// always_add_headers
$sa_params['always_add_headers']['title'] = _('Always Add Headers');
$sa_params['always_add_headers']['descr'] = _('Uncheck if you do not want to add the headers to non-spam.');
$sa_params['always_add_headers']['type'] = 'checkbox';
$sa_params['always_add_headers']['values'] = 1;
$sa_params['always_add_headers']['default'] = '0';

// ok_languages
$sa_params['ok_languages']['title'] = _('Acceptable Languages');
$sa_params['ok_languages']['descr'] = _('Select all the languages you expect to receive e-mail in.');
$sa_params['ok_languages']['type'] = 'select';
$sa_params['ok_languages']['multiple'] = true;
$sa_params['ok_languages']['one_line'] = true;
$sa_params['ok_languages']['size'] = 5;
$sa_params['ok_languages']['default'] = array ('all');
$sa_params['ok_languages']['values'] = array("all"=>_("All"),
					     "af"=>_("Afrikaans"),
					     "sq"=>_("Albanian"),
					     "am"=>_("Amharic"),
					     "ar"=>_("Arabic"),
					     "hy"=>_("Armenian"),
					     "eu"=>_("Basque"),
					     "bs"=>_("Bosnian"),
					     "bg"=>_("Bulgarian"),
					     "be"=>_("Byelorussian"),
					     "ca"=>_("Catalan"),
					     "zh"=>_("Chinese"),
					     "hr"=>_("Croatian"),
					     "cs"=>_("Czech"),
					     "da"=>_("Danish"),
					     "nl"=>_("Dutch"),
					     "en"=>_("English"),
					     "eo"=>_("Esperanto"),
					     "et"=>_("Estonian"),
					     "fi"=>_("Finnish"),
					     "fr"=>_("French"),
					     "fy"=>_("Frisian"),
					     "ka"=>_("Georgian"),
					     "de"=>_("German"),
					     "el"=>_("Greek"),
					     "he"=>_("Hebrew"),
					     "hi"=>_("Hindi"),
					     "hu"=>_("Hungarian"),
					     "is"=>_("Icelandic"),
					     "id"=>_("Indonesian"),
					     "ga"=>_("Irish Gaelic"),
					     "it"=>_("Italian"),
					     "ja"=>_("Japanese"),
					     "ko"=>_("Korean"),
					     "la"=>_("Latin"),
					     "lv"=>_("Latvian"),
					     "lt"=>_("Lithuanian"),
					     "ms"=>_("Malay"),
					     "mr"=>_("Marathi"),
					     "ne"=>_("Nepali"),
					     "no"=>_("Norwegian"),
					     "fa"=>_("Persian"),
					     "pl"=>_("Polish"),
					     "pt"=>_("Portuguese"),
					     "qu"=>_("Quechua"),
					     "rm"=>_("Rhaeto-Romance"),
					     "ro"=>_("Romanian"),
					     "ru"=>_("Russian"),
					     "sa"=>_("Sanskrit"),
					     "sco"=>_("Scots"),
					     "gd"=>_("Scottish Gaelic"),
					     "sr"=>_("Serbian"),
					     "sk"=>_("Slovak"),
					     "sl"=>_("Slovenian"),
					     "es"=>_("Spanish"),
					     "sw"=>_("Swahili"),
					     "sv"=>_("Swedish"),
					     "tl"=>_("Tagalog"),
					     "ta"=>_("Tamil"),
					     "th"=>_("Thai"),
					     "tr"=>_("Turkish"),
					     "uk"=>_("Ukrainian"),
					     "vi"=>_("Vietnamese"),
					     "cy"=>_("Welsh"),
					     "yi"=>_("Yiddish"));

// use_bayes
$sa_params['use_bayes']['title'] = _('Use Bayesian Filter');
$sa_params['use_bayes']['descr'] = _('The Baysian Filter will learn what is spam and what isn\'t to become a better filter.');
$sa_params['use_bayes']['type'] = 'checkbox';
$sa_params['use_bayes']['values'] = 1;
$sa_params['use_bayes']['default'] = 0;

// auto_learn
$sa_params['auto_learn']['title'] = _('Auto-learn');
$sa_params['auto_learn']['descr'] = _('Automatically feed high and low scoring mails into SpamAssassin\'s learning systems. (Currently, only Bayesian filtering is supported.)');
$sa_params['auto_learn']['type'] = 'checkbox';
$sa_params['auto_learn']['values'] = 1;
$sa_params['auto_learn']['default'] = 0;

// report_safe
$sa_params['report_safe']['title'] = _('Spam Encapsulation');
$sa_params['report_safe']['descr'] = _('Encapsulate spam messages into a MIME or plain-text attachment, or you can disable it altogether.');
$sa_params['report_safe']['type'] = 'select';
$sa_params['report_safe']['values'] = array("0" => _("Disabled"),
                                            "1" => _("MIME Attachment"),
                                            "2" => _("Text Attachment")
                                            );
$sa_params['report_safe']['default'] = '1';

// These options were removed as of SpamAssassin 2.50-ish
// They are here for those running older versions of SA.
// report_header
$sa_params['report_header']['title'] = _('Report in Header');
$sa_params['report_header']['descr'] = _('SpamAssassin will create a report when it determines an e-mail message to be spam.  This report is normally prepended to the e-mail message.  To have the report written as part of the e-mail header, select this option.');
$sa_params['report_header']['type'] = 'checkbox';
$sa_params['report_header']['values'] = 1;
$sa_params['report_header']['default'] = '0';

// defang_mime
$sa_params['defang_mime']['title'] = _('Reformat HTML Spam');
$sa_params['defang_mime']['descr'] = _('When an e-mail in HTML format is determined to be spam, SpamAssassin can convert the message to text. To allow this, select this option.');
$sa_params['defang_mime']['type'] = 'checkbox';
$sa_params['defang_mime']['values'] = 1;
$sa_params['defang_mime']['default'] = '0';


// Time to save spam (Not a valid sa option)
$sa_params['x-spam-days']['title'] = 'Days to Save Spam';
$sa_params['x-spam-days']['descr'] = 'When an e-mail is determined to be spam, i
t is saved in your <b>Spam</b> folder for this many days.';
$sa_params['x-spam-days']['type'] = 'select';
$sa_params['x-spam-days']['values'] = array("1" => "1 Day",
                                            "2" => "2 Days",
                                            "3" => "3 Days",
                                            "4" => "4 Days",
                                            "5" => "5 Days",
                                            "6" => "6 Days",
                                            "7" => "1 Week",
                                            "8" => "8 Days",
                                            "9" => "9 Days",
                                            "10" => "10 Days",
                                            "11" => "11 Days",
                                            "12" => "12 Days",
                                            "13" => "13 Days",
                                            "14" => "2 Weeks"
                                            );
$sa_params['x-spam-days']['default'] = '10';

// White/black list info

$wl_params['whitelist_from']['title'] = _('Whitelist From');
$wl_params['whitelist_from']['descr'] = _("E-mail from these addresses will not be marked as spam. You may use '*' as a wildcard to allow a large number of addresses at one time. E.g. Whitelist From '*@aol.com' will not mark any message that claims to be from aol.com as spam.");

$wl_params['unwhitelist_from']['title'] = _("Don't Whitelist From");
$wl_params['unwhitelist_from']['descr'] = _('This address will be excluded from a previous whitelist and will be treated as a normal address, i.e. it will not be automatically allowed.');

$wl_params['blacklist_from']['title'] = _('Blacklist From');
$wl_params['blacklist_from']['descr'] = _("E-mail from these addresses will always be marked as spam. You may use '*' as a wildcard to block a large number of addresses at one time. E.g. Blacklist From '*@aol.com' will mark all messages that claims to be from aol.com as spam.");

$wl_params['unblacklist_from']['title'] = _("Don't Blacklist From");
$wl_params['unblacklist_from']['descr'] = _('This address will be excluded from a previous blacklist and will be treated as a normal address, i.e. it will not be automatically denied.');

$wl_params['whitelist_to']['title'] = _('Whitelist To');
$wl_params['whitelist_to']['descr'] = _("E-mail to these addresses will not be marked as spam. This is useful for allowing e-mail lists. For example, you can allow all messages from an e-mail list that sends to 'Tofu-Support-List@beeflovers.com'. You may use '*' as a wildcard to allow a large number of addresses at one time. E.g. Whitelist To '*@aol.com' will not mark any message that claims to be to aol.com as spam.");

$wl_params['blacklist_to']['title'] = _('Blacklist To');
$wl_params['blacklist_to']['descr'] = _("E-mail to these addresses will be marked as spam. You may use '*' as a wildcard to reject a large number of addresses at one time. E.g. Blacklist To '*@aol.com' will mark all messages that claims to be to aol.com as spam.");

// Set gettext domain back to squirrelmail.
bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');

?>
