<?php require('start_section.inc.php'); ?>
<h1>SpamAssassin vs. dspam</h1>
<table width="100%" border="0" cellspacing="0">
 <tr><th>SpamAssassin</th><th>dspam</th></tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   95% accuracy at best (1 misclassification in every 20 messages). Typical
   results are worse.
  </li></ul></td>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   99.95% accuracy when fully "trained" (1 misclassification in every 2000
   messages).
  </li></ul></td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   No user-intervention required, with the exception of a few optional
   settings and the contruction of whitelists and/or blacklists.
  </li></ul></td>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   User must manually "train" the system, allow the filter to "learn" what
   is considered spam and what is not.
  </li></ul></td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   Accuracy tends to decrease over time, forcing the user to spend more and
   more time deleting unwanted spam messages.
  </li></ul></td>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   Accuracy dramatically improves over time, allowing the user to spend less
   time "training" the system.
  </li></ul></td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   Whitelisting and blacklisting features are available.
  </li></ul></td>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   No whitelisting or blacklisting features. This is eventually "learned" by
   the system as you "train" it over time.
  </li></ul></td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   False-positive accuracy depends upon the "spam score" you set. The more
   aggressive you set your spam score, the more likely the system will
   quarantine legitimate messages (unless the sender is whitelisted).
  </li></ul></td>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   False-positive accuracy improves over time as you continue to "train" the
   system. (It is <i>very</i> important that you check your spam folder for
   false-positives, especially during the first few weeks.)
  </li></ul></td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   No token signatures.
  </li></ul></td>
  <td bgcolor="<?php echo $color[4]; ?>"><ul><li>
   A dspam token signature appears at the end of each incoming email
   (necessary for the system's "learning" algorithm).
  </li></ul></td>
 </tr>
</table>
<table width="100%" border="0">
 <tr><th>The Bottom Line</th></tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>">
   <p><b>The case for SpamAssassin:</b></p>
   <blockquote>
    Because SpamAssassin requires no user intervention, it is the best choice
    for those individuals that want a hands-off approach to spam filtering.
    If you receive relatively small amounts of spam, this may be the spam
    filter for you!
   </blockquote>
  </td>
 </tr>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>">
   <p><b>The case for dspam:</b></p>
   <blockquote>
    If you receive moderate to high amounts of spam and want to effectively
    eliminate it altogether, you need to consider dspam. It takes a little
    extra time in the beginning and some attention along the way, but the
    reward in the end is <i>no more spam</i>!
   </blockquote>
  </td>
 </tr>
</table>
<a name="primer"></a>
<h1>The Essential dspam Primer</h1>
<table width="100%" border="0">
 <tr><td bgcolor="<?php echo $color[4]; ?>">
<p><b>What is DSPAM?</b></p>

<p>DSPAM is a learning system that filters spam based on what you tell it
is spam and what isn't.  Because DSPAM's analysis is on a per-user
basis, it is able to customize its rulesets to match your specific email
patterns.  The more messages you receive (both spam and innocent) the
more DSPAM is able to distinguish between messages you consider
legitimate and messages you consider spam.
</p>

<p><b>How does DSPAM learn which messages are spam?</b></p>

<p>DSPAM is designed to "learn" based on the emails you receive, so
whenever you receive a spam message, you simply forward it to a special
email address that will automatically analyze it and learn. This helps
ensure that DSPAM won't be obsolete a year from now, but will continue
to learn the new tricks of spammers.  
</p>

<p>The special email address for reporting spam is username-spam@domain.
For example, if your address is johndoe@amigo.net, you would forward the
message to johndoe-spam@amigo.net.
</p>

<p><b>Do I have to forward each spam message one at a time, or can I forward
several together in a group?</b></p>

<p>When forwarding messages as just described, you must forward each
message one at a time.
</p>

<p>However, there is a faster way to report several messages at once that
may be especially helpful during the first few days when you will likely
have lots of spam to report.  Using Amigo.Net Webmail, simply place a
check next to each message in your Inbox that you want the system to
learn as spam, then move these checked messages to the "Learn Spam"
folder.  It's that easy!  (If you're familiar with the IMAP protocol,
you can even use this method with your favorite email client).
</p>

<p>At a set time each night, any messages contained in your "Learn Spam"
folder will automatically be learned as spam and deleted.  This "batch"
method of submitting spam to the learning system does not provide
instantaneous learning as does the forwarding method described above,
but is much more efficient when submitting numerous spam messages.
</p>

<p><b>How does DSPAM learn which messages aren't spam?</b></p>

<p>As DSPAM is very aggressive about detecting spam, it will likely
quarantine a small percentage of innocent messages, especially in the
first few weeks.  These are known as "false-positives."  It is
imperative that you check your spam folder for these messages regularly
(using Amigo.Net Webmail or an IMAP client), otherwise they will be
"learned" as spam!  Simply forward them to another special email address
(described below) so the system can re-learn them as innocent emails.
Once forwarded, you can move the message into your Inbox or delete it.
</p>

<p>The special email address for reporting false-positives is
username-fp@domain.  For example, if your address is johndoe@amigo.net,
you would forward the message to johndoe-fp@amigo.net.
</p>

<p><b>Why can't I just whitelist certain addresses?</b></p>

<p>DSPAM doesn't have a whitelist manager because it is based exclusively
on automatic Bayesian filtering algorithms.  As you receive more emails
from your colleagues, their "from" addresses and other identifying
information (such as signatures) are automatically learned by DSPAM to
create an internal, automatic whitelist.
</p>

 <tr><th>The Good, the Bad, and the Ugly</th></tr>
 <tr><td bgcolor="<?php echo $color[4]; ?>">

<p><b>The Good...</b>  DSPAM is an extremely effective system for filtering
unwanted spam.  Our own experience has shown that DSPAM can virtually
eliminate spam within just a few days of training the system.
</p>

<p><b>The Bad...</b>  While DSPAM learns to filter unwanted spam very quickly,
it takes a bit longer to learn what isn't spam (due to the comparatively
small amount of innocent messages).  For example, suppose you perform
some online purchases after having activated DSPAM.  Because the email
confirmations generated by those transactions tend to look like spam,
they are likely to be quarantined in your spam folder.  Depending on the
consistency of vendors you purchase from online, it can take DSPAM
awhile to "learn" that these types of messages are actually innocent.
</p>

<p>The importance of checking your spam folder on a regular basis (even
daily, if possible) cannot be over-emphasized, at least during the
initial training period.  Note that this training period varies widely
depending on the number of emails you receive and their consistency.
The necessity of going through all your new spam messages every day is
"the bad" of DSPAM, since the whole purpose of spam filtering is not to
see it any more!  However, in time DSPAM will learn with remarkable
accuracy which messages are truly innocent, and the need to ever visit
your spam folder will significantly diminish.  
</p>

<p><b>TIP 1:</b> Because you should check your spam folder daily in the
beginning, we recommend that you select the option to "Clean out your spam
folder on opt-in" when activating DSPAM.  Then, after checking your spam folder
each day and forwarding any false-positives, conclude each session by
deleting all remaining spam messages.  This will help prevent searching
through the same spam messages repeatedly.
</p>
 
<p><b>The Ugly...</b> Because DSPAM is a learning system, it can produce
horrible results if not trained properly or in a timely manner.  One of our
users activated DSPAM, but failed to forward the spams he received for the
first several days (the most critical period!)  Within one week he was
receiving over 100 spam messages a day, because the system was
continually learning them as innocent.  Please note that any messages
not reported as spam within ten days will be permanently learned as
innocent and you will therefore be more likely to receive such spam.  In
the case mentioned above, the user forwarded the messages in time and
effectively trained his system, but it took a lot more work than would
have otherwise been necessary.
</p>
 
<p>The same goes for false-positives quarantined in your spam folder; if
you don't forward them as false-positives the system will continue to
learn them as spam and they'll never show up in your Inbox.  In short,
the effort required to train DSPAM is minimal but essential.  Ignore it
(especially in the beginning), and DSPAM can truly get "ugly."
</p>

<p><b>TIP 2:</b> Because you have up to ten days before permanent learning
takes place, you may want to set the "Days to Save Spam" option to "10 Days."
While we recommend that you purge your spam folder daily (see Tip 1),
this will help ensure that innocent messages don't get deleted before
you have a chance to forward them as false-positives.
</p>

 </td></tr>
</table>
<?php require('end_section.inc.php'); ?>