<?php
// $Id: dspam.inc.php,v 1.10 2005/03/14 18:35:49 perlstalker Exp $

if (!defined('SM_PATH')) { define('SM_PATH' , '../../'); }

include_once(SM_PATH.'include/validate.php');
include_once(SM_PATH.'functions/page_header.php');
include_once(SM_PATH.'include/load_prefs.php');
include_once(SM_PATH.'plugins/sasql/sasql_conf.php');
include_once(SM_PATH.'plugins/sasql/sasql_api.php');

// dspam config
include_once(SM_PATH.'plugins/sasql/dspam_conf.php');

// from dspam config
global $dspam_userdir;
global $enable_optin;
global $enable_homedir_dotfiles;
global $clean_spam;
global $show_SAdisabled_earning;

// from sasql config
global $spam_folder;

// from SM
global $username;
global $color;

function is_opt_in () {
  global $dspam_userdir, $enable_optin, $username;
  if ($enable_optin
      && file_exists("$dspam_userdir/opt-in/$username.dspam")
      ) {
    $opt_in = 1;
  } elseif (! $enable_optin
	    && ! file_exists("$dspam_userdir/opt-out/$username.nospam")
	    ) {
    $opt_in = 1;
  } else {
    $opt_in = 0;
  }
  return $opt_in;
}

$opt_in = is_opt_in();

sqgetGlobalVar('dspam_optin', $dspam_optin, SQ_FORM);
sqgetGlobalVar('dspam_cleanspam', $dspam_cleanspam, SQ_FORM);
sqgetGlobalVar('dspam_submit', $dspam_submit, SQ_FORM);

if ($dspam_submit) {
  if ($enable_optin) {
    if (! $opt_in && $dspam_optin) {
      // create $dspam_userdir/opt-in/$username.dspam
      touch("$dspam_userdir/opt-in/$username.dspam");
      if ($clean_spam) {
	// delete the messages from the spam folder.
	sasql_purgeSpam();
      }
    } elseif ($opt_in && ! $dspam_optin) {
      // remove $dspam_userdir/opt-in/$username.dspam
      unlink ("$dspam_userdir/opt-in/$username.dspam");
    }
  } else {
    if ($opt_in && ! $dspam_optin) {
      // create $dspam_userdir/opt-out/$username.nospam
      touch("$dspam_userdir/opt-out/$username.nospam");
    } elseif (! $opt_in && $dspam_optin) {
      // remove $dspam_userdir/opt-out/$username.nospam
      unlink ("$dspam_userdir/opt-out/$username.nospam");
    }
  }
}

$opt_in = is_opt_in();

?>

<table width="100%" border="0" cellpadding="1" cellspacing="1">
 <tr>
  <td align="center" bgcolor="<?php echo $color[4]; ?>">
   <b><?php echo _("DSPAM Settings"); ?></b>
  </td>
 </tr>
<?php if ($show_SAdisabled_warning): ?>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>">
   <p>
   <b><?php echo _("Warning"); ?>:</b>
   <?php
   echo _("Enabling DSPAM will disable SpamAssassin scanning of your email.");
?>
   <i><?php
   echo _("SpamAssassin settings and white/blacklists will not be used by dspam.");
?></i>
   </p>
   <p>
   <?php 
/**
 * To translators: %s's will be replaced with <a ..> and </a>
 */
   echo sprintf(_("This %sFAQ%s from the DSPAM web site explains the differences between SpamAssassin and DSPAM and why you might want to use dspam instead of SpamAssassin."), '<a href="http://www.nuclearelephant.com/projects/dspam/faq.html#1.7" target="_blank">', '</a>');
?>
   </p>
<?php endif; ?>
  </td>
 </tr>
<?php if ($show_instructions): ?>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>">
   <p>
<?php
   echo _("DSPAM is a learning system that filters spam based on what <i>you</i> tell it is spam and what isn't. Messages are analyzed as they are delivered and are assigned a spam probability between 0 and 1. The more messages you receive, both spam and innocent, the better DSPAM learns what <i>you</i> think is spam and what is not.");
?>
   </p>

   <p><b><?php echo _("Reporting Spam") ?>:</b></p>
   <p>
<?php
   echo _("If you receive a spam message in your Inbox, forward the message to <nobr>username-spam@domain</nobr> and it will be learned as spam. For example, if your address is joe@example.com, you would forward the message to <nobr>joe-spam@example.com</nobr>.");
?>
   </p>

   <?php if ($sasql_use_learn and $learn_spam_folder): ?>
   <p><?php
   echo sprintf(_("You can also move your spam messages to the <i>%s</i> folder. This folder is periodically checked for messages which are then learned as spam and deleted. You do not need to move messages from your %s folder here because they have already been learned as spam."),
		$learn_spam_folder, $spam_folder);
   ?></p>
   <?php endif; ?>

   <p><b><?php echo _("Reporting False Positives") ?>:</b></p>
   <p>
<?php
   echo _("From time to time, DSPAM will catch an innocent messages as spam. These messages are called \"false positives\". There is no way to prevent false positives entirely. If you find a false positive, forward the message to <nobr>username-fp@domain</nobr> and it will be learned as an innocent message. For example, if your email address is joe@example.com, you would forward the message to <nobr>joe-fp@example.com</nobr>.");
?>
   </p>

   <?php if ($sasql_use_learn and $learn_fp_folder): ?>
   <p><?php
   echo sprintf(_("You can also move your false positives to the <i>%s</i> folder from the %s folder. This folder is periodically checked for messages which are then learned as false positives and deleted."),
		$learn_fp_folder, $spam_folder);
   ?></p>
   <?php endif; ?>

   <p><b><?php echo _("Disclaimer"); ?>: </b></p>
   <p>
<?php
   echo _("DSPAM is a learning system. It only knows what is spam based on what you teach it is spam and what is not. Due to DSPAM's nature, you are more likely to see errors in spam detection until it is trained on your email. If you do not report a message as spam within ten days, the message will be permanently learned as innocent and you will be more likely to receive more spam.");
?>
   </p>
  </td>
 </tr>
<?php endif; ?>
<?php if ($show_primer_link): ?>
 <tr>
  <td bgcolor="<?php echo $color[4]; ?>">
   <p>
<?php
/**
 * To translators: %s's will be replaced by <a ..> and </a>
 */
echo sprinf(_("Please read the %sDSPAM Primer%s before enabling DSPAM.",
	      '<a href="sasql_options.php?viewsection=dspam_primer#primer" target="_BLANK">',
	      '</a>'));
?>
   </p>
  </td>
 </tr>
<?php endif; ?>
 <tr>
  <td align="center" bgcolor="<?php echo $color[4]; ?>">
   <form action='sasql_options.php' method='Post'>
    <table border='0' width='100%'>
     <tr>
      <td align='right'>
   <?php if ($opt_in): ?>
       <input type='checkbox' name='dspam_optin' value='1' CHECKED/>
   <?php else: ?>
       <input type='checkbox' name='dspam_optin' value='1' />
   <?php endif; ?>
      </td>
      <td>
       <p><b><?php echo _("Use DSPAM") ?></b></p>
      </td>
      <td></td>
     </tr>
   <?php if ($enable_optin && $clean_spam && ! $opt_in): ?>
     <tr>
      <td align='right'>
       <input type='checkbox' name='dspam_cleanspam' value='1' SELECTED/>
      </td>
      <td>
       <p><b>
       <?php
       /**
        * To translators: %s is the name of the spam folder.
        */
         echo sprintf(_("Clean out your %s folder on opt-in?"),$spam_folder);
       ?></b>
       <b><?php echo _("Note")?>:</b>
       <?php
       /**
        * To translators: %s is the name of the spam folder.
        */
         echo sprintf(_("Your %s folder may be unavailable during the purge. It will become available again when the purge is complete."), $spam_folder);
       ?>
       </p>
      </td>
      <td></td>
     </tr>
   <?php endif; ?>
     <tr>
      <td colspan='3'>
       <input type='submit' name='dspam_submit' value='<?php echo _("Update"); ?>' />
      </td>
     </tr>
    </table>
   </form>
  </td>
 </tr>
</table>
