<?php

/**
  * SquirrelMail Same IP Plugin
  * Copyright (c) 2007 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage same_ip
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_same_ip() {

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_before']['same_ip']
      = 'same_ip_save_checkbox_cookie';

   $squirrelmail_plugin_hooks['login_verified']['same_ip']
      = 'same_ip_register_ip';

   $squirrelmail_plugin_hooks['configtest']['same_ip']
      = 'same_ip_check_configuration';



   // SM 1.4.x
   //
   $squirrelmail_plugin_hooks['login_form']['same_ip']
      = 'same_ip_show_checkbox';

   $squirrelmail_plugin_hooks['loading_constants']['same_ip']
      = 'same_ip_validate_ip';



   // SM 1.5.x
   //
   $squirrelmail_plugin_hooks['template_construct_login.tpl']['same_ip']
      = 'same_ip_show_checkbox';

   $squirrelmail_plugin_hooks['config_override']['same_ip']
      = 'same_ip_validate_ip';

}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns info about this plugin
  *
  */
function same_ip_info()
{

   return array(
                 'english_name' => 'Same IP',
                 'version' => '1.0',
                 'required_sm_version' => '1.2.9',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'required_plugins' => array(
                              'compatibility' => array(
                                         'version' => '2.0.7',
                                         'activate' => FALSE,
                              )
                 ),
                 'summary' => 'Allows users to restrict their login session to a single IP address.',
                 'details' => 'This plugin enables users to keep their SquirrelMail login session slightly more secure by allowing them to limit all page requests to the SquirrelMail server to come from the same IP address from which they logged in.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function same_ip_version()
{

   $info = same_ip_info();
   return $info['version'];

}



/**
  * Show checkbox on login page
  *
  */
function same_ip_show_checkbox()
{

   include_once(SM_PATH . 'plugins/same_ip/functions.php');
   return same_ip_show_checkbox_do();

}



/**
  * Saves cookie containing checkbox selection
  *
  */
function same_ip_save_checkbox_cookie()
{

   include_once(SM_PATH . 'plugins/same_ip/functions.php');
   same_ip_save_checkbox_cookie_do();

}



/**
  * Makes note of the IP address from which the user logged in
  *
  */
function same_ip_register_ip()
{

   include_once(SM_PATH . 'plugins/same_ip/functions.php');
   same_ip_register_ip_do();

}



/**
  * Validate that the user's page request is coming from the
  * same IP address used to log in
  *
  */
function same_ip_validate_ip()
{

   include_once(SM_PATH . 'plugins/same_ip/functions.php');
   same_ip_validate_ip_do();

}



/**
  * Validate that this plugin is configured correctly
  *
  */
function same_ip_check_configuration()
{

   include_once(SM_PATH . 'plugins/same_ip/functions.php');
   return same_ip_check_configuration_do();

}



