<?php

/**
  * SquirrelMail Same IP Plugin
  * Copyright (c) 2007 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage same_ip
  *
  */



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function same_ip_check_configuration_do()
{

   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // try to find Compatibility, and then that it is v2.0.7+
      //
      if (function_exists('check_plugin_version')
       && check_plugin_version('compatibility', 2, 0, 7, TRUE))
         return FALSE;


      // something went wrong
      //
      do_err('Same IP plugin requires the Compatibility plugin version 2.0.7+', FALSE);
      return TRUE;

   }

}



/**
  * Show checkbox on login page
  *
  */
function same_ip_show_checkbox_do()
{

   $si_stay_same = 0;
   sqGetGlobalVar('si_stay_same', $si_stay_same, SQ_COOKIE);
   if ($si_stay_same == 'deleted') $si_stay_same = 0;
   $si_stay_same = (bool)$si_stay_same;


   sq_change_text_domain('same_ip');
   

   // from SM 1.5.2 an up, just use our template, only need to
   // assign a couple values to it
   // 
   if (check_sm_version(1, 5, 2))
   {
      global $oTemplate;
      $oTemplate->assign('si_stay_same', $si_stay_same);
      $output = $oTemplate->fetch('plugins/same_ip/login_form.tpl');
   }
   

   // old style output...
   // 
   else
   {
   
      // really crappy placement of new login_form hook in 1.5.1
      // 
      if (check_sm_version(1, 5, 1) && !check_sm_version(1, 5, 2))
         $output = "</td></tr>\n";
      else
         $output = '';
         

      // build regular output
      // 
      $output .= "<tr><td colspan=\"2\"><br /><center>\n"
              . "<table width=\"350\">\n"
              . "<tr><td><center><input type='checkbox'" 
              . ($si_stay_same ? ' checked' : '') 
              . " name='stay_same' id='stay_same' value='1'><label for='stay_same'>" 
              . _("Restrict this session to this IP address") 
              . "</label>\n</center></td></tr>\n</table>\n</center>\n";


      // really crappy placement of new login_form hook in 1.5.1
      //
      if (check_sm_version(1, 5, 1) && !check_sm_version(1, 5, 2))
         $output .= '';
      else
         $output .= '</td></tr>';

   }

   sq_change_text_domain('squirrelmail');


   // depending on SM version, either return or display output
   //
   if (check_sm_version(1, 5, 2))
      return array('login_form' => $output);
   else if (check_sm_version(1, 5, 1))
      return $output;
   else
      echo $output;

}



/**
  * Saves cookie containing checkbox selection
  *
  * NOTE: ideally, we'd just combine this with 
  *       same_ip_register_ip_do(), but there is
  *       a glitch in SM 1.5.1 where the cookie
  *       will be lost if we do so
  *
  */
function same_ip_save_checkbox_cookie_do()
{

   $stay_same = 0;
   if (sqGetGlobalVar('stay_same', $stay_same, SQ_FORM) && $stay_same)
   {

      // store user's checkbox preference in a 
      // cookie for convenience (cookie expires 
      // in 30 days)
      //
      sqsetcookie('si_stay_same', $stay_same, (time()+60*60*24*30));

   }
   else
   {

      // just clear cookie
      //
      sqsetcookie('si_stay_same', 'deleted', (time() - 3600));

   }

}



/**
  * Makes note of the IP address from which the user logged in
  *
  */
function same_ip_register_ip_do()
{

   $stay_same = 0;
   if (sqGetGlobalVar('stay_same', $stay_same, SQ_FORM) && $stay_same)
   {

      // store the IP address in session
      //
      $user_ip = '';
      if (!sqGetGlobalVar('REMOTE_ADDR', $user_ip, SQ_SERVER) || empty($user_ip))
      {
         sq_change_text_domain('same_ip');
         $error_msg = _("Sorry, could not determine your current IP address.");
         sq_change_text_domain('squirrelmail');

         logout_error($error_msg);
         exit;
      }

      sqsession_register($user_ip, 'si_user_ip');

   }
   else
   {

      // just clear user's IP
      //
      sqsession_register('', 'si_user_ip');

   }

}



/**
  * Validate that the user's page request is coming from the
  * same IP address used to log in
  *
  */
function same_ip_validate_ip_do()
{

   // don't execute this hook more than once
   //
   global $is_same_ip_logout_error;
   if ($is_same_ip_logout_error) return;


   // this is run even on the login page, so we return in that case
   //
   global $PHP_SELF;
   if (stristr($PHP_SELF, '/login.php'))
      return;


   // no IP address is stored in session; user gets a free pass
   //
   $si_user_ip = '';
   if (!sqGetGlobalVar('si_user_ip', $si_user_ip, SQ_SESSION) || empty($si_user_ip))
      return;


   // now get the IP address for this page request and compare...
   //
   $user_ip = '';
   if (!sqGetGlobalVar('REMOTE_ADDR', $user_ip, SQ_SERVER) || empty($user_ip))
   {

      // due to the early position of this hook, need to finish
      // some initialization tasks before a logout error can 
      // be shown on screen
      //
      si_finish_sm_init();     

      sq_change_text_domain('same_ip');
      $error_msg = _("Sorry, could not determine your current IP address.");
      sq_change_text_domain('squirrelmail');

      logout_error($error_msg);
      exit;
   }

   if ($user_ip != $si_user_ip)
   {

      // due to the early position of this hook, need to finish
      // some initialization tasks before a logout error can 
      // be shown on screen
      //
      si_finish_sm_init();     

      sq_change_text_domain('same_ip');
      $error_msg = _("Sorry, unauthorized page request.");
      sq_change_text_domain('squirrelmail');

      logout_error($error_msg);
      exit;
   }

}



/**
  * Finish SquirrelMail initialization tasks just enough to be
  * able to display a logout error when one occurs on the config_override
  * hook in 1.5.2+ or the loading_constants hook in 1.5.1-
  *
  */
function si_finish_sm_init()
{

   if (check_sm_version(1, 5, 2))
   {
      include_once(SM_PATH . 'functions/display_messages.php' );
      include_once(SM_PATH . 'functions/page_header.php');
      include_once(SM_PATH . 'functions/html.php');
      global $sTemplateID, $oTemplate, $squirrelmail_language;
      $sTemplateID = Template::get_default_template_set();
      $oTemplate = Template::construct_template($sTemplateID);
      set_up_language($squirrelmail_language, true);

      return;
   }


   if (check_sm_version(1, 5, 0))
   {
      global $is_same_ip_logout_error;
      $is_same_ip_logout_error = true;
      include_once(SM_PATH . 'include/load_prefs.php');

      return;
   }


//NOTE: not tested with all 1.4.x versions, but should work; if errors occur, please let me know
   if (check_sm_version(1, 4, 0))
   {
      // the following line is only needed because webmail.php 
      // doesn't include validate.php; argh!
      //
      include_once(SM_PATH . 'functions/i18n.php');


      include_once(SM_PATH . 'functions/display_messages.php');

      return;
   }


   // older versions, we'll just dump out a raw error to the browser
   // and forget the rest of the fancy stuff...
   //
   sq_change_text_domain('same_ip');
   $error_msg = _("Sorry, unauthorized page request.");
   echo $error_msg;
   exit;

}



