<?php

/*
 *	SAConf - SpamAssassin configuration plugin for SquirrelMail
 *	By Patrick Swieskowski
 */

	chdir('..');
	require_once('../src/validate.php');
	require_once('../functions/page_header.php');
	require_once('../functions/imap.php');
	require_once('../src/load_prefs.php');
	require_once('../plugins/saconf/saconf_conf.php');

	global $username, $key, $imapServerAddress, $imapPort;
	global $folders;
	global $dest_folder;
	global $threshold;
	global $whitelist;

	$threshold = 5.0;
	$whitelist = array();

	$imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
	$boxes = sqimap_mailbox_list($imapConnection);
	sqimap_logout($imapConnection);
	$folders = array();
	for ($i = 0; $i < count($boxes); $i++)
		if (!in_array('noselect', $boxes[$i]['flags']))
			array_push($folders, $boxes[$i]['unformatted']);

	proc_get("/tmp/pmrc.$username");
	read_recipie("/tmp/pmrc.$username");
	sa_get("/tmp/sa.$username");
	read_prefs("/tmp/sa.$username");
	
	if (array_key_exists("modify_folder_x", $_POST)) {
		saconf_firstrule("/tmp/pmrc.$username");
		$index = $_POST['folder'];
		$dest_folder = $folders[$index];
		write_recipie("/tmp/pmrc.$username", "/tmp/npmrc.$username");
		proc_put("/tmp/npmrc.$username");
		unlink("/tmp/npmrc.$username");
	} else if (array_key_exists("modify_threshold_x", $_POST)) {
		$threshold = $_POST['threshold'];
		write_prefs("/tmp/sa.$username", "/tmp/nsa.$username");
		sa_put("/tmp/nsa.$username");
		unlink("/tmp/nsa.$username");
	} else if (array_key_exists("add_whitelist_x", $_POST)) {
		$addr = $_POST['addr'];
		array_push($whitelist, $addr);
		write_prefs("/tmp/sa.$username", "/tmp/nsa.$username");
		sa_put("/tmp/nsa.$username");
		unlink("/tmp/nsa.$username");
	} else if (array_key_exists("delete_whitelist_x", $_POST)) {
		$index = $_POST['listindex'];
		$whitelist = array_merge(array_slice($whitelist, 0, $index), array_slice($whitelist, $index+1));
		write_prefs("/tmp/sa.$username", "/tmp/nsa.$username");
		sa_put("/tmp/nsa.$username");
		unlink("/tmp/nsa.$username");
	}
	
	unlink("/tmp/sa.$username");
	unlink("/tmp/pmrc.$username");

	displayPageHeader($color, 'None');
?>
<br>
<table width="95%" align=center border=0 cellpadding=2 cellspacing=0>
<tr><td align="center" bgcolor="<?= $color[0] ?>">
	<b><?php echo _("Options") . " - " . _("Spam Filter Configuration"); ?></b>

<table width="100%" border=0 cellpadding=1 cellspacing=1>
<tr><td bgcolor="<?= $color[4] ?>" align=center><br>
<table border=0 cellpadding=1 cellspacing=5>
<form method=post action="saconf_options.php">
<input type=hidden name=modify_threshold.x value=12>
<tr><td>
Spam Threshold: <input type=text size=4 name=threshold value="<?= $threshold ?>">
</td>
<td><input type=image src="images/save.gif" border=0 name="modify_threshold" alt="save"></td>
</tr>
</form>
</table>
<p>The Spam Threshold is a measure of how lenient the spam filter is.  Higher numbers let more spam through, lower numbers mean more innocent mail is marked as spam.  Set this high (like 100) to disable spam filtering.  A reasonable default is 5.

<hr>

<table border=0 cellpadding=1 cellspacing=5>
<form method=post action="saconf_options.php">
<tr><td>
Move my spam to <?= folderDropdown() ?>
</td>
<td><input type=image src="images/save.gif" border=0 name="modify_folder" alt="save"></td>
</tr>
</form>
</table>
<p><b>Notice:</b> Use of this filter may prevent the reading of mail in non-IMAP mail clients.

<hr>

<table border=0 cellpadding=1 cellspacing=5>
<caption><b><u>Whitelist</u></b></caption>
<?php
	print_whitelist();
?>
<form method=post action="saconf_options.php">
<input type=hidden name=add_whitelist.x value=12>
<tr>
<td><input type=text name=addr></td>
<td><input type=image src="images/saveas.gif" border=0 name="add_whitelist" alt="save new"></td>
</tr>
</form>
</table>
<p>The whitelist is a list of email addresses whose messages will never be marked as spam.  The whitelist accepts * wildcards.  So *@example.com means that all mail originating from example.com will never be marked as spam.

</td></tr>
</table>
</td></tr>
</table>
</body>
</html>

<?php
	// Display dropdown menu of folder options

	function folderDropdown() {
		global $folders;
		global $dest_folder;

		print("<select name=folder>\n");

		for ($i = 0; $i < count($folders); $i++) {
			print("<option value=\"$i\"");
			if ($folders[$i] == $dest_folder)
				print(" selected");
			print(">$folders[$i]</option>\n");
		}
		
		print("</select>\n");
	}

	// Get the .procmailrc file

	function proc_get($localfile) {
		global $username, $key, $onetimepad, $imapServerAddress;
		$password = OneTimePadDecrypt($key, $onetimepad);
	
		$conn = @ftp_connect($imapServerAddress);
		@ftp_login($conn, $username, $password);
		@ftp_get($conn, $localfile, ".procmailrc", FTP_ASCII) or touch($localfile);

		@ftp_close($conn);
	}

	// Get the user_prefs file

	function sa_get($localfile) {
		global $username, $key, $onetimepad, $imapServerAddress;
		$password = OneTimePadDecrypt($key, $onetimepad);
	
		$conn = @ftp_connect($imapServerAddress);
		@ftp_login($conn, $username, $password);
		@ftp_get($conn, $localfile, ".spamassassin/user_prefs", FTP_ASCII) or touch($localfile);

		@ftp_close($conn);
	}

	// Put the .procmailrc file

	function proc_put($localfile) {
		global $username, $key, $onetimepad, $imapServerAddress;
		$password = OneTimePadDecrypt($key, $onetimepad);
	
		$conn = ftp_connect($imapServerAddress);
		ftp_login($conn, $username, $password);
		ftp_put($conn, ".procmailrc", $localfile, FTP_ASCII);

		ftp_close($conn);
	}

	// Put the user_prefs file

	function sa_put($localfile) {
		global $username, $key, $onetimepad, $imapServerAddress;
		$password = OneTimePadDecrypt($key, $onetimepad);
	
		$conn = ftp_connect($imapServerAddress);
		ftp_login($conn, $username, $password);
		@ftp_mkdir($conn, ".spamassassin");
		ftp_put($conn, ".spamassassin/user_prefs", $localfile, FTP_ASCII);

		ftp_close($conn);
	}

	// Read the recipie from the .procmailrc file
	
	function read_recipie($localfile) {
		global $dest_folder;
	
		$fd = fopen($localfile, "r");
		while (!feof($fd) && $buf != "##Spam Filter Configuration Begins -- Please do not edit by hand")
			$buf = rtrim(fgets($fd));

		if (!feof($fd)) {
			$buf = rtrim(fgets($fd));
			$dest_folder = substr($buf, 3);
		}

		fclose($fd);
	}

	// Write the procmail recipe
	
	function write_recipie($oldfile, $newfile) {
		global $recipies;
		global $MAILDIR;
		global $dest_folder;
	
		$of = fopen($oldfile, "r");
		$nf = fopen($newfile, "w");

		$buf = rtrim(fgets($of));
		while (!feof($of) && $buf != "##Spam Filter Configuration Begins -- Please do not edit by hand") {
			fputs($nf, "$buf\n");
			$buf = rtrim(fgets($of));
		}


		fputs($nf, "##Spam Filter Configuration Begins -- Please do not edit by hand\n");
		fputs($nf, "###${dest_folder}\n");
		fputs($nf, "MAILDIR=$MAILDIR # Default mail directory\n");
		fputs($nf, ":0:\n* ^X-Spam-Status: Yes\n${dest_folder}\n");
		fputs($nf, "##Spam Filter Configuration Ends\n");


		while (!feof($of) && $buf != "##Spam Filter Configuration Ends")
			$buf = rtrim(fgets($of));

		while (!feof($of)) {
			$buf = fgets($of);
			fputs($nf, "$buf");
		}

		fclose($of);
		fclose($nf);
	}

	// Read the user_prefs file
	
	function read_prefs($localfile) {
		global $threshold;
		global $whitelist;
	
		$fd = fopen($localfile, "r");
		while (!feof($fd) && $buf != "##Spam Filter Configuration Begins -- Please do not edit by hand")
			$buf = rtrim(fgets($fd));

		while (!feof($fd) && $buf != "##Spam Filter Configuration Ends") {
			$buf = rtrim(fgets($fd));
			if (substr($buf, 0, 4) == '###w')
				array_push($whitelist, substr($buf, 4));
			if (substr($buf, 0, 4) == '###t') {
				$threshold = substr($buf, 4);
			}
		}

		fclose($fd);
	}

	// Write the user_prefs file
	
	function write_prefs($oldfile, $newfile) {
		global $threshold;
		global $whitelist;
	
		$of = fopen($oldfile, "r");
		$nf = fopen($newfile, "w");

		$buf = rtrim(fgets($of));
		while (!feof($of) && $buf != "##Spam Filter Configuration Begins -- Please do not edit by hand") {
			fputs($nf, "$buf\n");
			$buf = rtrim(fgets($of));
		}


		fputs($nf, "##Spam Filter Configuration Begins -- Please do not edit by hand\n");
		fputs($nf, "###t${threshold}\nrequired_hits\t${threshold}\n\n");

		for ($i = 0; $i < count($whitelist); $i++) {
			$addr = $whitelist[$i];
			fputs($nf, "###w${addr}\nwhitelist_from\t${addr}\n\n");
		}

		fputs($nf, "\n##Spam Filter Configuration Ends\n");

		while (!feof($of) && $buf != "##Spam Filter Configuration Ends")
			$buf = rtrim(fgets($of));

		while (!feof($of)) {
			$buf = fgets($of);
			fputs($nf, "$buf");
		}

		fclose($of);
		fclose($nf);
	}

	function print_whitelist() {
		global $whitelist;

		for ($i = 0; $i < count($whitelist); $i++) {
			print("<form method=post action=\"saconf_options.php\">\n");
			print("<input type=hidden name=listindex value=$i>\n");
			print("<tr>\n<td>$whitelist[$i]</td>\n");
			print("<td><input type=image src=\"images/delete.gif\" border=0 name=\"delete_whitelist\" alt=\"delete\"></td>\n</tr>\n</form>\n");
		}
	}

	function saconf_firstrule($localfile) {
		// Make certain that spam filter rule is before other filters
		// so other filters don't get mail before it's checked for spam

		global $username;

		rename($localfile, "/tmp/tpmrc.$username");

		$fd = fopen("/tmp/tpmrc.$username", "r");
		$noentry = 1;
		while (!feof($fd) && $buf != "##Begin Procfilter Configuration -- Please do not edit by hand, use SquirrelMail") {
			$buf = rtrim(fgets($fd));
			if ($buf == "##Spam Filter Configuration Begins -- Please do not edit by hand")
				$noentry = 0;
		}
		if (feof($fd) || $noentry == 0)
			rename ("/tmp/tpmrc.$username", $localfile);
		else {
	
			fclose($fd);
			$fd = fopen("/tmp/tpmrc.$username", "r");
			$nf = fopen("$localfile", "w");
			$buf = fgets($fd);
			while (!feof($fd) && $buf != "##Begin Procfilter Configuration -- Please do not edit by hand, use SquirrelMail\n") {
				fputs($nf, "$buf");
				$buf = fgets($fd);
			}
			fputs($nf, "##Spam Filter Configuration Begins -- Please do not edit by hand\n##Spam Filter Configuration Ends\n");
			while (!feof($fd)) {
				fputs($nf, "$buf");
				$buf = fgets($fd);
			}
			fclose($fd);
			fclose($nf);
			unlink("/tmp/tpmrc.$username");
		}
	}
?>
