<?php

// check whether we should use soupNazi or checkForJavascript
function use_soup() {
	if (check_sm_version (1, 5, 1)) {
		return false;
	} else {
		return true;
	}
}

function using_js() {
	if (use_soup()) {
		return !soupNazi();
	}
	else {
		return checkForJavascript();
	}
}

function rewrap_scripts_do()
{
	global $PHP_SELF;

	/* only add this javascript when we are in the compose page */
	// functions/from page_header.php
	sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION );
    	$module = substr( $PHP_SELF, ( strlen( $PHP_SELF ) - strlen( $base_uri ) ) * -1 );
	if ($qmark = strpos($module, '?')) {
		$module = substr($module, 0, $qmark);
	}
	if ($module == 'src/compose.php' && using_js()) {
		echo "\n"
		   . '<script type="text/javascript" src="../plugins/rewrap/rewrap.js"></script>'
		   . "\n";
	}
}

function rewrap_setup_do()
{
	/* i18n.php defines the _() syntax */
	include_once (SM_PATH . 'functions/i18n.php');
	/* Now tell gettext where the locale directory
	 * for the plugin is, in relation to the src/ dir
	 */
	bindtextdomain ('rewrap', SM_PATH . 'plugins/rewrap/locale');
	/* Switch to our plugin domain so messages get translated */
	textdomain ('rewrap');

	if (using_js()) {
		echo "\n"
		   . '<input type="button" value="'
		   . _("Rewrap")
		   . '" onclick="javascript:this.form.body.value=sq_rewrap(this.form.body.value, this.form.body.cols)">'
		   . "\n";
	}

	/* Switch back to the SquirrelMail domain */
	bindtextdomain ('squirrelmail', SM_PATH . 'locale');
	textdomain ('squirrelmail');
}

?>
