<?php

/**
  * SquirrelMail Rewrap Compose Text Plugin
  * Copyright (c) 2003-2004 Justus Pendleton <justus@ryoohki.net>
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage rewrap
  *
  */



/**
  * Include JavaScript that accomplishes the rewrap functionality
  *
  */
function rewrap_add_script_do($args)
{

   // only need to bother when we are on the compose page
   // and when javascript is activated/in use
   //
   global $javascript_on;
   if (!$javascript_on) return;

   if (defined('PAGE_NAME'))
   {
      if (PAGE_NAME != 'compose') return;
   }
   else
   {
      global $PHP_SELF;
      if (strpos($PHP_SELF, '/src/compose') === FALSE)
         return;
   }


   // ok to proceed to output the needed script link
   //
   $script = '<script type="text/javascript" language="JavaScript" src="' . sqm_baseuri() . 'plugins/rewrap/rewrap.js"></script>';


   // get script tag out correctly depending on SM version
   //
   if (check_sm_version(1, 5, 2))
   {
      $args[0] .= $script;
   }
   else
   {
      echo "\n" . $script . "\n";
   }

}



/**
  * Add the "Rewrap" button to the compose screen
  *
  */
function rewrap_add_button_do()
{

   // only need to bother when javascript is activated/in use
   //
   global $javascript_on;
   if (!$javascript_on) return;


   sq_change_text_domain('rewrap');
   $button_script = 'javascript:this.form.body.value=sq_rewrap(this.form.body.value, this.form.body.cols)';
   $button_value = _("Rewrap");
   sq_change_text_domain('squirrelmail');


   if (check_sm_version(1, 5, 2))
   {

      global $oTemplate, $nbsp;
      $output = addButton($button_value, '',
                          array('onclick' => $button_script))
              . $nbsp;

      return array('compose_button_row' => $output);

   }
   else
   {

      echo '<input type="button" value="' . $button_value
         . '" onclick="' . $button_script . '">' . "\n";

   }


}



