<?php

/**
  * SquirrelMail Restrict Senders Plugin
  * Copyright (c) 2004-2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage restrict_senders
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_restrict_senders() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['configtest']['restrict_senders'] 
      = 'restrict_senders_configtest';
   $squirrelmail_plugin_hooks['compose_send']['restrict_senders'] 
      = 'check_restrict_senders';
   $squirrelmail_plugin_hooks['generic_header']['restrict_senders'] 
      = 'display_error_on_compose_screen';

}



/**
  * Returns info about this plugin
  *
  */
function restrict_senders_info()
{

   return array(
                  'english_name' => 'Restrict Senders',
                  'authors' => array(
                     'Paul Lesniewski' => array(
                        'email' => 'paul@squirrelmail.org',
                        'sm_site_username' => 'pdontthink',
                     ),
                  ),
                  'version' => '1.4',
                  'required_sm_version' => '1.4.1',
                  'requires_configuration' => 1,
                  'requires_source_patch' => 0,
                  'summary' => 'Allows complex controls of outgoing email.  Helps limit outgoing spam and/or restrict destination addresses.',
                  'details' => 'This plugin allows you to place restrictions on the destination addresses of all outgoing email and/or the amount of mail sent by any one user with a certain time period (ONLY email that is sent using SquirrelMail is monitored).<br /><br />Destination addresses can be restricted such that you may limit the total number of recipients for all outgoing emails (an anti-spam tactic) or you may limit the addresses/domains to which your users are allowed or disallowed to send mail to.  Recipient address restrictions may be defined on a per-user or per-domain basis, or for all of your users.<br /><br />Email alerts can also be sent to the system administrator when a user has attempted to send too many emails in a day or one email with too many recipients, and users who continue to send out too many "mass emails" in a short period of time may be banned from sending any more messages whatsoever.  Each of these restrictions may be defined on a per-user or per-domain basis by using the Login Manager (vlogin) plugin to override the corresponding settings.<br /><br />Please note that this plugin is a poor replacement for real SMTP filtering, which provides the same functionality no matter what email client your users are using (it will also be much faster).  This plugin will work ONLY for email sent using SquirrelMail.',
                  'required_plugins' => array(
                     'compatibility' => array(
                        'version' => '2.0.10',
                        'activate' => FALSE,
                     )
                  )
               );

}



/**
  * Returns version info about this plugin
  *
  */
function restrict_senders_version() 
{

   $info = restrict_senders_info();
   return $info['version'];

}



/**
  * Displays any errors that blocked email from 
  * sending back on top of compose screen
  *
  */
function display_error_on_compose_screen() 
{

   include_once(SM_PATH . 'plugins/restrict_senders/functions.php');
   display_error_on_compose_screen_do();

}



/**
  * Checks send restrictions when sending an email
  *
  */
function check_restrict_senders(&$argv) 
{

   include_once(SM_PATH . 'plugins/restrict_senders/functions.php');
   return check_restrict_senders_do($argv);

}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function restrict_senders_configtest()
{

   include_once(SM_PATH . 'plugins/restrict_senders/functions.php');
   return restrict_senders_configtest_do();

}



