<?php

/**
  * SquirrelMail Reset User Preferences Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage reset_prefs
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_reset_prefs()
{

   global $squirrelmail_plugin_hooks;


   // catch reset action
   //
   $squirrelmail_plugin_hooks['loading_prefs']['reset_prefs']
      = 'rp_reset_prefs';


   // show options on personal information page
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_personal']['reset_prefs']
      = 'reset_prefs_display_options';


   // show note on main options page after button press
   //
   $squirrelmail_plugin_hooks['optpage_set_loadinfo']['reset_prefs']
      = 'reset_prefs_saved_options';
   $squirrelmail_plugin_hooks['options_save']['reset_prefs']
      = 'reset_prefs_saved_options';


   // returns a list of preference names that should not
   // be controllable by the end user
   //
   $squirrelmail_plugin_hooks['reset_user_prefs']['reset_prefs']
      = 'rp_sensitive_preference_names';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['reset_prefs']
      = 'reset_prefs_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function reset_prefs_info()
{

   return array(
                 'english_name' => 'Reset User Preferences',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.2',
                 'required_sm_version' => '1.4.9',
                 'requires_configuration' => 0,
                 'summary' => 'Allows users to back up, reset and revert their SquirrelMail preference settings.',
                 'details' => 'This plugin allows users to back up all their SquirrelMail preference settings, revert to any previously saved preference sets, and reset all preferences to default values.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'requires_source_patch' => 0,
                       'required_plugins' => array()
                    ),
                    '1.5.0' => array(
                       'requires_source_patch' => 1,
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.16' => array(
                       'requires_source_patch' => 0,
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array()
                    ),
                    '1.4.9' => array(
                       'requires_source_patch' => 1,
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function reset_prefs_version()
{
   $info = reset_prefs_info();
   return $info['version'];
}



/**
  * Reset user preferences
  *
  */
function rp_reset_prefs()
{
   include_once(SM_PATH . 'plugins/reset_prefs/functions.php');
   return rp_reset_prefs_do();
}



/**
  * Display user configuration options on personal information page
  *
  */
function reset_prefs_display_options()
{
   include_once(SM_PATH . 'plugins/reset_prefs/functions.php');
   reset_prefs_display_options_do();
}



/**
  * Show note on main options page after button press
  *
  */
function reset_prefs_saved_options()
{
   include_once(SM_PATH . 'plugins/reset_prefs/functions.php');
   reset_prefs_saved_options_do();
}



/**
  * Returns a list of preference names that should not
  * be controllable by the end user
  *
  * @return string A comma-delimited list of preference
  *                names that the end-user should not
  *                have control over.
  *
  */
function rp_sensitive_preference_names()
{
   include_once(SM_PATH . 'plugins/reset_prefs/functions.php');
   return rp_sensitive_preference_names_do();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function reset_prefs_check_configuration()
{
   include_once(SM_PATH . 'plugins/reset_prefs/functions.php');
   return reset_prefs_check_configuration_do();
}



