<?php

/**
  * SquirrelMail Reset User Preferences Plugin
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage reset_prefs
  *
  */

global $rp_automatic_backup, $rp_allow_delete, $rp_allow_reset,
       $rp_allow_revert, $rp_allow_backup, $backup_list_style;


// Should prefernce set backups be made automatically
// when the user clicks the "reset" or "revert" buttons?
//
// 1 = yes, 0 (zero) = no
//
$rp_automatic_backup = 0;



// Should the user be allowed to delete preference
// set backups?
//
// 1 = yes, 0 (zero) = no
//
$rp_allow_delete = 1;



// You can choose the layout scheme used for the
// backup list on the user's Personal Information
// options page.
//
// 1 = text list
// 2 = multiple select box
//
$backup_list_style = 1;



// Should the user be allowed to make their own
// preference backup sets?  (Adds a "backup"
// button on the Personal Information options
// screen.)
//
// 1 = yes, 0 (zero) = no
//
$rp_allow_backup = 1;



// Should the user be allowed to reset their user
// preferences?  (Adds a "reset" button on the
// Personal Information options screen.)
//
// 1 = yes, 0 (zero) = no
//
$rp_allow_reset = 1;



// Should the user be allowed to revert their user
// preferences to a previous (backup) state?  (Adds
// a "revert" button on the Personal Information
// options screen.)
//
// 1 = yes, 0 (zero) = no
//
$rp_allow_revert = 1;



